/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.theme.JsonArray;
import org.eclipse.rap.rwt.internal.theme.JsonObject;
import org.eclipse.rap.rwt.internal.theme.JsonValue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class JsonUtil {
    JsonUtil() {
    }

    static JsonValue createJsonObject(Map properties) {
        JsonValue result;
        if (properties != null) {
            JsonObject object = new JsonObject();
            Object[] keys = properties.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                String key = (String)keys[i];
                object.append(key, JsonUtil.createJsonValue(properties.get(key)));
                ++i;
            }
            result = object;
        } else {
            result = JsonValue.NULL;
        }
        return result;
    }

    static JsonValue createJsonArray(Object[] values) {
        JsonValue result;
        if (values != null) {
            JsonArray array = new JsonArray();
            int i = 0;
            while (i < values.length) {
                array.append(JsonUtil.createJsonValue(values[i]));
                ++i;
            }
            result = array;
        } else {
            result = JsonValue.NULL;
        }
        return result;
    }

    static JsonValue createJsonValue(Object value) {
        JsonValue result;
        if (value == null) {
            result = JsonValue.NULL;
        } else if (value instanceof String) {
            result = JsonObject.valueOf((String)value);
        } else if (value instanceof Byte) {
            result = JsonObject.valueOf(((Byte)value).intValue());
        } else if (value instanceof Short) {
            result = JsonObject.valueOf(((Short)value).intValue());
        } else if (value instanceof Integer) {
            result = JsonObject.valueOf((Integer)value);
        } else if (value instanceof Long) {
            result = JsonObject.valueOf((Long)value);
        } else if (value instanceof Double) {
            result = JsonObject.valueOf((Double)value);
        } else if (value instanceof Float) {
            result = JsonObject.valueOf(((Float)value).floatValue());
        } else if (value instanceof Boolean) {
            result = JsonObject.valueOf((Boolean)value);
        } else if (value instanceof int[]) {
            result = JsonArray.valueOf((int[])value);
        } else if (value instanceof boolean[]) {
            result = JsonArray.valueOf((boolean[])value);
        } else if (value instanceof Object[]) {
            result = JsonUtil.createJsonArray((Object[])value);
        } else if (value instanceof Map) {
            result = JsonUtil.createJsonObject((Map)value);
        } else if (value instanceof JsonValue) {
            result = (JsonValue)value;
        } else {
            String message = "Parameter object can not be converted to JSON value: " + value;
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    public static Object[] jsonToJava(JSONArray object) {
        Object[] result = new Object[object.length()];
        try {
            int i = 0;
            while (i < result.length) {
                result[i] = JsonUtil.jsonToJava(object.get(i));
                ++i;
            }
        }
        catch (JSONException jSONException) {}
        return result;
    }

    public static Object jsonToJava(JSONObject object) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] propertiyNames = JSONObject.getNames(object);
        int i = 0;
        while (i < propertiyNames.length) {
            try {
                result.put(propertiyNames[i], JsonUtil.jsonToJava(object.get(propertiyNames[i])));
            }
            catch (JSONException jSONException) {
                throw new RuntimeException("Unable to convert JSONObject to Java: " + object);
            }
            ++i;
        }
        return result;
    }

    private static Object jsonToJava(Object object) {
        Object result = object;
        if (object instanceof JSONArray) {
            result = JsonUtil.jsonToJava((JSONArray)object);
        } else if (object instanceof JSONObject) {
            result = JsonUtil.jsonToJava((JSONObject)object);
        }
        return result;
    }
}

