/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.remote;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteObjectImpl
implements RemoteObject,
Serializable {
    private final String id;
    private final List<RenderRunnable> renderQueue;
    private boolean destroyed;
    private OperationHandler handler;

    public RemoteObjectImpl(final String id, final String createType) {
        this.id = id;
        this.destroyed = false;
        this.renderQueue = new ArrayList<RenderRunnable>();
        if (createType != null) {
            this.renderQueue.add(new RenderRunnable(){

                public void render(ProtocolMessageWriter writer) {
                    writer.appendCreate(id, createType);
                }
            });
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void set(final String name, final int value) {
        ParamCheck.notNullOrEmpty(name, "name");
        this.checkState();
        this.renderQueue.add(new RenderRunnable(){

            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(RemoteObjectImpl.this.id, name, value);
            }
        });
    }

    @Override
    public void set(final String name, final double value) {
        ParamCheck.notNullOrEmpty(name, "name");
        this.checkState();
        this.renderQueue.add(new RenderRunnable(){

            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(RemoteObjectImpl.this.id, name, value);
            }
        });
    }

    @Override
    public void set(final String name, final boolean value) {
        ParamCheck.notNullOrEmpty(name, "name");
        this.checkState();
        this.renderQueue.add(new RenderRunnable(){

            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(RemoteObjectImpl.this.id, name, value);
            }
        });
    }

    @Override
    public void set(final String name, final String value) {
        ParamCheck.notNullOrEmpty(name, "name");
        this.checkState();
        this.renderQueue.add(new RenderRunnable(){

            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(RemoteObjectImpl.this.id, name, value);
            }
        });
    }

    @Override
    public void set(final String name, final Object value) {
        ParamCheck.notNullOrEmpty(name, "name");
        this.checkState();
        this.renderQueue.add(new RenderRunnable(){

            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(RemoteObjectImpl.this.id, name, value);
            }
        });
    }

    @Override
    public void listen(final String eventType, final boolean listen) {
        ParamCheck.notNullOrEmpty(eventType, "eventType");
        this.checkState();
        this.renderQueue.add(new RenderRunnable(){

            public void render(ProtocolMessageWriter writer) {
                writer.appendListen(RemoteObjectImpl.this.id, eventType, listen);
            }
        });
    }

    @Override
    public void call(final String method, final Map<String, Object> properties) {
        ParamCheck.notNullOrEmpty(method, "method");
        this.checkState();
        this.renderQueue.add(new RenderRunnable(){

            public void render(ProtocolMessageWriter writer) {
                writer.appendCall(RemoteObjectImpl.this.id, method, properties);
            }
        });
    }

    @Override
    public void destroy() {
        this.checkState();
        this.renderQueue.add(new RenderRunnable(){

            public void render(ProtocolMessageWriter writer) {
                writer.appendDestroy(RemoteObjectImpl.this.id);
            }
        });
        this.destroyed = true;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void setHandler(OperationHandler handler) {
        this.handler = handler;
    }

    public OperationHandler getHandler() {
        return this.handler;
    }

    public void render(ProtocolMessageWriter writer) {
        for (RenderRunnable runnable : this.renderQueue) {
            runnable.render(writer);
        }
        this.renderQueue.clear();
    }

    void checkState() {
        if (!ContextProvider.hasContext()) {
            throw new IllegalStateException("Remote object called from wrong thread");
        }
        if (this.destroyed) {
            throw new IllegalStateException("Remote object is destroyed");
        }
    }

    public static interface RenderRunnable {
        public void render(ProtocolMessageWriter var1);
    }
}

