/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.WebClient;
import org.eclipse.rap.rwt.internal.RWTMessages;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rap.rwt.internal.lifecycle.RequestCounter;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.RequestParameterBuffer;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.service.StartupJson;
import org.eclipse.rap.rwt.internal.service.StartupPage;
import org.eclipse.rap.rwt.internal.service.UISessionBuilder;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.theme.JsonValue;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.UISession;

public class LifeCycleServiceHandler
implements ServiceHandler {
    private static final String PROP_ERROR = "error";
    private static final String PROP_MESSAGE = "message";
    private static final String SESSION_STARTED = String.valueOf(LifeCycleServiceHandler.class.getName()) + "#isSessionStarted";
    private final LifeCycleFactory lifeCycleFactory;
    private final StartupPage startupPage;

    public LifeCycleServiceHandler(LifeCycleFactory lifeCycleFactory, StartupPage startupPage) {
        this.lifeCycleFactory = lifeCycleFactory;
        this.startupPage = startupPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        Object object = uiSession.getRequestLock();
        synchronized (object) {
            this.synchronizedService(request, response);
        }
    }

    void synchronizedService(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("POST".equals(request.getMethod())) {
            try {
                this.handlePostRequest(request, response);
            }
            finally {
                LifeCycleServiceHandler.markSessionStarted();
            }
        } else {
            this.handleGetRequest((ServletRequest)request, response);
        }
    }

    private void handleGetRequest(ServletRequest request, HttpServletResponse response) throws IOException {
        Map parameters = request.getParameterMap();
        RequestParameterBuffer.store(parameters);
        if (RWT.getClient() instanceof WebClient) {
            this.startupPage.send(response);
        } else {
            StartupJson.send(response);
        }
    }

    private void handlePostRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LifeCycleServiceHandler.setJsonResponseHeaders((ServletResponse)response);
        if (LifeCycleServiceHandler.isSessionTimeout()) {
            LifeCycleServiceHandler.handleSessionTimeout(response);
        } else if (!LifeCycleServiceHandler.isRequestCounterValid()) {
            LifeCycleServiceHandler.handleInvalidRequestCounter(response);
        } else {
            if (LifeCycleServiceHandler.isSessionRestart()) {
                LifeCycleServiceHandler.reinitializeUISession(request);
                LifeCycleServiceHandler.reinitializeServiceStore();
            }
            RequestParameterBuffer.merge();
            this.runLifeCycle();
        }
        LifeCycleServiceHandler.writeProtocolMessage((ServletResponse)response);
    }

    private void runLifeCycle() throws IOException {
        if (LifeCycleServiceHandler.hasInitializeParameter()) {
            RemoteObjectLifeCycleAdapter.readData();
        }
        LifeCycle lifeCycle = this.lifeCycleFactory.getLifeCycle();
        lifeCycle.execute();
    }

    private static boolean isRequestCounterValid() {
        return LifeCycleServiceHandler.hasInitializeParameter() || RequestCounter.getInstance().isValid();
    }

    private static void handleInvalidRequestCounter(HttpServletResponse response) {
        int statusCode = 412;
        String errorType = "invalid request counter";
        String errorMessage = RWTMessages.getMessage("RWT_MultipleInstancesErrorMessage");
        LifeCycleServiceHandler.renderError(response, statusCode, errorType, LifeCycleServiceHandler.formatMessage(errorMessage));
    }

    private static void handleSessionTimeout(HttpServletResponse response) {
        int statusCode = 403;
        String errorType = "session timeout";
        String errorMessage = RWTMessages.getMessage("RWT_SessionTimeoutErrorMessage");
        LifeCycleServiceHandler.renderError(response, statusCode, errorType, LifeCycleServiceHandler.formatMessage(errorMessage));
    }

    private static String formatMessage(String message) {
        Object[] arguments = new Object[]{"<a {HREF_URL}>", "</a>"};
        return MessageFormat.format(message, arguments);
    }

    private static void renderError(HttpServletResponse response, int statusCode, String errorType, String errorMessage) {
        response.setStatus(statusCode);
        ProtocolMessageWriter writer = ContextProvider.getProtocolWriter();
        writer.appendHead(PROP_ERROR, JsonValue.valueOf(errorType));
        writer.appendHead(PROP_MESSAGE, JsonValue.valueOf(errorMessage));
    }

    private static void reinitializeUISession(HttpServletRequest request) {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        Map<String, String[]> bufferedParameters = RequestParameterBuffer.getBufferedParameters();
        ApplicationContextImpl applicationContext = ApplicationContextUtil.get(uiSession);
        uiSession.valueUnbound(null);
        UISessionBuilder builder = new UISessionBuilder(applicationContext, request);
        uiSession = (UISessionImpl)builder.buildUISession();
        ContextProvider.getContext().setUISession(uiSession);
        if (bufferedParameters != null) {
            RequestParameterBuffer.store(bufferedParameters);
        }
    }

    private static void reinitializeServiceStore() {
        ClientMessage clientMessage = ProtocolUtil.getClientMessage();
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.clear();
        ProtocolUtil.setClientMessage(clientMessage);
    }

    private static boolean isSessionRestart() {
        return LifeCycleServiceHandler.isSessionStarted() && LifeCycleServiceHandler.hasInitializeParameter();
    }

    private static boolean isSessionTimeout() {
        return !LifeCycleServiceHandler.isSessionStarted() && !LifeCycleServiceHandler.hasInitializeParameter();
    }

    static void markSessionStarted() {
        UISession uiSession = ContextProvider.getUISession();
        uiSession.setAttribute(SESSION_STARTED, Boolean.TRUE);
    }

    private static boolean isSessionStarted() {
        UISession uiSession = ContextProvider.getUISession();
        return Boolean.TRUE.equals(uiSession.getAttribute(SESSION_STARTED));
    }

    private static boolean hasInitializeParameter() {
        return "true".equals(ProtocolUtil.readHeadPropertyValue("rwt_initialize"));
    }

    private static void setJsonResponseHeaders(ServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
    }

    private static void writeProtocolMessage(ServletResponse response) throws IOException {
        ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
        String message = protocolWriter.createMessage();
        response.getWriter().write(message);
    }
}

