/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

public abstract class JsonValue {
    public static final JsonValue NULL = new JsonPrimitive("null");
    public static final JsonValue TRUE = new JsonPrimitive("true");
    public static final JsonValue FALSE = new JsonPrimitive("false");
    private static final int CONTROL_CHARACTERS_START = 0;
    private static final int CONTROL_CHARACTERS_END = 31;

    JsonValue() {
    }

    public static JsonValue valueOf(int value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(long value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(float value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(double value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static JsonValue valueOf(String value) {
        JsonValue result = value == null ? NULL : new JsonPrimitive(JsonValue.quoteAndEscapeString(value));
        return result;
    }

    static String quoteAndEscapeString(String string) {
        StringBuilder buffer = new StringBuilder(string.length() + 2);
        JsonValue.appendQuotedAndEscapedString(buffer, string);
        return buffer.toString();
    }

    static void appendQuotedAndEscapedString(StringBuilder buffer, String string) {
        buffer.append('\"');
        JsonValue.appendEscapedString(buffer, string);
        buffer.append('\"');
    }

    static void appendEscapedString(StringBuilder buffer, String string) {
        char[] chars = string.toCharArray();
        int length = chars.length;
        int i = 0;
        while (i < length) {
            char ch = chars[i];
            if (ch == '\"' || ch == '\\') {
                buffer.append('\\');
                buffer.append(ch);
            } else if (ch == '\n') {
                buffer.append('\\');
                buffer.append('n');
            } else if (ch == '\r') {
                buffer.append('\\');
                buffer.append('r');
            } else if (ch == '\t') {
                buffer.append('\\');
                buffer.append('t');
            } else if (ch == '\u2028') {
                buffer.append("\\u2028");
            } else if (ch == '\u2029') {
                buffer.append("\\u2029");
            } else if (ch >= '\u0000' && ch <= '\u001f') {
                buffer.append("\\u00");
                if (ch <= '\u000f') {
                    buffer.append('0');
                }
                buffer.append(Integer.toHexString(ch));
            } else {
                buffer.append(ch);
            }
            ++i;
        }
    }

    private static class JsonPrimitive
    extends JsonValue {
        private final String value;

        JsonPrimitive(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

