/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.internal.theme.ThemePropertyAdapterRegistry;
import org.eclipse.rap.rwt.internal.theme.ThemeResource;
import org.eclipse.rap.rwt.service.ResourceLoader;

public class QxCursor
implements QxType,
ThemeResource {
    private static final String CURSOR_DEST_PATH = "themes/cursors";
    private static final String[] PREDEFINED_CURSORS = new String[]{"default", "wait", "crosshair", "help", "move", "text", "pointer", "e-resize", "n-resize", "w-resize", "s-resize", "ne-resize", "se-resize", "nw-resize", "sw-resize", "col-resize", "row-resize", "progress", "not-allowed", "no-drop"};
    public final String value;
    public final ResourceLoader loader;

    private QxCursor(String value, ResourceLoader loader) {
        this.value = value;
        this.loader = loader;
        if (this.isCustomCursor()) {
            try {
                InputStream inputStream = loader.getResourceAsStream(value);
                if (inputStream == null) {
                    throw new IllegalArgumentException("Failed to read cursor '" + value + "'");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read cursor " + value + ": " + e.getMessage());
            }
        }
    }

    public static QxCursor valueOf(String input, ResourceLoader loader) {
        if (input == null || loader == null) {
            throw new NullPointerException("null argument");
        }
        if (input.length() == 0) {
            throw new IllegalArgumentException("Empty cursor path");
        }
        return new QxCursor(input, loader);
    }

    public static QxCursor valueOf(String input) {
        if (!QxCursor.isPredefinedCursor(input)) {
            throw new IllegalArgumentException("Invalid value for cursor: " + input);
        }
        return new QxCursor(input, null);
    }

    public static boolean isPredefinedCursor(String value) {
        boolean result = false;
        int i = 0;
        while (i < PREDEFINED_CURSORS.length && !result) {
            if (PREDEFINED_CURSORS[i].equalsIgnoreCase(value)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public boolean isCustomCursor() {
        return !QxCursor.isPredefinedCursor(this.value);
    }

    public String getResourcePath() {
        String result = null;
        if (this.isCustomCursor()) {
            ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance();
            ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(QxCursor.class);
            String cssKey = adapter.getKey(this);
            result = "themes/cursors/" + cssKey;
        }
        return result;
    }

    public InputStream getResourceAsStream() throws IOException {
        InputStream inputStream = null;
        if (this.isCustomCursor()) {
            inputStream = this.loader.getResourceAsStream(this.value);
        }
        return inputStream;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object instanceof QxCursor) {
            QxCursor other = (QxCursor)object;
            result = (this.value == null ? other.value == null : this.value.equals(other.value)) && (this.loader == null ? other.loader == null : this.loader.equals(other.loader));
        }
        return result;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toDefaultString() {
        return this.isCustomCursor() ? "" : this.value;
    }

    public String toString() {
        return "QxCursor{ " + this.value + " }";
    }
}

