/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.progressbarkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;

public class ProgressBarLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ProgressBar";
    private static final String[] ALLOWED_STYLES = new String[]{"SMOOTH", "HORIZONTAL", "VERTICAL", "INDETERMINATE", "BORDER"};
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_SELECTION = "selection";
    static final String PROP_STATE = "state";
    private static final Integer DEFAULT_MINIMUM = new Integer(0);
    private static final Integer DEFAULT_MAXIMUM = new Integer(100);
    private static final Integer DEFAULT_SELECTION = new Integer(0);
    private static final String DEFAULT_STATE = "normal";

    public void preserveValues(Widget widget) {
        ProgressBar progressBar = (ProgressBar)widget;
        ControlLCAUtil.preserveValues(progressBar);
        WidgetLCAUtil.preserveCustomVariant(progressBar);
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_MINIMUM, new Integer(progressBar.getMinimum()));
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_MAXIMUM, new Integer(progressBar.getMaximum()));
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_SELECTION, new Integer(progressBar.getSelection()));
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_STATE, ProgressBarLCA.getState(progressBar));
    }

    public void readData(Widget widget) {
        ProgressBar progressBar = (ProgressBar)widget;
        ControlLCAUtil.processEvents(progressBar);
        ControlLCAUtil.processKeyEvents(progressBar);
        ControlLCAUtil.processMenuDetect(progressBar);
        WidgetLCAUtil.processHelp(progressBar);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ProgressBar progressBar = (ProgressBar)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(progressBar);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(progressBar.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(progressBar, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        ProgressBar pBar = (ProgressBar)widget;
        ControlLCAUtil.renderChanges(pBar);
        WidgetLCAUtil.renderCustomVariant(pBar);
        WidgetLCAUtil.renderProperty((Widget)pBar, PROP_MINIMUM, new Integer(pBar.getMinimum()), DEFAULT_MINIMUM);
        WidgetLCAUtil.renderProperty((Widget)pBar, PROP_MAXIMUM, new Integer(pBar.getMaximum()), DEFAULT_MAXIMUM);
        WidgetLCAUtil.renderProperty((Widget)pBar, PROP_SELECTION, new Integer(pBar.getSelection()), DEFAULT_SELECTION);
        WidgetLCAUtil.renderProperty((Widget)pBar, PROP_STATE, ProgressBarLCA.getState(pBar), DEFAULT_STATE);
    }

    private static String getState(ProgressBar progressBar) {
        String result = DEFAULT_STATE;
        int state = progressBar.getState();
        if (state == 1) {
            result = "error";
        } else if (state == 4) {
            result = "paused";
        }
        return result;
    }
}

