/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rap.demo.controls.ColorChooser;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

abstract class ExampleTab
implements Serializable {
    public static final int BG_COLOR_GREEN = 1;
    public static final int BG_COLOR_BLUE = 2;
    public static final int BG_COLOR_BROWN = 3;
    public static final int FG_COLOR_RED = 1;
    public static final int FG_COLOR_BLUE = 2;
    public static final int FG_COLOR_ORANGE = 3;
    public static final int BGG_COLOR_GREEN = 1;
    public static final int BGG_COLOR_BLUE = 2;
    protected final List<Control> controls;
    private Composite exampleComp;
    protected Composite styleComp;
    protected Color[] bgColors;
    protected Color[] fgColors;
    protected Color[] gradientColors;
    private Font font;
    private int fgIndex;
    private int bgIndex;
    private int rbIndex;
    private boolean showBgImage = false;
    private boolean showBgGradient = false;
    private boolean visible = true;
    private boolean enabled = true;
    private Text text;
    private final StringBuffer content = new StringBuffer();
    private FontDialog fontChooser;
    private ColorChooser fgColorChooser;
    private ColorChooser bgColorChooser;
    private int defaultStyle = 0;
    private final Set<String> properties = new HashSet<String>();
    private Object data;
    private static final String[] SWT_CURSORS = new String[]{"null", "CURSOR_ARROW", "CURSOR_WAIT", "CURSOR_APPSTARTING", "CURSOR_CROSS", "CURSOR_HELP", "CURSOR_NO", "CURSOR_SIZEALL", "CURSOR_SIZENESW", "CURSOR_SIZENS", "CURSOR_SIZENWSE", "CURSOR_SIZEWE", "CURSOR_SIZEN", "CURSOR_SIZES", "CURSOR_SIZEE", "CURSOR_SIZEW", "CURSOR_SIZENE", "CURSOR_SIZESE", "CURSOR_SIZESW", "CURSOR_SIZENW", "CURSOR_IBEAM", "CURSOR_HAND", "CURSOR_UPARROW"};
    private final String name;
    private Shell shell;

    public ExampleTab(String name) {
        this.name = name;
        this.controls = new ArrayList<Control>();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        String id = this.getClass().getSimpleName();
        if (id.endsWith("Tab")) {
            id = id.substring(0, id.length() - 3);
        }
        return id;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void createContents(Composite parent) {
        this.shell = parent.getShell();
        this.createSashForm(parent);
        this.initColors(parent.getDisplay());
        this.createExampleControls(this.exampleComp);
        this.createStyleControls(this.styleComp);
        this.exampleComp.layout();
        this.styleComp.layout();
    }

    protected void createNew() {
        this.controls.clear();
        this.destroyExampleControls();
        this.createExampleControls(this.exampleComp);
        this.updateVisible();
        this.updateEnabled();
        if (this.fgColorChooser != null) {
            this.updateFgColor();
        }
        if (this.bgColorChooser != null) {
            this.updateBgColor();
        }
        this.updateBgImage();
        this.updateBgGradient();
        if (this.fontChooser != null) {
            this.updateFont();
        }
        this.exampleComp.layout();
    }

    private Control createSashForm(Composite parent) {
        SashForm vertSashForm = new SashForm(parent, 512);
        SashForm horSashForm = new SashForm((Composite)vertSashForm, 256);
        this.createLeft((Composite)horSashForm);
        this.createRight((Composite)horSashForm);
        this.createFoot((Composite)vertSashForm);
        horSashForm.setWeights(new int[]{50, 50});
        vertSashForm.setWeights(new int[]{93, 7});
        return vertSashForm;
    }

    private void createLeft(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        composite.setLayout((Layout)new FormLayout());
        Label header = new Label(composite, 0x1000000);
        header.setFont(ExampleTab.getHeaderFont(parent));
        header.setText(this.getName());
        header.setLayoutData(ExampleTab.createLayoutDataForHeader());
        this.exampleComp = new Composite(composite, 0);
        this.exampleComp.setLayoutData(ExampleTab.createLayoutDataForExampleArea((Control)header));
    }

    private void createRight(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        composite.setLayout((Layout)new FormLayout());
        Label header = new Label(composite, 16384);
        header.setText("Styles and Parameters");
        header.setLayoutData(ExampleTab.createLayoutDataForHeader());
        this.styleComp = new Composite(composite, 0);
        this.styleComp.setLayoutData(ExampleTab.createLayoutDataForExampleArea((Control)header));
        this.styleComp.setLayout((Layout)new RowLayout(512));
    }

    private void createFoot(Composite parent) {
        this.text = new Text(parent, 10);
        this.text.setText("---");
    }

    private static Font getHeaderFont(Composite parent) {
        String fontName = parent.getFont().getFontData()[0].getName();
        return new Font((Device)parent.getDisplay(), fontName, 18, 1);
    }

    private static Object createLayoutDataForHeader() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, -10);
        return formData;
    }

    private static Object createLayoutDataForExampleArea(Control control) {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 35);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        return formData;
    }

    private void initColors(Display display) {
        Color[] colorArray = new Color[4];
        colorArray[1] = new Color((Device)display, 154, 205, 50);
        colorArray[2] = new Color((Device)display, 105, 89, 205);
        colorArray[3] = new Color((Device)display, 192, 172, 137);
        this.bgColors = colorArray;
        Color[] colorArray2 = new Color[4];
        colorArray2[1] = new Color((Device)display, 194, 0, 23);
        colorArray2[2] = new Color((Device)display, 28, 96, 141);
        colorArray2[3] = new Color((Device)display, 249, 158, 0);
        this.fgColors = colorArray2;
        this.gradientColors = new Color[]{new Color((Device)display, 0, 0, 255), new Color((Device)display, 0, 255, 0), new Color((Device)display, 0, 0, 255), new Color((Device)display, 0, 255, 0), new Color((Device)display, 0, 0, 255)};
    }

    protected abstract void createStyleControls(Composite var1);

    protected abstract void createExampleControls(Composite var1);

    protected void setDefaultStyle(int style) {
        this.defaultStyle = style;
    }

    protected Button createStyleButton(String fieldName, int style) {
        return this.createStyleButton(fieldName, style, false);
    }

    protected Button createStyleButton(String name, int style, boolean checked) {
        Button button = new Button(this.styleComp, 32);
        button.setText(name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.createNew();
            }
        });
        button.setData("style", (Object)new Integer(style));
        button.setSelection(checked);
        return button;
    }

    protected Button createPropertyButton(String text) {
        return this.createPropertyButton(text, 32);
    }

    protected Button createPropertyButton(String text, int style) {
        Button button = new Button(this.styleComp, style);
        button.setText(text);
        return button;
    }

    protected Button createPropertyCheckbox(String text, String prop) {
        return this.createPropertyCheckbox(text, prop, false);
    }

    protected Button createPropertyCheckbox(String text, final String prop, boolean checked) {
        final Button button = new Button(this.styleComp, 32);
        button.setText(text);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    ExampleTab.this.properties.add(prop);
                } else {
                    ExampleTab.this.properties.remove(prop);
                }
                ExampleTab.this.createNew();
            }
        });
        return button;
    }

    public final boolean hasCreateProperty(String name) {
        return this.properties.contains(name);
    }

    protected Button createVisibilityButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Visible");
        button.setSelection(this.visible);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.visible = button.getSelection();
                ExampleTab.this.updateVisible();
            }
        });
        return button;
    }

    protected Button createEnablementButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Enabled");
        button.setSelection(this.enabled);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.enabled = button.getSelection();
                ExampleTab.this.updateEnabled();
            }
        });
        return button;
    }

    protected Button createFgColorButton() {
        this.fgColorChooser = new ColorChooser();
        Button button = new Button(this.styleComp, 8);
        button.setText("Foreground");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.fgIndex = (ExampleTab.this.fgIndex + 1) % ExampleTab.this.fgColors.length;
                ExampleTab.this.updateFgColor();
            }
        });
        return button;
    }

    protected Button createBgColorButton() {
        this.bgColorChooser = new ColorChooser();
        Button button = new Button(this.styleComp, 8);
        button.setText("Background");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.bgIndex = (ExampleTab.this.bgIndex + 1) % ExampleTab.this.fgColors.length;
                ExampleTab.this.updateBgColor();
            }
        });
        return button;
    }

    protected Button createBgGradientButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Background Gradient");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.showBgGradient = button.getSelection();
                ExampleTab.this.updateBgGradient();
            }
        });
        return button;
    }

    protected Button createBgImageButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Background Image");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.showBgImage = button.getSelection();
                ExampleTab.this.updateBgImage();
            }
        });
        return button;
    }

    protected Button createFontChooser() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Font");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.fontChooser = new FontDialog(ExampleTab.this.getShell(), 0);
                Control control = ExampleTab.this.controls.get(0);
                ExampleTab.this.fontChooser.setFontList(control.getFont().getFontData());
                if (ExampleTab.this.fontChooser.open() != null) {
                    ExampleTab.this.font = new Font((Device)control.getDisplay(), ExampleTab.this.fontChooser.getFontList());
                }
                ExampleTab.this.updateFont();
            }
        });
        return button;
    }

    protected void createThemeSwitcher(final Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Theme Switcher");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = new Shell(parent.getShell(), 2144);
                shell.setText("Theme Switcher");
                shell.setLayout((Layout)new GridLayout());
                Button themeButton = new Button((Composite)shell, 8);
                themeButton.setText("Switch Theme");
                themeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
                    String[] availableThemeIds = ThemeUtil.getAvailableThemeIds();

                    public void widgetSelected(SelectionEvent e) {
                        int index = 0;
                        String currThemeId = ThemeUtil.getCurrentThemeId();
                        int i = 0;
                        while (i < this.availableThemeIds.length) {
                            if (currThemeId.equals(this.availableThemeIds[i])) {
                                index = (i + 1) % this.availableThemeIds.length;
                            }
                            ++i;
                        }
                        String newThemeId = this.availableThemeIds[index];
                        ThemeUtil.setCurrentThemeId((UISession)ContextProvider.getUISession(), (String)newThemeId);
                    }
                });
                shell.pack();
                shell.open();
            }
        });
    }

    protected Combo createCursorCombo() {
        Composite group = new Composite(this.styleComp, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        new Label(group, 0).setText("Cursor");
        final Combo combo = new Combo(group, 8);
        combo.setItems(SWT_CURSORS);
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = null;
                int index = combo.getSelectionIndex();
                if (index > 0) {
                    selection = combo.getItem(index);
                }
                ExampleTab.this.updateCursor(selection);
            }
        });
        return combo;
    }

    protected void cteateRoundedBorderGroup() {
        Group group = new Group(this.styleComp, 0);
        group.setText("Rounded Border");
        group.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)group, 0).setText("Width");
        final Text textWidth = new Text((Composite)group, 2052);
        textWidth.setLayoutData((Object)new GridData(20, -1));
        new Label((Composite)group, 0).setText("Color");
        final Button buttonColor = new Button((Composite)group, 8);
        buttonColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.rbIndex = (ExampleTab.this.rbIndex + 1) % ExampleTab.this.bgColors.length;
                if (ExampleTab.this.bgColors[ExampleTab.this.rbIndex] == null) {
                    buttonColor.setText("");
                } else {
                    buttonColor.setText("\u2588");
                }
                buttonColor.setForeground(ExampleTab.this.bgColors[ExampleTab.this.rbIndex]);
            }
        });
        new Label((Composite)group, 0).setText("Radius ");
        Composite radiusGroup = new Composite((Composite)group, 0);
        radiusGroup.setLayout((Layout)new GridLayout(4, false));
        new Label(radiusGroup, 0).setText("T-L");
        final Text textTopLeft = new Text(radiusGroup, 2052);
        textTopLeft.setLayoutData((Object)new GridData(20, -1));
        new Label(radiusGroup, 0).setText("T-R");
        final Text textTopRight = new Text(radiusGroup, 2052);
        textTopRight.setLayoutData((Object)new GridData(20, -1));
        new Label(radiusGroup, 0).setText("B-L");
        final Text textBottomLeft = new Text(radiusGroup, 2052);
        textBottomLeft.setLayoutData((Object)new GridData(20, -1));
        new Label(radiusGroup, 0).setText("B-R");
        final Text textBottomRight = new Text(radiusGroup, 2052);
        textBottomRight.setLayoutData((Object)new GridData(20, -1));
        Button button = new Button((Composite)group, 8);
        button.setText("Set");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int width = ExampleTab.this.parseInt(textWidth.getText());
                Color color = buttonColor.getForeground();
                int topLeft = ExampleTab.this.parseInt(textTopLeft.getText());
                int topRight = ExampleTab.this.parseInt(textTopRight.getText());
                int bottomRight = ExampleTab.this.parseInt(textBottomRight.getText());
                int bottomLeft = ExampleTab.this.parseInt(textBottomLeft.getText());
                ExampleTab.this.updateRoundedBorder(width, color, topLeft, topRight, bottomRight, bottomLeft);
            }
        });
    }

    protected void registerControl(final Control control) {
        this.controls.add(control);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ExampleTab.this.controls.remove(control);
            }
        });
    }

    protected void log(String msg) {
        this.content.insert(0, String.valueOf(msg.trim()) + this.text.getLineDelimiter());
        this.text.setText(this.content.toString());
    }

    protected Image loadImage(String name) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(name);
        Image result = new Image((Device)this.shell.getDisplay(), stream);
        try {
            stream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result;
    }

    private void destroyExampleControls() {
        Control[] controls = this.exampleComp.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
    }

    protected int getStyle() {
        int result = 0;
        Control[] ctrls = this.styleComp.getChildren();
        if (ctrls.length == 0) {
            result = this.defaultStyle;
        } else {
            int i = 0;
            while (i < ctrls.length) {
                Object data;
                Button button;
                if (ctrls[i] instanceof Button && (button = (Button)ctrls[i]).getSelection() && (data = button.getData("style")) instanceof Integer) {
                    int style = (Integer)data;
                    result |= style;
                }
                ++i;
            }
        }
        return result;
    }

    private void updateVisible() {
        for (Control control : this.controls) {
            control.setVisible(this.visible);
        }
    }

    private void updateEnabled() {
        for (Control control : this.controls) {
            control.setEnabled(this.enabled);
        }
    }

    private void updateFgColor() {
        for (Control control : this.controls) {
            control.setForeground(this.fgColors[this.fgIndex]);
        }
    }

    private void updateBgColor() {
        for (Control control : this.controls) {
            control.setBackground(this.bgColors[this.bgIndex]);
        }
    }

    private void updateBgGradient() {
        for (Control control : this.controls) {
            Object adapter = control.getAdapter(IWidgetGraphicsAdapter.class);
            IWidgetGraphicsAdapter gfxAdapter = (IWidgetGraphicsAdapter)adapter;
            if (this.showBgGradient) {
                int[] nArray = new int[5];
                nArray[1] = 25;
                nArray[2] = 50;
                nArray[3] = 75;
                nArray[4] = 100;
                int[] percents = nArray;
                gfxAdapter.setBackgroundGradient(this.gradientColors, percents, true);
                continue;
            }
            gfxAdapter.setBackgroundGradient(null, null, true);
        }
    }

    private void updateBgImage() {
        for (Control control : this.controls) {
            Image image = Util.loadImage(control.getDisplay(), "resources/pattern.png");
            control.setBackgroundImage((Image)(this.showBgImage ? image : null));
        }
    }

    private void updateFont() {
        for (Control control : this.controls) {
            control.setFont(this.font);
        }
        if (this.controls.size() > 0) {
            Composite parent = this.controls.get(0).getParent();
            parent.layout(true, true);
        }
    }

    private void updateCursor(String selection) {
        Cursor cursor = null;
        Class<SWT> swtClass = SWT.class;
        if (selection != null) {
            try {
                Field field = swtClass.getField(selection);
                int cursorStyle = field.getInt(swtClass);
                cursor = Display.getCurrent().getSystemCursor(cursorStyle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Control control : this.controls) {
            control.setCursor(cursor);
        }
    }

    private void updateRoundedBorder(int width, Color color, int topLeft, int topRight, int bottomRight, int bottomLeft) {
        for (Control control : this.controls) {
            Object adapter = control.getAdapter(IWidgetGraphicsAdapter.class);
            IWidgetGraphicsAdapter gfxAdapter = (IWidgetGraphicsAdapter)adapter;
            gfxAdapter.setRoundedBorder(width, color, topLeft, topRight, bottomRight, bottomLeft);
        }
    }

    private int parseInt(String text) {
        int result;
        try {
            result = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            result = -1;
        }
        return result;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected boolean checkControl(Control control) {
        return control != null && !control.isDisposed();
    }
}

