/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.osgi.internal;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

class ServletContextWrapper
implements ServletContext {
    private final ServletContext servletContext;
    private final Map<String, Object> attributes;

    ServletContextWrapper(ServletContext servletContext, String contextDirectory) {
        this.servletContext = servletContext;
        this.attributes = new HashMap<String, Object>();
        this.attributes.put("resource_root_location", contextDirectory);
    }

    public ServletContext getContext(String uripath) {
        return this.servletContext.getContext(uripath);
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public int getMajorVersion() {
        return this.servletContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.servletContext.getMinorVersion();
    }

    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.servletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.servletContext.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.servletContext.getNamedDispatcher(name);
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        return this.servletContext.getServlet(name);
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return this.servletContext.getServlets();
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return this.servletContext.getServletNames();
    }

    public void log(String msg) {
        this.servletContext.log(msg);
    }

    @Deprecated
    public void log(Exception exception, String msg) {
        this.servletContext.log(exception, msg);
    }

    @Deprecated
    public void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public String getServerInfo() {
        return this.servletContext.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.servletContext.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (this.isAttributeInWrappedContext(name)) {
                return this.servletContext.getAttribute(name);
            }
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        Enumeration<String> result;
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            result = this.servletContext.getAttributeNames();
            if (this.needEnumerationFromLocalAttributeBuffer(result)) {
                result = this.createAttributeNamesEnumeration();
            }
        }
        return result;
    }

    private boolean needEnumerationFromLocalAttributeBuffer(Enumeration<String> result) {
        return (result == null || !result.hasMoreElements()) && !this.attributes.isEmpty();
    }

    private Enumeration<String> createAttributeNamesEnumeration() {
        return new Enumeration<String>(){
            Iterator<String> names;
            {
                this.names = ServletContextWrapper.this.attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.names.hasNext();
            }

            @Override
            public String nextElement() {
                return this.names.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object object) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.servletContext.setAttribute(name, object);
            if (!this.isAttributeInWrappedContext(name)) {
                this.attributes.put(name, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (this.isAttributeInWrappedContext(name)) {
                this.servletContext.removeAttribute(name);
            } else {
                this.attributes.remove(name);
            }
        }
    }

    private boolean isAttributeInWrappedContext(String name) {
        return this.servletContext.getAttribute(name) != null;
    }

    public String getServletContextName() {
        return this.servletContext.getServletContextName();
    }

    public String getVirtualServerName() {
        return null;
    }

    public int getEffectiveMajorVersion() {
        return 0;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public boolean setInitParameter(String name, String value) {
        return false;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return null;
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return null;
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String className) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void declareRoles(String ... roleNames) {
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        return null;
    }

    public int getSessionTimeout() {
        return this.servletContext.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.servletContext.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.servletContext.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.servletContext.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.servletContext.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.servletContext.setResponseCharacterEncoding(encoding);
    }
}

