/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.osgi.container.Module;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SecureAction {
    private AccessControlContext controlContext = AccessController.getContext();
    static final ClassLoader bootClassLoader = AccessController.doPrivileged(() -> new ClassLoader(Object.class.getClassLoader()){});

    SecureAction() {
    }

    public static PrivilegedAction<SecureAction> createSecureAction() {
        return SecureAction::new;
    }

    public String getProperty(String property) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(property);
        }
        return AccessController.doPrivileged(() -> System.getProperty(property), this.controlContext);
    }

    public Properties getProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(System::getProperties, this.controlContext);
    }

    public FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileInputStream(file);
        }
        try {
            return AccessController.doPrivileged(() -> new FileInputStream(file), this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public FileOutputStream getFileOutputStream(File file, boolean append) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileOutputStream(file.getAbsolutePath(), append);
        }
        try {
            return AccessController.doPrivileged(() -> new FileOutputStream(file.getAbsolutePath(), append), this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public long length(File file) {
        if (System.getSecurityManager() == null) {
            return file.length();
        }
        return AccessController.doPrivileged(() -> file.length(), this.controlContext);
    }

    public String getCanonicalPath(File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return file.getCanonicalPath();
        }
        try {
            return AccessController.doPrivileged(() -> file.getCanonicalPath(), this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public File getAbsoluteFile(File file) {
        if (System.getSecurityManager() == null) {
            return file.getAbsoluteFile();
        }
        return AccessController.doPrivileged(() -> file.getAbsoluteFile(), this.controlContext);
    }

    public File getCanonicalFile(File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return file.getCanonicalFile();
        }
        try {
            return AccessController.doPrivileged(() -> file.getCanonicalFile(), this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public boolean exists(File file) {
        if (System.getSecurityManager() == null) {
            return file.exists();
        }
        return AccessController.doPrivileged(() -> file.exists() ? Boolean.TRUE : Boolean.FALSE, this.controlContext);
    }

    public boolean mkdirs(File file) {
        if (System.getSecurityManager() == null) {
            return file.mkdirs();
        }
        return AccessController.doPrivileged(() -> file.mkdirs() ? Boolean.TRUE : Boolean.FALSE, this.controlContext);
    }

    public boolean isDirectory(File file) {
        if (System.getSecurityManager() == null) {
            return file.isDirectory();
        }
        return AccessController.doPrivileged(() -> file.isDirectory() ? Boolean.TRUE : Boolean.FALSE, this.controlContext);
    }

    public long lastModified(File file) {
        if (System.getSecurityManager() == null) {
            return file.lastModified();
        }
        return AccessController.doPrivileged(() -> file.lastModified(), this.controlContext);
    }

    public String[] list(File file) {
        if (System.getSecurityManager() == null) {
            return file.list();
        }
        return AccessController.doPrivileged(() -> file.list(), this.controlContext);
    }

    public ZipFile getZipFile(File file, boolean verify) throws IOException {
        try {
            if (System.getSecurityManager() == null) {
                return new ZipFile(file);
            }
            try {
                return AccessController.doPrivileged(() -> {
                    if (verify) {
                        return new JarFile(file);
                    }
                    return new ZipFile(file);
                }, this.controlContext);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                throw (RuntimeException)e.getException();
            }
        }
        catch (ZipException e) {
            ZipException zipNameException = new ZipException("Exception in opening zip file: " + file.getPath());
            zipNameException.initCause(e);
            throw zipNameException;
        }
        catch (IOException e) {
            throw new IOException("Exception in opening zip file: " + file.getPath(), e);
        }
    }

    public URL getURL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() == null) {
            return new URL(protocol, host, port, file, handler);
        }
        try {
            return AccessController.doPrivileged(() -> new URL(protocol, host, port, file, handler), this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof MalformedURLException) {
                throw (MalformedURLException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public Thread createThread(Runnable target, String name, ClassLoader contextLoader) {
        if (System.getSecurityManager() == null) {
            return this.createThread0(target, name, contextLoader);
        }
        return AccessController.doPrivileged(() -> this.createThread0(target, name, contextLoader), this.controlContext);
    }

    Thread createThread0(Runnable target, String name, ClassLoader contextLoader) {
        Thread result = new Thread(target, name);
        if (contextLoader != null) {
            result.setContextClassLoader(contextLoader);
        }
        return result;
    }

    public <S> S getService(ServiceReference<S> reference, BundleContext context) {
        if (System.getSecurityManager() == null) {
            return context.getService(reference);
        }
        return (S)AccessController.doPrivileged(() -> context.getService(reference), this.controlContext);
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return Class.forName(name);
        }
        try {
            return AccessController.doPrivileged(() -> Class.forName(name), this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public Class<?> loadSystemClass(String name) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            return systemClassLoader != null ? systemClassLoader.loadClass(name) : bootClassLoader.loadClass(name);
        }
        try {
            return AccessController.doPrivileged(() -> {
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                return systemClassLoader != null ? systemClassLoader.loadClass(name) : bootClassLoader.loadClass(name);
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public void open(ServiceTracker<?, ?> tracker) {
        if (System.getSecurityManager() == null) {
            tracker.open();
            return;
        }
        AccessController.doPrivileged(() -> {
            tracker.open();
            return null;
        }, this.controlContext);
    }

    public void start(Module module, Module.StartOptions ... options) throws BundleException {
        if (System.getSecurityManager() == null) {
            module.start(options);
            return;
        }
        try {
            AccessController.doPrivileged(() -> {
                module.start(options);
                return null;
            }, this.controlContext);
            return;
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof BundleException) {
                throw (BundleException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public BundleContext getContext(Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getBundleContext();
        }
        return AccessController.doPrivileged(() -> bundle.getBundleContext(), this.controlContext);
    }

    public String getLocation(Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getLocation();
        }
        return AccessController.doPrivileged(() -> bundle.getLocation(), this.controlContext);
    }
}

