/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnector
extends ContainerLifeCycle {
    public static final String CLIENT_CONNECTOR_CONTEXT_KEY = "org.eclipse.jetty.client.connector";
    public static final String REMOTE_SOCKET_ADDRESS_CONTEXT_KEY = "org.eclipse.jetty.client.connector.remoteSocketAddress";
    public static final String CLIENT_CONNECTION_FACTORY_CONTEXT_KEY = "org.eclipse.jetty.client.connector.clientConnectionFactory";
    public static final String CONNECTION_PROMISE_CONTEXT_KEY = "org.eclipse.jetty.client.connector.connectionPromise";
    private static final Logger LOG = LoggerFactory.getLogger(ClientConnector.class);
    private Executor executor;
    private Scheduler scheduler;
    private ByteBufferPool byteBufferPool;
    private SslContextFactory.Client sslContextFactory;
    private SelectorManager selectorManager;
    private int selectors = 1;
    private boolean connectBlocking;
    private Duration connectTimeout = Duration.ofSeconds(5L);
    private Duration idleTimeout = Duration.ofSeconds(30L);
    private SocketAddress bindAddress;
    private boolean reuseAddress = true;

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.updateBean(this.scheduler, scheduler);
        this.scheduler = scheduler;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.updateBean(this.byteBufferPool, byteBufferPool);
        this.byteBufferPool = byteBufferPool;
    }

    public SslContextFactory.Client getSslContextFactory() {
        return this.sslContextFactory;
    }

    public void setSslContextFactory(SslContextFactory.Client sslContextFactory) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.updateBean(this.sslContextFactory, sslContextFactory);
        this.sslContextFactory = sslContextFactory;
    }

    public int getSelectors() {
        return this.selectors;
    }

    public void setSelectors(int selectors) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.selectors = selectors;
    }

    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    public void setConnectBlocking(boolean connectBlocking) {
        this.connectBlocking = connectBlocking;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        if (this.selectorManager != null) {
            this.selectorManager.setConnectTimeout(connectTimeout.toMillis());
        }
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    protected void doStart() throws Exception {
        if (this.executor == null) {
            QueuedThreadPool clientThreads = new QueuedThreadPool();
            clientThreads.setName(String.format("client-pool@%x", ((Object)((Object)this)).hashCode()));
            this.setExecutor((Executor)clientThreads);
        }
        if (this.scheduler == null) {
            this.setScheduler((Scheduler)new ScheduledExecutorScheduler(String.format("client-scheduler@%x", ((Object)((Object)this)).hashCode()), false));
        }
        if (this.byteBufferPool == null) {
            this.setByteBufferPool(new MappedByteBufferPool());
        }
        if (this.sslContextFactory == null) {
            this.setSslContextFactory(this.newSslContextFactory());
        }
        this.selectorManager = this.newSelectorManager();
        this.selectorManager.setConnectTimeout(this.getConnectTimeout().toMillis());
        this.addBean((Object)this.selectorManager);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean((Object)this.selectorManager);
    }

    protected SslContextFactory.Client newSslContextFactory() {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(false);
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        return sslContextFactory;
    }

    protected SelectorManager newSelectorManager() {
        return new ClientSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors());
    }

    public void connect(SocketAddress address, Map<String, Object> context) {
        SocketChannel channel = null;
        try {
            if (context == null) {
                context = new HashMap<String, Object>();
            }
            context.put(CLIENT_CONNECTOR_CONTEXT_KEY, (Object)this);
            context.putIfAbsent(REMOTE_SOCKET_ADDRESS_CONTEXT_KEY, address);
            channel = SocketChannel.open();
            SocketAddress bindAddress = this.getBindAddress();
            if (bindAddress != null) {
                boolean reuseAddress = this.getReuseAddress();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Binding to {} to connect to {}{}", new Object[]{bindAddress, address, reuseAddress ? " reusing address" : ""});
                }
                channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)reuseAddress);
                channel.bind(bindAddress);
            }
            this.configure(channel);
            boolean connected = true;
            boolean blocking = this.isConnectBlocking();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connecting {} to {}", (Object)(blocking ? "blocking" : "non-blocking"), (Object)address);
            }
            if (blocking) {
                channel.socket().connect(address, (int)this.getConnectTimeout().toMillis());
                channel.configureBlocking(false);
            } else {
                channel.configureBlocking(false);
                connected = channel.connect(address);
            }
            if (connected) {
                this.selectorManager.accept(channel, context);
            } else {
                this.selectorManager.connect(channel, context);
            }
        }
        catch (Throwable x) {
            if (x.getClass() == SocketException.class) {
                x = new SocketException("Could not connect to " + address).initCause(x);
            }
            IO.close(channel);
            this.connectFailed(x, context);
        }
    }

    public void accept(SocketChannel channel, Map<String, Object> context) {
        block4: {
            try {
                context.put(CLIENT_CONNECTOR_CONTEXT_KEY, (Object)this);
                if (!channel.isConnected()) {
                    throw new IllegalStateException("SocketChannel must be connected");
                }
                this.configure(channel);
                channel.configureBlocking(false);
                this.selectorManager.accept(channel, context);
            }
            catch (Throwable failure) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not accept {}", (Object)channel);
                }
                IO.close((Closeable)channel);
                Promise promise = (Promise)context.get(CONNECTION_PROMISE_CONTEXT_KEY);
                if (promise == null) break block4;
                promise.failed(failure);
            }
        }
    }

    protected void configure(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(true);
    }

    protected EndPoint newEndPoint(SocketChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
        return new SocketChannelEndPoint(channel, selector, selectionKey, this.getScheduler());
    }

    protected void connectFailed(Throwable failure, Map<String, Object> context) {
        Promise promise;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", context.get(REMOTE_SOCKET_ADDRESS_CONTEXT_KEY));
        }
        if ((promise = (Promise)context.get(CONNECTION_PROMISE_CONTEXT_KEY)) != null) {
            promise.failed(failure);
        }
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        public ClientSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        @Override
        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
            EndPoint endPoint = ClientConnector.this.newEndPoint((SocketChannel)channel, selector, selectionKey);
            endPoint.setIdleTimeout(ClientConnector.this.getIdleTimeout().toMillis());
            return endPoint;
        }

        @Override
        public Connection newConnection(SelectableChannel channel, EndPoint endPoint, Object attachment) throws IOException {
            Map context = (Map)attachment;
            ClientConnectionFactory factory = (ClientConnectionFactory)context.get(ClientConnector.CLIENT_CONNECTION_FACTORY_CONTEXT_KEY);
            return factory.newConnection(endPoint, context);
        }

        @Override
        public void connectionOpened(Connection connection, Object context) {
            super.connectionOpened(connection, context);
            Map contextMap = (Map)context;
            Promise promise = (Promise)contextMap.get(ClientConnector.CONNECTION_PROMISE_CONTEXT_KEY);
            if (promise != null) {
                promise.succeeded((Object)connection);
            }
        }

        @Override
        protected void connectionFailed(SelectableChannel channel, Throwable failure, Object attachment) {
            Map context = (Map)attachment;
            ClientConnector.this.connectFailed(failure, context);
        }
    }
}

