/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetPage;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;

public class IntroItem
extends ViewItem {
    private ImageHyperlink startButton;

    public IntroItem(CheatSheetPage page, Item contentItem, Color itemColor, CheatSheetViewer viewer) {
        super(page, contentItem, itemColor, viewer);
    }

    @Override
    void setStartImage() {
        this.startButton.setImage(CheatSheetPlugin.getPlugin().getImage("COMPOSITE_TASK_START"));
        this.startButton.setText(Messages.get().START_CHEATSHEET_TOOLTIP);
        this.startButton.setToolTipText(Messages.get().START_CHEATSHEET_TOOLTIP);
    }

    @Override
    void setRestartImage() {
        this.startButton.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_RETURN"));
        this.startButton.setText(Messages.get().RESTART_CHEATSHEET_TOOLTIP);
        this.startButton.setToolTipText(Messages.get().RESTART_CHEATSHEET_TOOLTIP);
    }

    @Override
    void handleButtons() {
        this.buttonComposite = this.page.getToolkit().createComposite(this.bodyWrapperComposite);
        GridLayout buttonlayout = new GridLayout(4, false);
        buttonlayout.marginHeight = 2;
        buttonlayout.marginWidth = 2;
        buttonlayout.verticalSpacing = 2;
        TableWrapData buttonData = new TableWrapData(128);
        this.buttonComposite.setLayout((Layout)buttonlayout);
        this.buttonComposite.setLayoutData((Object)buttonData);
        this.buttonComposite.setBackground(this.itemColor);
        Label filllabel = this.page.getToolkit().createLabel(this.buttonComposite, null);
        filllabel.setBackground(this.itemColor);
        GridData filldata = new GridData();
        filldata.widthHint = 16;
        filllabel.setLayoutData((Object)filldata);
        this.startButton = this.createButtonWithText(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("COMPOSITE_TASK_START"), this, this.itemColor, Messages.get().START_CHEATSHEET_TOOLTIP);
        this.startButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.startButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IntroItem.this.viewer.advanceIntroItem();
            }
        });
    }

    @Override
    boolean hasCompletionMessage() {
        return false;
    }

    @Override
    void createCompletionComposite(boolean isFinalItem) {
    }
}

