/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.dropdown.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.addons.dropdown.internal.ClientModelListener;
import org.eclipse.rap.addons.dropdown.internal.ModelListener;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model {
    private static final String REMOTE_TYPE = "rwt.remote.Model";
    private RemoteObject remoteObject;
    private Map<String, List<ModelListener>> listeners = new HashMap<String, List<ModelListener>>();

    public Model() {
        this.remoteObject = RWT.getUISession().getConnection().createRemoteObject(REMOTE_TYPE);
        this.remoteObject.setHandler((OperationHandler)new AbstractOperationHandler(){

            public void handleNotify(String event, JsonObject properties) {
                Model.this.notifyInternal(event, properties);
            }
        });
    }

    public void set(String name, String value) {
        this.remoteObject.set(name, value);
    }

    public void set(String name, int value) {
        this.remoteObject.set(name, value);
    }

    public void set(String name, JsonValue value) {
        this.remoteObject.set(name, value);
    }

    public void addListener(String eventType, ModelListener listener) {
        Model.checkArguments(eventType, listener);
        if (listener instanceof ClientModelListener) {
            ((ClientModelListener)listener).addTo(this, eventType);
        } else {
            this.addServerListener(eventType, listener);
        }
    }

    public void removeListener(String eventType, ModelListener listener) {
        Model.checkArguments(eventType, listener);
        if (listener instanceof ClientModelListener) {
            ((ClientModelListener)listener).removeFrom(this, eventType);
        } else {
            boolean removed = this.getListeners(eventType).remove(listener);
            if (removed && !this.hasListeners(eventType)) {
                this.remoteObject.listen(eventType, false);
            }
        }
    }

    public void notify(String event) {
        this.notify(event, null);
    }

    public void notify(String event, JsonObject properties) {
        this.notifyInternal(event, properties);
        JsonObject callProperties = new JsonObject();
        callProperties.add("event", event);
        if (properties != null) {
            callProperties.add("properties", (JsonValue)properties);
        }
        callProperties.add("nosync", true);
        this.remoteObject.call("notify", callProperties);
    }

    public void destroy() {
        this.remoteObject.destroy();
        this.notifyInternal("destroy", null);
    }

    public String getId() {
        return this.remoteObject.getId();
    }

    private static void checkArguments(Object ... arguments) {
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object argument = objectArray[n2];
            if (argument == null) {
                throw new IllegalArgumentException("Argument may not be null");
            }
            ++n2;
        }
    }

    private void addServerListener(String eventType, ModelListener listener) {
        List<ModelListener> eventListeners;
        if (!this.hasListeners(eventType)) {
            this.remoteObject.listen(eventType, true);
        }
        if (!(eventListeners = this.getListeners(eventType)).contains(listener)) {
            eventListeners.add(listener);
        }
    }

    private List<ModelListener> getListeners(String eventType) {
        List<ModelListener> result = this.listeners.get(eventType);
        if (result == null) {
            result = new ArrayList<ModelListener>();
            this.listeners.put(eventType, result);
        }
        return result;
    }

    private boolean hasListeners(String eventType) {
        return this.listeners.containsKey(eventType) && !this.listeners.get(eventType).isEmpty();
    }

    private void notifyInternal(String event, JsonObject properties) {
        List<ModelListener> eventListeners = this.getListeners(event);
        for (ModelListener eventListener : eventListeners) {
            eventListener.handleEvent(properties);
        }
    }
}

