/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class PasteTemplateAction
extends SelectionAction {
    public PasteTemplateAction(IWorkbenchPart editor) {
        super(editor);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    protected Command createPasteCommand() {
        Object obj;
        Command result = null;
        List selection = this.getSelectedObjects();
        if (selection != null && selection.size() == 1 && (obj = selection.get(0)) instanceof GraphicalEditPart) {
            CreationFactory factory;
            GraphicalEditPart gep = (GraphicalEditPart)obj;
            Object template = this.getClipboardContents();
            if (template != null && (factory = this.getFactory(template)) != null) {
                CreateRequest request = new CreateRequest();
                request.setFactory(factory);
                request.setLocation(this.getPasteLocation(gep));
                result = gep.getCommand(request);
            }
        }
        return result;
    }

    protected Object getClipboardContents() {
        return Clipboard.getDefault().getContents();
    }

    protected CreationFactory getFactory(Object template) {
        if (template instanceof CreationFactory) {
            return (CreationFactory)template;
        }
        return null;
    }

    protected Point getPasteLocation(GraphicalEditPart container) {
        Point result = new Point(10, 10);
        IFigure fig = container.getContentPane();
        result.translate(fig.getClientArea(Rectangle.getSINGLETON()).getLocation());
        fig.translateToAbsolute((Translatable)result);
        return result;
    }

    protected void init() {
        this.setId(ActionFactory.PASTE.getId());
        this.setText(GEFMessages.get().PasteAction_Label);
    }

    public void run() {
        this.execute(this.createPasteCommand());
    }
}

