/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;

public abstract class AbstractLayout
implements LayoutManager {
    protected Dimension preferredSize;
    protected boolean isObservingVisibility = false;

    protected final void calculatePreferredSize(IFigure container) {
    }

    protected abstract Dimension calculatePreferredSize(IFigure var1, int var2, int var3);

    protected Dimension getBorderPreferredSize(IFigure container) {
        if (container.getBorder() == null) {
            return new Dimension();
        }
        return container.getBorder().getPreferredSize(container);
    }

    public Object getConstraint(IFigure child) {
        return null;
    }

    public final void getMinimumSize(IFigure container) {
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return this.getPreferredSize(container, wHint, hHint);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        if (this.preferredSize == null) {
            this.preferredSize = this.calculatePreferredSize(container, wHint, hHint);
        }
        return this.preferredSize;
    }

    public final void getPreferredSize(IFigure container) {
    }

    public void invalidate() {
        this.preferredSize = null;
    }

    protected void invalidate(IFigure child) {
        this.invalidate();
    }

    public boolean isObservingVisibility() {
        return this.isObservingVisibility;
    }

    public void remove(IFigure child) {
        this.invalidate();
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.invalidate(child);
    }

    public void setObserveVisibility(boolean newValue) {
        if (this.isObservingVisibility == newValue) {
            return;
        }
        this.isObservingVisibility = newValue;
    }
}

