/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Iterator;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformHelper;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Rectangle;

public class FreeformLayer
extends Layer
implements FreeformFigure {
    private FreeformHelper helper = new FreeformHelper(this);

    public void add(IFigure child, Object constraint, int index) {
        super.add(child, constraint, index);
        this.helper.hookChild(child);
    }

    public void addFreeformListener(FreeformListener listener) {
        this.addListener(FreeformListener.class, listener);
    }

    public void fireExtentChanged() {
        Iterator iter = this.getListeners(FreeformListener.class);
        while (iter.hasNext()) {
            ((FreeformListener)iter.next()).notifyFreeformExtentChanged();
        }
    }

    protected void fireMoved() {
    }

    public Rectangle getFreeformExtent() {
        return this.helper.getFreeformExtent();
    }

    public void primTranslate(int dx, int dy) {
        this.bounds.x += dx;
        this.bounds.y += dy;
    }

    public void remove(IFigure child) {
        this.helper.unhookChild(child);
        super.remove(child);
    }

    public void removeFreeformListener(FreeformListener listener) {
        this.removeListener(FreeformListener.class, listener);
    }

    public void setFreeformBounds(Rectangle bounds) {
        this.helper.setFreeformBounds(bounds);
    }
}

