/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIDiagramRepresentation;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.junit.Assert;

public class PaletteToolsAvailabilityCondition
extends DefaultCondition {
    private final UIDiagramRepresentation diagram;
    private final boolean shouldHaveDisplayedTools;

    public PaletteToolsAvailabilityCondition(UIDiagramRepresentation diagram, boolean shouldHaveDisplayedTools) {
        this.diagram = diagram;
        this.shouldHaveDisplayedTools = shouldHaveDisplayedTools;
    }

    public boolean test() throws Exception {
        PaletteViewer paletteViewer = this.diagram.getEditor().rootEditPart().part().getViewer().getEditDomain().getPaletteViewer();
        PaletteContainer viewpointPaletteContainer = (PaletteContainer)paletteViewer.getPaletteRoot().getChildren().get(1);
        int nbToolInThePalette = viewpointPaletteContainer.getChildren().size();
        Assert.assertEquals((String)"The palette was expected to be empty", (long)0L, (long)nbToolInThePalette);
        if (this.shouldHaveDisplayedTools) {
            return nbToolInThePalette > 0;
        }
        return nbToolInThePalette == 0;
    }

    public String getFailureMessage() {
        if (this.shouldHaveDisplayedTools) {
            return "It was expected to have tools in the palette";
        }
        return "It was expected to have no tool in the palette";
    }
}

