/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.preserveorder;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LongEdgeOrderingStrategy;
import org.eclipse.elk.alg.layered.options.OrderingStrategy;

public class ModelOrderNodeComparator
implements Comparator<LNode> {
    private LNode[] previousLayer;
    private final OrderingStrategy orderingStrategy;
    private HashMap<LNode, HashSet<LNode>> biggerThan = new HashMap();
    private HashMap<LNode, HashSet<LNode>> smallerThan = new HashMap();
    private LongEdgeOrderingStrategy longEdgeNodeOrder = LongEdgeOrderingStrategy.EQUAL;

    public ModelOrderNodeComparator(Layer thePreviousLayer, OrderingStrategy orderingStrategy, LongEdgeOrderingStrategy longEdgeOrderingStrategy) {
        this(orderingStrategy, longEdgeOrderingStrategy);
        this.previousLayer = new LNode[thePreviousLayer.getNodes().size()];
        thePreviousLayer.getNodes().toArray(this.previousLayer);
    }

    public ModelOrderNodeComparator(LNode[] previousLayer, OrderingStrategy orderingStrategy, LongEdgeOrderingStrategy longEdgeOrderingStrategy) {
        this(orderingStrategy, longEdgeOrderingStrategy);
        this.previousLayer = previousLayer;
    }

    private ModelOrderNodeComparator(OrderingStrategy orderingStrategy, LongEdgeOrderingStrategy longEdgeOrderingStrategy) {
        this.orderingStrategy = orderingStrategy;
        this.longEdgeNodeOrder = longEdgeOrderingStrategy;
    }

    @Override
    public int compare(LNode n1, LNode n2) {
        int n2ModelOrder;
        int n1ModelOrder;
        if (!this.biggerThan.containsKey((Object)n1)) {
            this.biggerThan.put(n1, new HashSet());
        } else if (this.biggerThan.get((Object)n1).contains((Object)n2)) {
            return 1;
        }
        if (!this.biggerThan.containsKey((Object)n2)) {
            this.biggerThan.put(n2, new HashSet());
        } else if (this.biggerThan.get((Object)n2).contains((Object)n1)) {
            return -1;
        }
        if (!this.smallerThan.containsKey((Object)n1)) {
            this.smallerThan.put(n1, new HashSet());
        } else if (this.smallerThan.get((Object)n1).contains((Object)n2)) {
            return -1;
        }
        if (!this.smallerThan.containsKey((Object)n2)) {
            this.smallerThan.put(n2, new HashSet());
        } else if (this.biggerThan.get((Object)n2).contains((Object)n1)) {
            return 1;
        }
        if (this.orderingStrategy == OrderingStrategy.PREFER_EDGES || !n1.hasProperty(InternalProperties.MODEL_ORDER) || !n2.hasProperty(InternalProperties.MODEL_ORDER)) {
            LPort p1SourcePort = null;
            for (LPort p : n1.getPorts()) {
                if (p.getIncomingEdges().isEmpty() || p.getIncomingEdges().get(0).getSource().getNode().getLayer() == n1.getLayer()) continue;
                p1SourcePort = p.getIncomingEdges().get(0).getSource();
            }
            LPort p2SourcePort = null;
            for (LPort p : n2.getPorts()) {
                if (p.getIncomingEdges().isEmpty() || p.getIncomingEdges().get(0).getSource().getNode().getLayer() == n2.getLayer()) continue;
                p2SourcePort = p.getIncomingEdges().get(0).getSource();
            }
            if (p1SourcePort != null && p2SourcePort != null) {
                LNode p1Node = p1SourcePort.getNode();
                LNode p2Node = p2SourcePort.getNode();
                if (p1Node != null && ((Object)((Object)p1Node)).equals((Object)p2Node)) {
                    for (LPort port : p1Node.getPorts()) {
                        if (((Object)((Object)port)).equals((Object)p1SourcePort)) {
                            this.updateBiggerAndSmallerAssociations(n2, n1);
                            return -1;
                        }
                        if (!((Object)((Object)port)).equals((Object)p2SourcePort)) continue;
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                        return 1;
                    }
                    assert (false);
                    return Integer.compare(this.getModelOrderFromConnectedEdges(n1), this.getModelOrderFromConnectedEdges(n2));
                }
                LNode[] lNodeArray = this.previousLayer;
                int n = this.previousLayer.length;
                int n3 = 0;
                while (n3 < n) {
                    LNode previousNode = lNodeArray[n3];
                    if (((Object)((Object)previousNode)).equals((Object)p1Node)) {
                        this.updateBiggerAndSmallerAssociations(n2, n1);
                        return -1;
                    }
                    if (((Object)((Object)previousNode)).equals((Object)p2Node)) {
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                        return 1;
                    }
                    ++n3;
                }
            }
            if (!n1.hasProperty(InternalProperties.MODEL_ORDER) || !n2.hasProperty(InternalProperties.MODEL_ORDER)) {
                int n2ModelOrder2;
                int n1ModelOrder2 = this.getModelOrderFromConnectedEdges(n1);
                if (n1ModelOrder2 > (n2ModelOrder2 = this.getModelOrderFromConnectedEdges(n2))) {
                    this.updateBiggerAndSmallerAssociations(n1, n2);
                } else {
                    this.updateBiggerAndSmallerAssociations(n2, n1);
                }
                return Integer.compare(n1ModelOrder2, n2ModelOrder2);
            }
        }
        if ((n1ModelOrder = ((Integer)n1.getProperty(InternalProperties.MODEL_ORDER)).intValue()) > (n2ModelOrder = ((Integer)n2.getProperty(InternalProperties.MODEL_ORDER)).intValue())) {
            this.updateBiggerAndSmallerAssociations(n1, n2);
        } else {
            this.updateBiggerAndSmallerAssociations(n2, n1);
        }
        return Integer.compare(n1ModelOrder, n2ModelOrder);
    }

    private int getModelOrderFromConnectedEdges(LNode n) {
        LEdge edge;
        LPort sourcePort = n.getPorts().stream().filter(p -> !p.getIncomingEdges().isEmpty()).findFirst().orElse(null);
        if (sourcePort != null && (edge = sourcePort.getIncomingEdges().get(0)) != null) {
            return (Integer)edge.getProperty(InternalProperties.MODEL_ORDER);
        }
        return this.longEdgeNodeOrder.returnValue();
    }

    private void updateBiggerAndSmallerAssociations(LNode bigger, LNode smaller) {
        HashSet<LNode> biggerNodeBiggerThan = this.biggerThan.get((Object)bigger);
        HashSet<LNode> smallerNodeBiggerThan = this.biggerThan.get((Object)smaller);
        HashSet<LNode> biggerNodeSmallerThan = this.smallerThan.get((Object)bigger);
        HashSet<LNode> smallerNodeSmallerThan = this.smallerThan.get((Object)smaller);
        biggerNodeBiggerThan.add(smaller);
        smallerNodeSmallerThan.add(bigger);
        for (LNode verySmall : smallerNodeBiggerThan) {
            biggerNodeBiggerThan.add(verySmall);
            this.smallerThan.get((Object)verySmall).add(bigger);
            this.smallerThan.get((Object)verySmall).addAll(biggerNodeSmallerThan);
        }
        for (LNode veryBig : biggerNodeSmallerThan) {
            smallerNodeSmallerThan.add(veryBig);
            this.biggerThan.get((Object)veryBig).add(smaller);
            this.biggerThan.get((Object)veryBig).addAll(smallerNodeBiggerThan);
        }
    }
}

