/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands.emf;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public abstract class AbstractSelectionWizardCommand
extends RecordingCommand {
    AbstractSelectionWizardCommand(TransactionalEditingDomain domain) {
        super(domain);
    }

    public static boolean canCreateCommand(AbstractToolDescription tool, EObject containerView, TreeItemWrapper input) {
        if (containerView instanceof DSemanticDecorator) {
            EObject container = ((DSemanticDecorator)containerView).getTarget();
            return AbstractSelectionWizardCommand.checkPrecondition(tool, containerView, container);
        }
        return false;
    }

    protected static boolean checkPrecondition(AbstractToolDescription description, EObject containerView, EObject container) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(container);
        boolean preconditionResult = false;
        if (description.getPrecondition() == null || StringUtil.isEmpty((String)description.getPrecondition())) {
            preconditionResult = true;
        } else {
            try {
                try {
                    preconditionResult = false;
                    Option diagram = new EObjectQuery(containerView).getParentDiagram();
                    if (diagram.some()) {
                        interpreter.setVariable("diagram", diagram.get());
                    } else {
                        interpreter.setVariable("diagram", null);
                    }
                    interpreter.setVariable("containerView", (Object)containerView);
                    interpreter.setVariable("container", (Object)container);
                    preconditionResult = interpreter.evaluateBoolean(container, description.getPrecondition());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)description, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                    interpreter.unSetVariable("container");
                    interpreter.unSetVariable("containerView");
                    interpreter.unSetVariable("diagram");
                }
            }
            finally {
                interpreter.unSetVariable("container");
                interpreter.unSetVariable("containerView");
                interpreter.unSetVariable("diagram");
            }
        }
        return preconditionResult;
    }
}

