/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.session.SiriusPreferences;
import org.eclipse.sirius.business.internal.preferences.PreferenceHelper;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class SiriusPreferencesImpl
implements SiriusPreferences {
    private static final String PREF_REFRESH_ON_REPRESENTATION_OPENING = "PREF_REFRESH_ON_REPRESENTATION_OPENING";
    private static final String ORG_ECLIPSE_SIRIUS_UI_PLUGIN_ID = "org.eclipse.sirius.ui";
    ProjectScope projectScope;
    private String sessionId;

    public SiriusPreferencesImpl(DAnalysisSessionImpl dAnalysisSessionImpl) {
        this.sessionId = dAnalysisSessionImpl.getMainAnalysis().getUid();
        IFile airdFile = WorkspaceSynchronizer.getFile((Resource)dAnalysisSessionImpl.getMainAnalysis().eResource());
        if (airdFile != null) {
            IProject project = airdFile.getProject();
            this.projectScope = new ProjectScope(project);
        }
    }

    @Override
    public boolean isAutoRefresh() {
        Boolean preference = PreferenceHelper.getPreference((IScopeContext)this.projectScope, "org.eclipse.sirius", this.sessionId, SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), Boolean.class);
        return preference;
    }

    @Override
    public void setAutoRefresh(boolean value) {
        try {
            if (this.projectScope != null) {
                IEclipsePreferences sessionScopeNode = this.projectScope.getNode("org.eclipse.sirius" + this.sessionId);
                sessionScopeNode.putBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), value);
                sessionScopeNode.flush();
            } else {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", MessageFormat.format(Messages.SiriusPreferencesImpl_noProjectScope, SiriusPreferencesKeys.PREF_AUTO_REFRESH.name())));
            }
        }
        catch (IllegalStateException | BackingStoreException e) {
            SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", e.getMessage(), e));
        }
    }

    @Override
    public void unsetAutoRefresh() {
        try {
            if (this.projectScope != null) {
                IEclipsePreferences sessionScopeNode = this.projectScope.getNode("org.eclipse.sirius" + this.sessionId);
                sessionScopeNode.remove(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name());
                sessionScopeNode.flush();
            } else {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", MessageFormat.format(Messages.SiriusPreferencesImpl_noProjectScope, SiriusPreferencesKeys.PREF_AUTO_REFRESH.name())));
            }
        }
        catch (IllegalStateException | BackingStoreException e) {
            SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", e.getMessage(), e));
        }
    }

    @Override
    public boolean hasSpecificSettingAutoRefresh() {
        try {
            if (this.projectScope != null) {
                IEclipsePreferences sessionScopeNode = this.projectScope.getNode("org.eclipse.sirius" + this.sessionId);
                return Arrays.asList(sessionScopeNode.keys()).contains(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name());
            }
        }
        catch (IllegalStateException | BackingStoreException e) {
            SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", e.getMessage(), e));
        }
        return false;
    }

    @Override
    public boolean isRefreshOnRepresentationOpening() {
        Boolean preference = PreferenceHelper.getPreference((IScopeContext)this.projectScope, ORG_ECLIPSE_SIRIUS_UI_PLUGIN_ID, this.sessionId, PREF_REFRESH_ON_REPRESENTATION_OPENING, Boolean.class);
        return preference;
    }

    @Override
    public void setRefreshOnRepresentationOpening(boolean value) {
        try {
            if (this.projectScope != null) {
                IEclipsePreferences sessionScopeNode = this.projectScope.getNode(ORG_ECLIPSE_SIRIUS_UI_PLUGIN_ID + this.sessionId);
                sessionScopeNode.putBoolean(PREF_REFRESH_ON_REPRESENTATION_OPENING, value);
                sessionScopeNode.flush();
            } else {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", MessageFormat.format(Messages.SiriusPreferencesImpl_noProjectScope, PREF_REFRESH_ON_REPRESENTATION_OPENING)));
            }
        }
        catch (IllegalStateException | BackingStoreException e) {
            SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", e.getMessage(), e));
        }
    }

    @Override
    public void unsetRefreshOnRepresentationOpening() {
        try {
            if (this.projectScope != null) {
                IEclipsePreferences sessionScopeNode = this.projectScope.getNode(ORG_ECLIPSE_SIRIUS_UI_PLUGIN_ID + this.sessionId);
                sessionScopeNode.remove(PREF_REFRESH_ON_REPRESENTATION_OPENING);
                sessionScopeNode.flush();
            } else {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", MessageFormat.format(Messages.SiriusPreferencesImpl_noProjectScope, PREF_REFRESH_ON_REPRESENTATION_OPENING)));
            }
        }
        catch (IllegalStateException | BackingStoreException e) {
            SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", e.getMessage(), e));
        }
    }

    @Override
    public boolean hasSpecificSettingRefreshOnRepresentationOpening() {
        try {
            if (this.projectScope != null) {
                IEclipsePreferences sessionScopeNode = this.projectScope.getNode(ORG_ECLIPSE_SIRIUS_UI_PLUGIN_ID + this.sessionId);
                return Arrays.asList(sessionScopeNode.keys()).contains(PREF_REFRESH_ON_REPRESENTATION_OPENING);
            }
        }
        catch (IllegalStateException | BackingStoreException e) {
            SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", e.getMessage(), e));
        }
        return false;
    }
}

