/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.tests.swtbot.support.api.condition.CompoundCondition;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;

public class CheckSelectedCondition
extends DefaultCondition {
    private String labelOfEditPart;
    private EditPart editPartToWaitForSelection;
    private Class<? extends IGraphicalEditPart> editPartClass;
    private SWTBotSiriusDiagramEditor editor;

    public CheckSelectedCondition(SWTBotSiriusDiagramEditor editor, String labelOfEditPart) {
        this.editor = editor;
        this.labelOfEditPart = labelOfEditPart;
    }

    public CheckSelectedCondition(SWTBotSiriusDiagramEditor editor, EditPart editPartToWaitForSelection) {
        this.editor = editor;
        this.editPartToWaitForSelection = editPartToWaitForSelection;
    }

    public CheckSelectedCondition(SWTBotSiriusDiagramEditor editor, String labelOfEditPart, Class<? extends IGraphicalEditPart> editPartClass) {
        this.editor = editor;
        this.labelOfEditPart = labelOfEditPart;
        this.editPartClass = editPartClass;
    }

    public boolean test() throws Exception {
        return this.isSelected(this.getEditPart());
    }

    private boolean isSelected(EditPart part) {
        if (part instanceof DDiagramEditPart) {
            ISelection selection = this.editor.getSelection();
            return selection instanceof IStructuredSelection && part.equals(((IStructuredSelection)selection).getFirstElement());
        }
        return part != null && part.getSelected() == 2 || part.getSelected() == 1;
    }

    private EditPart getEditPart() {
        EditPart part = this.editPartToWaitForSelection;
        if (part == null) {
            part = this.editPartClass != null ? this.editor.getEditPart(this.labelOfEditPart, this.editPartClass).part() : this.editor.getEditPart(this.labelOfEditPart).part().getParent();
        }
        return part;
    }

    public String getFailureMessage() {
        String simpleClassName = "";
        if (this.editPartToWaitForSelection != null) {
            simpleClassName = this.editPartToWaitForSelection.getClass().getSimpleName();
        } else if (this.editPartClass != null) {
            simpleClassName = this.editPartClass.getSimpleName();
        }
        Object partTypeMessage = simpleClassName == null ? "" : " of type \"" + simpleClassName + "\"";
        String partLabelMessage = this.labelOfEditPart == null ? "" : " with name \"" + this.labelOfEditPart + "\"";
        return "The edit part" + (String)partTypeMessage + partLabelMessage + " has not been selected.";
    }

    public static CompoundCondition multipleSelection(SWTBotSiriusDiagramEditor editor, String ... editPartLabels) {
        return CheckSelectedCondition.multipleSelection(editor, null, editPartLabels);
    }

    public static CompoundCondition multipleSelection(SWTBotSiriusDiagramEditor editor, Class<? extends IGraphicalEditPart> editPartClass, String ... editPartLabels) {
        ArrayList<ICondition> conditions = new ArrayList<ICondition>();
        String[] stringArray = editPartLabels;
        int n = editPartLabels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            conditions.add((ICondition)new CheckSelectedCondition(editor, label, editPartClass));
            ++n2;
        }
        return new CompoundCondition(conditions);
    }

    public static CompoundCondition multipleSelection(SWTBotSiriusDiagramEditor editor, EditPart ... editPartsToWaitForSelection) {
        ArrayList<ICondition> conditions = new ArrayList<ICondition>();
        EditPart[] editPartArray = editPartsToWaitForSelection;
        int n = editPartsToWaitForSelection.length;
        int n2 = 0;
        while (n2 < n) {
            EditPart part = editPartArray[n2];
            conditions.add((ICondition)new CheckSelectedCondition(editor, part));
            ++n2;
        }
        return new CompoundCondition(conditions);
    }
}

