/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.force.options.ForceModelStrategy;
import org.eclipse.elk.alg.force.options.ForceOptions;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.ExclusiveBounds;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class ForceMetaDataProvider
implements ILayoutMetaDataProvider {
    private static final ForceModelStrategy MODEL_DEFAULT = ForceModelStrategy.FRUCHTERMAN_REINGOLD;
    public static final IProperty<ForceModelStrategy> MODEL = new Property("org.eclipse.elk.force.model", (Object)MODEL_DEFAULT, null, null);
    private static final int ITERATIONS_DEFAULT = 300;
    private static final Comparable<? super Integer> ITERATIONS_LOWER_BOUND = 1;
    public static final IProperty<Integer> ITERATIONS = new Property("org.eclipse.elk.force.iterations", (Object)300, ITERATIONS_LOWER_BOUND, null);
    private static final int REPULSIVE_POWER_DEFAULT = 0;
    private static final Comparable<? super Integer> REPULSIVE_POWER_LOWER_BOUND = 0;
    public static final IProperty<Integer> REPULSIVE_POWER = new Property("org.eclipse.elk.force.repulsivePower", (Object)0, REPULSIVE_POWER_LOWER_BOUND, null);
    private static final double TEMPERATURE_DEFAULT = 0.001;
    private static final Comparable<? super Double> TEMPERATURE_LOWER_BOUND = ExclusiveBounds.greaterThan((double)0.0);
    public static final IProperty<Double> TEMPERATURE = new Property("org.eclipse.elk.force.temperature", (Object)0.001, TEMPERATURE_LOWER_BOUND, null);
    private static final double REPULSION_DEFAULT = 5.0;
    private static final Comparable<? super Double> REPULSION_LOWER_BOUND = ExclusiveBounds.greaterThan((double)0.0);
    public static final IProperty<Double> REPULSION = new Property("org.eclipse.elk.force.repulsion", (Object)5.0, REPULSION_LOWER_BOUND, null);
    private static final ForceModelStrategy TEMPERATURE_DEP_MODEL_0 = ForceModelStrategy.FRUCHTERMAN_REINGOLD;
    private static final ForceModelStrategy REPULSION_DEP_MODEL_0 = ForceModelStrategy.EADES;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.force.model").group("").name("Force Model").description("Determines the model for force calculation.").defaultValue((Object)MODEL_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(ForceModelStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.force.iterations").group("").name("Iterations").description("The number of iterations on the force model.").defaultValue((Object)300).lowerBound(ITERATIONS_LOWER_BOUND).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.force.repulsivePower").group("").name("Repulsive Power").description("Determines how many bend points are added to the edge; such bend points are regarded as repelling particles in the force model").defaultValue((Object)0).lowerBound(REPULSIVE_POWER_LOWER_BOUND).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.EDGES)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.force.temperature").group("").name("FR Temperature").description("The temperature is used as a scaling factor for particle displacements.").defaultValue((Object)0.001).lowerBound(TEMPERATURE_LOWER_BOUND).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.addDependency("org.eclipse.elk.force.temperature", "org.eclipse.elk.force.model", (Object)TEMPERATURE_DEP_MODEL_0);
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.force.repulsion").group("").name("Eades Repulsion").description("Factor for repulsive forces in Eades' model.").defaultValue((Object)5.0).lowerBound(REPULSION_LOWER_BOUND).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.addDependency("org.eclipse.elk.force.repulsion", "org.eclipse.elk.force.model", (Object)REPULSION_DEP_MODEL_0);
        new ForceOptions().apply(registry);
    }
}

