/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.component;

import java.io.IOException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.sirius.tests.sample.component.Component;
import org.eclipse.sirius.tests.sample.component.ComponentFactory;

public class CreateSampleComponentModel {
    public static void initializeEMF() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("component", new XMIResourceFactoryImpl());
        }
    }

    public static Component buildComponentTree(String name, int totalDepth, int payloadDepthStart, int fan) {
        Component root = CreateSampleComponentModel.createComponent(name, payloadDepthStart <= 0);
        if (totalDepth > 0) {
            int i = 0;
            while (i < fan) {
                Component child = CreateSampleComponentModel.buildComponentTree(name + "." + i, totalDepth - 1, payloadDepthStart - 1, fan);
                root.getChildren().add((Object)child);
                ++i;
            }
        }
        return root;
    }

    public static Component createComponent(String name, boolean isPayload) {
        Component c = ComponentFactory.eINSTANCE.createComponent();
        c.setName(name);
        c.setPayload(isPayload);
        return c;
    }

    public static void main(String[] args) throws IOException {
        CreateSampleComponentModel.initializeEMF();
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createFileURI((String)(System.getProperty("user.home") + "/test.component")));
        r.getContents().add((Object)CreateSampleComponentModel.buildComponentTree("c", 10, 3, 2));
        r.save(null);
    }
}

