/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class EMFCoreUtil {
    private static final String EMPTY_STRING = "";

    private EMFCoreUtil() {
    }

    public static String getName(EObject eObject) {
        String name = EMPTY_STRING;
        if (eObject != null) {
            if (eObject.eIsProxy()) {
                name = EMFCoreUtil.getProxyName(eObject);
            } else {
                String notProxyName = EMFCoreUtil.getNotProxyName(eObject);
                if (notProxyName != null) {
                    name = notProxyName;
                }
            }
        }
        return name;
    }

    private static String getProxyName(EObject proxy) {
        return EMPTY_STRING;
    }

    private static String getNotProxyName(EObject eObject) {
        String name;
        EAttribute nameAttribute = EMFCoreUtil.getNameAttribute(eObject.eClass());
        if (nameAttribute != null && (name = (String)eObject.eGet((EStructuralFeature)nameAttribute)) != null) {
            return name;
        }
        return null;
    }

    public static EAttribute getNameAttribute(EClass eClass) {
        EClassifier type;
        EAttribute nameAttribute = null;
        EStructuralFeature feature = eClass.getEStructuralFeature("name");
        if (feature != null && feature instanceof EAttribute && (type = feature.getEType()) != null && type.getInstanceClass() == String.class) {
            nameAttribute = (EAttribute)feature;
        }
        return nameAttribute;
    }

    public static Option<URL> getImage(EObject eObject) {
        IWorkspace workspace;
        IFile file;
        URI uri;
        Path path;
        String imagePath = EMFCoreUtil.getImagePath(eObject);
        if (imagePath != null && !StringUtil.isEmpty((String)imagePath) && (path = new Path((uri = URI.createURI((String)imagePath, (boolean)true)).path())).segmentCount() >= 2 && (file = (workspace = ResourcesPlugin.getWorkspace()).getRoot().getFile((IPath)path)).isAccessible()) {
            try {
                return Options.newSome((Object)file.getRawLocationURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return Options.newNone();
    }

    private static String getImagePath(EObject eObject) {
        String icon;
        EAttribute iconAttribute = EMFCoreUtil.getIconAttribute(eObject.eClass());
        if (iconAttribute != null && (icon = (String)eObject.eGet((EStructuralFeature)iconAttribute)) != null) {
            return icon;
        }
        return null;
    }

    private static EAttribute getIconAttribute(EClass eClass) {
        EClassifier type;
        EAttribute nameAttribute = null;
        EStructuralFeature feature = eClass.getEStructuralFeature("icon");
        if (feature != null && feature instanceof EAttribute && (type = feature.getEType()) != null && type.getInstanceClass() == String.class) {
            nameAttribute = (EAttribute)feature;
        }
        return nameAttribute;
    }
}

