/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.command;

import org.eclipse.statet.ecommons.waltable.coordinate.ColumnPositionCoordinate;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.coordinate.RowPositionCoordinate;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.LayerUtil;

public class LayerCommandUtil {
    public static PositionCoordinate convertPositionToTargetContext(PositionCoordinate positionCoordinate, ILayer targetLayer) {
        ILayer layer = positionCoordinate.getLayer();
        if (layer == targetLayer) {
            return positionCoordinate;
        }
        long columnPosition = positionCoordinate.getColumnPosition();
        long underlyingColumnPosition = layer.getDim(Orientation.HORIZONTAL).localToUnderlyingPosition(columnPosition, columnPosition);
        if (underlyingColumnPosition == Long.MIN_VALUE) {
            return null;
        }
        long rowPosition = positionCoordinate.getRowPosition();
        long underlyingRowPosition = layer.getDim(Orientation.VERTICAL).localToUnderlyingPosition(rowPosition, rowPosition);
        if (underlyingRowPosition == Long.MIN_VALUE) {
            return null;
        }
        ILayer underlyingLayer = layer.getUnderlyingLayerByPosition(columnPosition, rowPosition);
        if (underlyingLayer == null) {
            return null;
        }
        return LayerCommandUtil.convertPositionToTargetContext(new PositionCoordinate(underlyingLayer, underlyingColumnPosition, underlyingRowPosition), targetLayer);
    }

    public static ColumnPositionCoordinate convertColumnPositionToTargetContext(ColumnPositionCoordinate columnPositionCoordinate, ILayer targetLayer) {
        if (columnPositionCoordinate != null) {
            ILayer layer = columnPositionCoordinate.getLayer();
            long targetPosition = LayerUtil.convertPosition(layer.getDim(Orientation.HORIZONTAL), columnPositionCoordinate.columnPosition, columnPositionCoordinate.columnPosition, targetLayer.getDim(Orientation.HORIZONTAL));
            return targetPosition != Long.MIN_VALUE ? new ColumnPositionCoordinate(targetLayer, targetPosition) : null;
        }
        return null;
    }

    public static RowPositionCoordinate convertRowPositionToTargetContext(RowPositionCoordinate rowPositionCoordinate, ILayer targetLayer) {
        if (rowPositionCoordinate != null) {
            ILayer layer = rowPositionCoordinate.getLayer();
            long targetPosition = LayerUtil.convertPosition(layer.getDim(Orientation.VERTICAL), rowPositionCoordinate.rowPosition, rowPositionCoordinate.rowPosition, targetLayer.getDim(Orientation.VERTICAL));
            return targetPosition != Long.MIN_VALUE ? new RowPositionCoordinate(targetLayer, targetPosition) : null;
        }
        return null;
    }
}

