/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpaths.core;

import java.util.Objects;
import org.eclipse.core.runtime.IPath;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.buildpaths.core.BuildpathElementType;
import org.eclipse.statet.ltk.buildpaths.core.BuildpathsUtils;
import org.eclipse.statet.ltk.buildpaths.core.IBuildpathAttribute;
import org.eclipse.statet.ltk.buildpaths.core.IBuildpathElement;

public class BuildpathElement
implements IBuildpathElement {
    private static final ImList<String> UNINITIALIZED_PATTERNS = ImCollections.newList((Object)"UNINITIALIZED_PATTERNS");
    private final BuildpathElementType type;
    private final IPath path;
    private final ImList<IPath> inclusionPatterns;
    private volatile ImList<String> fullInclusionPatterns;
    private final ImList<IPath> exclusionPatterns;
    private volatile ImList<String> fullExclusionPatterns;
    private final IPath sourceAttachmentPath;
    private final IPath sourceAttachmentRootPath;
    private final IBuildpathElement referencingElement;
    private final IPath specificOutputPath;
    private final boolean isExported;
    private final ImList<IBuildpathAttribute> extraAttributes;

    public BuildpathElement(BuildpathElementType type, IPath path, ImList<IPath> inclusionPatterns, ImList<IPath> exclusionPatterns, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath specificOutputLocation, IBuildpathElement referencingEntry, boolean isExported, ImList<IBuildpathAttribute> extraAttributes) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.type = type;
        this.path = path;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.referencingElement = referencingEntry;
        if (this.inclusionPatterns != null && !this.inclusionPatterns.isEmpty()) {
            this.fullInclusionPatterns = UNINITIALIZED_PATTERNS;
        }
        if (this.exclusionPatterns != null && !this.exclusionPatterns.isEmpty()) {
            this.fullExclusionPatterns = UNINITIALIZED_PATTERNS;
        }
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.specificOutputPath = specificOutputLocation;
        this.isExported = isExported;
        this.extraAttributes = extraAttributes != null ? extraAttributes : ImCollections.emptyList();
    }

    @Override
    public final BuildpathElementType getType() {
        return this.type;
    }

    @Override
    public final String getTypeName() {
        return this.type.getName();
    }

    @Override
    public final IPath getPath() {
        return this.path;
    }

    @Override
    public final ImList<IPath> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    @Override
    public final ImList<IPath> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    private ImList<String> createFullPatterns(ImList<IPath> patterns) {
        int length = patterns.size();
        Object[] fullPatterns = new String[length];
        IPath prefixPath = this.path.removeTrailingSeparator();
        int i = 0;
        while (i < length) {
            fullPatterns[i] = prefixPath.append((IPath)patterns.get(i)).toString();
            ++i;
        }
        return ImCollections.newList((Object[])fullPatterns);
    }

    public ImList<String> getFullInclusionPatterns() {
        ImList<String> patterns = this.fullInclusionPatterns;
        if (patterns == UNINITIALIZED_PATTERNS) {
            patterns = this.fullInclusionPatterns = this.createFullPatterns(this.inclusionPatterns);
        }
        return patterns;
    }

    public ImList<String> getFullExclusionPatterns() {
        ImList<String> patterns = this.fullExclusionPatterns;
        if (patterns == UNINITIALIZED_PATTERNS) {
            patterns = this.fullExclusionPatterns = this.createFullPatterns(this.exclusionPatterns);
        }
        return patterns;
    }

    @Override
    public IPath getOutputPath() {
        return this.specificOutputPath;
    }

    @Override
    public ImList<IBuildpathAttribute> getExtraAttributes() {
        return this.extraAttributes;
    }

    public IBuildpathAttribute getAttribute(String name) {
        for (IBuildpathAttribute attribute : this.extraAttributes) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public IBuildpathElement getReferencingEntry() {
        return this.referencingElement;
    }

    @Override
    public boolean isExported() {
        return this.isExported;
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BuildpathElement) {
            BuildpathElement other = (BuildpathElement)obj;
            return this.type == other.type && this.isExported == other.isExported() && this.path.equals((Object)other.getPath()) && Objects.equals(this.sourceAttachmentPath, other.sourceAttachmentPath) && Objects.equals(this.getSourceAttachmentRootPath(), other.sourceAttachmentRootPath) && BuildpathsUtils.equalPatterns(this.inclusionPatterns, other.getInclusionPatterns()) && BuildpathsUtils.equalPatterns(this.exclusionPatterns, other.getExclusionPatterns()) && Objects.equals(this.specificOutputPath, other.specificOutputPath) && this.extraAttributes.equals(other.extraAttributes);
        }
        return false;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("BuildpathElement");
        sb.append(" [");
        sb.append(this.type.getName());
        sb.append("]:");
        sb.append(this.getPath().toString());
        sb.addProp("including", this.getInclusionPatterns());
        sb.addProp("excluding", this.getExclusionPatterns());
        if (this.getSourceAttachmentPath() != null) {
            sb.addProp("sourcePath", this.getSourceAttachmentPath().toString());
            if (this.getSourceAttachmentRootPath() != null) {
                sb.append(':');
                sb.append(this.getSourceAttachmentRootPath().toString());
            }
        }
        if (this.getOutputPath() != null) {
            sb.addProp("outputPath", (Object)this.getOutputPath());
        }
        sb.addProp("isExported", this.isExported);
        ImList<IBuildpathAttribute> attributes = this.getExtraAttributes();
        if (!attributes.isEmpty()) {
            sb.addProp("extraAttributes", attributes);
        }
        return sb.toString();
    }
}

