/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.buildpaths.ui;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.components.DropDownButton;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.buildpaths.ui.ExclusionInclusionEntryDialog;
import org.eclipse.statet.internal.ltk.buildpaths.ui.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathListElement;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathsUIDescription;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathsUIResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ExclusionInclusionComponent
implements ButtonGroup.IActions<IPath> {
    private static final int ADD_NEW_MULTI = 257;
    private final BuildpathListElement element;
    private final IProject project;
    private IContainer sourceFolder;
    private final Type inclusionPatterns = new Type("Filter.inclusions");
    private final Type exclusionPatterns = new Type("Filter.exclusions");
    private final BuildpathsUIDescription uiDescription;
    private Composite control;

    public ExclusionInclusionComponent(BuildpathListElement element, BuildpathsUIDescription uiDescription) {
        this.element = element;
        this.project = element.getProject();
        IWorkspaceRoot root = this.project.getWorkspace().getRoot();
        IResource res = root.findMember(element.getPath());
        if (res instanceof IContainer) {
            this.sourceFolder = (IContainer)res;
        }
        this.uiDescription = uiDescription;
    }

    private Type getType(String key) {
        switch (key) {
            case "Filter.inclusions": {
                return this.inclusionPatterns;
            }
            case "Filter.exclusions": {
                return this.exclusionPatterns;
            }
        }
        throw new IllegalArgumentException(key);
    }

    private Type getType(List<IPath> list) {
        if (list == this.inclusionPatterns.patternList) {
            return this.inclusionPatterns;
        }
        if (list == this.exclusionPatterns.patternList) {
            return this.exclusionPatterns;
        }
        throw new IllegalArgumentException();
    }

    private Shell getShell() {
        return this.control.getShell();
    }

    public Control create(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.createList(composite, this.inclusionPatterns, Messages.ExclusionInclusion_InclusionPattern_label, "org.eclipse.statet.ltk.buildpath/image/obj/attribute-inclusion_filter");
        this.createList(composite, this.exclusionPatterns, Messages.ExclusionInclusion_ExclusionPattern_label, "org.eclipse.statet.ltk.buildpath/image/obj/attribute-exclusion_filter");
        this.control = composite;
        return composite;
    }

    public Control getControl() {
        return this.control;
    }

    private void createList(Composite parent, Type type, String listLabel, String imgKey) {
        Label label = new Label(parent, 0);
        label.setText(listLabel);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        TableViewer viewer = new TableViewer(parent, 2818);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ExclusionInclusionLabelProvider(imgKey));
        viewer.setComparator(new ViewerComparator());
        viewer.setInput((Object)type.patternList);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((Table)viewer.getTable(), (int)6);
        gd.widthHint = LayoutUtils.hintWidth((Table)viewer.getTable(), (int)60);
        viewer.getControl().setLayoutData((Object)gd);
        type.listControl = viewer;
        final ButtonGroup buttonGroup = new ButtonGroup(parent, (ButtonGroup.IActions)this, false);
        DropDownButton addButton = new DropDownButton((Composite)buttonGroup);
        ButtonGroup.AddHandler defaultHandler = new ButtonGroup.AddHandler();
        Menu addMenu = addButton.getDropDownMenu();
        MenuItem menuItem = new MenuItem(addMenu, 8);
        menuItem.setText(String.valueOf(SharedMessages.CollectionEditing_AddItem_label) + "...");
        menuItem.addSelectionListener((SelectionListener)defaultHandler);
        menuItem = new MenuItem(addMenu, 8);
        menuItem.setText(Messages.ExclusionInclusion_AddMulti_label);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                buttonGroup.editElement(257, null);
            }
        });
        addButton.addSelectionListener((SelectionListener)defaultHandler);
        addButton.setText(String.valueOf(SharedMessages.CollectionEditing_AddItem_label) + "...");
        buttonGroup.add((Control)addButton, (ButtonGroup.SelectionHandler)defaultHandler);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonGroup.addEditButton(null);
        buttonGroup.addDeleteButton(null);
        buttonGroup.connectTo((StructuredViewer)viewer, (IObservableCollection)type.patternList, null);
        buttonGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        type.buttons = buttonGroup;
    }

    public void updateTargets() {
        this.updateTargets(this.inclusionPatterns);
        this.updateTargets(this.exclusionPatterns);
    }

    private void updateTargets(Type type) {
        type.patternList.clear();
        type.patternList.addAll((Collection)((ImList)this.element.getAttributeValue(type.attributeName)));
        type.buttons.refresh();
    }

    public IPath edit(int command, IPath item, Object parent) {
        Type type = this.getType((List)parent);
        if (command == 257) {
            this.addMultiple(type);
            return null;
        }
        ExclusionInclusionEntryDialog dialog = new ExclusionInclusionEntryDialog(this.getShell(), this.element, type.attributeName, item, (List<IPath>)type.patternList, this.uiDescription);
        if (dialog.open() == 0) {
            return dialog.getPattern();
        }
        return null;
    }

    private void addMultiple(Type type) {
        String message;
        String title;
        switch (type.attributeName) {
            case "Filter.inclusions": {
                title = Messages.ExclusionInclusion_Choose_Include_title;
                message = Messages.ExclusionInclusion_Choose_Include_Multi_description;
                break;
            }
            case "Filter.exclusions": {
                title = Messages.ExclusionInclusion_Choose_Exclude_title;
                message = Messages.ExclusionInclusion_Choose_Exclude_Multi_description;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        List<IPath> patterns = ExclusionInclusionEntryDialog.chooseExclusionPattern(this.getShell(), this.sourceFolder, title, message, null, true);
        if (patterns != null && !patterns.isEmpty()) {
            type.patternList.addAll(patterns);
            type.buttons.refresh((Object)patterns.get(0));
        }
    }

    public void updateState(IStructuredSelection selection) {
    }

    public ImList<IPath> getInclusionPatterns() {
        return ImCollections.toList((Collection)this.inclusionPatterns.patternList);
    }

    public ImList<IPath> getExclusionPatterns() {
        return ImCollections.toList((Collection)this.exclusionPatterns.patternList);
    }

    public void setFocus(String attributeName) {
        Type entry;
        if (attributeName == null) {
            attributeName = "Filter.inclusions";
        }
        if (UIAccess.isOkToUse((Viewer)(entry = this.getType(attributeName)).listControl)) {
            entry.listControl.getControl().setFocus();
        }
    }

    private static class ExclusionInclusionLabelProvider
    extends LabelProvider {
        private final Image elementImage;

        public ExclusionInclusionLabelProvider(String imgKey) {
            this.elementImage = BuildpathsUIResources.INSTANCE.getImage(imgKey);
        }

        public Image getImage(Object element) {
            return this.elementImage;
        }

        public String getText(Object element) {
            return MessageUtils.processPathPattern((String)((IPath)element).toString());
        }
    }

    private static class Type {
        private final String attributeName;
        private final IObservableList<IPath> patternList;
        private TableViewer listControl;
        private ButtonGroup<IPath> buttons;

        public Type(String key) {
            this.attributeName = key;
            this.patternList = new WritableList();
        }
    }
}

