/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.folding;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.ISourceModelStamp;
import org.eclipse.statet.ltk.model.core.IModelElementDelta;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.IModelElementInputListener;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingAnnotation;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingProvider;
import org.eclipse.ui.statushandlers.StatusManager;

public class FoldingEditorAddon
implements ISourceEditorAddon,
IModelElementInputListener,
SettingsChangeNotifier.ChangeListener {
    private final FoldingProvider provider;
    private SourceEditor1 editor;
    private volatile Input input;
    private static final int MAX_PERSISTENT_LENGTH = 2048;
    private static final int CURRENT_VERSION = 1;

    public FoldingEditorAddon(FoldingProvider provider) {
        this.provider = provider;
    }

    @Override
    public void install(ISourceEditor editor) {
        this.editor = (SourceEditor1)editor;
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener((SettingsChangeNotifier.ChangeListener)this);
        this.provider.checkConfig(null);
        this.editor.getModelInputProvider().addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void elementChanged(IModelElement element) {
        Input input = element != null ? new Input((ISourceUnit)element) : null;
        FoldingEditorAddon foldingEditorAddon = this;
        synchronized (foldingEditorAddon) {
            if (this.input != null) {
                this.saveState(this.input);
            }
            this.input = input;
        }
    }

    @Override
    public void elementInitialInfo(IModelElement element) {
        Input input = this.input;
        if (input != null && input.unit == element) {
            this.update(input, null);
        }
    }

    @Override
    public void elementUpdatedInfo(IModelElement element, IModelElementDelta delta) {
        Input input = this.input;
        if (input != null && input.unit == element) {
            this.update(input, delta.getNewAst().getStamp());
        }
    }

    @Override
    public void uninstall() {
        PreferencesUtil.getSettingsChangeNotifier().removeChangeListener((SettingsChangeNotifier.ChangeListener)this);
        if (this.editor != null) {
            this.editor.getModelInputProvider().removeListener(this);
            this.editor = null;
        }
    }

    protected void refresh() {
        Input input = this.input;
        if (input != null) {
            this.update(input, null);
        }
    }

    public void settingsChanged(Set<String> groupIds) {
        if (groupIds != null && this.provider.checkConfig(groupIds)) {
            this.refresh();
        }
    }

    private FoldingStructureComputationContext createCtx(Input input) {
        AstInfo ast;
        ISourceUnitModelInfo modelInfo;
        if (input.unit == null) {
            return null;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (this.provider.requiresModel()) {
            modelInfo = input.unit.getModelInfo(null, 2, (IProgressMonitor)monitor);
            if (modelInfo == null) {
                return null;
            }
            ast = modelInfo.getAst();
        } else {
            modelInfo = null;
            ast = input.unit.getAstInfo(null, false, (IProgressMonitor)monitor);
        }
        AbstractDocument document = input.unit.getDocument((IProgressMonitor)monitor);
        if (ast == null || document == null || ast.getStamp().getSourceStamp() != document.getModificationStamp()) {
            return null;
        }
        return new FoldingStructureComputationContext(document, modelInfo, ast, !input.isInitilized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Input input, ISourceModelStamp stamp) {
        Input input2 = input;
        synchronized (input2) {
            ProjectionAnnotation[] deletions;
            SourceEditor1 editor = this.editor;
            if (editor == null) {
                return;
            }
            if (input.unit == null || stamp != null && stamp.equals(input.updateStamp)) {
                return;
            }
            if (input != this.input) {
                return;
            }
            FoldingStructureComputationContext ctx = this.createCtx(input);
            if (ctx == null) {
                return;
            }
            try {
                this.provider.collectRegions(ctx);
            }
            catch (InvocationTargetException e) {
                return;
            }
            if (ctx.isInitial) {
                deletions = null;
                input.annotationModel = this.editor.getAdapter(ProjectionAnnotationModel.class);
                if (input.annotationModel == null) {
                    return;
                }
                input.isInitilized = true;
                input.savePropertyName = new QualifiedName("org.eclipse.statet.ltk", "FoldingState-" + editor.getSite().getId());
                if (this.provider.isRestoreStateEnabled()) {
                    this.loadState(input, ctx.table);
                }
            } else {
                ProjectionAnnotationModel model = input.annotationModel;
                ArrayList<FoldingAnnotation> del = new ArrayList<FoldingAnnotation>();
                Iterator iter = model.getAnnotationIterator();
                while (iter.hasNext()) {
                    FoldingAnnotation ann = (FoldingAnnotation)((Object)iter.next());
                    Position position = model.getPosition((Annotation)ann);
                    FoldingAnnotation newAnn = (FoldingAnnotation)((Object)ctx.table.remove(position));
                    if (newAnn != null) {
                        if (ann.update(newAnn)) continue;
                        del.add(ann);
                        ctx.table.put(newAnn.getPosition(), newAnn);
                        continue;
                    }
                    del.add(ann);
                }
                deletions = del.toArray(new FoldingAnnotation[del.size()]);
                if (ctx.document.getModificationStamp() != ctx.ast.getStamp().getSourceStamp() || input != this.input) {
                    return;
                }
            }
            LinkedHashMap<FoldingAnnotation, Position> additions = new LinkedHashMap<FoldingAnnotation, Position>();
            for (Map.Entry next : ctx.table.entrySet()) {
                additions.put((FoldingAnnotation)((Object)next.getValue()), (Position)next.getKey());
            }
            input.annotationModel.modifyAnnotations((Annotation[])deletions, additions, null);
            input.updateStamp = ctx.ast.getStamp();
        }
    }

    private void saveState(Input input) {
        SourceEditor1 editor = this.editor;
        if (!(editor != null && input.isInitilized && input.unit.isSynchronized() && input.unit instanceof IWorkspaceSourceUnit)) {
            return;
        }
        IResource resource = ((IWorkspaceSourceUnit)input.unit).getResource();
        if (resource == null || !resource.exists()) {
            return;
        }
        StringBuilder sb = new StringBuilder(1024);
        EncodedValue.writeInt(sb, 1);
        EncodedValue.writeLong(sb, resource.getModificationStamp());
        ProjectionAnnotationModel model = input.annotationModel;
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position position;
            FoldingAnnotation ann = (FoldingAnnotation)((Object)iter.next());
            int state = ann.getState();
            if (state == ann.getInitialState() || (position = model.getPosition((Annotation)ann)) == null) continue;
            EncodedValue.writeInt(sb, position.getOffset());
            EncodedValue.writeInt(sb, position.getLength());
            EncodedValue.writeInt(sb, state);
        }
        String value = sb.toString();
        try {
            QualifiedName propertyName = input.savePropertyName;
            resource.setSessionProperty(propertyName, (Object)value);
            new SaveJob(resource, propertyName).schedule();
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", NLS.bind((String)"An error occurred when saving the code folding state for {0}", (Object)resource.toString()), (Throwable)e));
        }
    }

    private void loadState(Input input, SortedMap<Position, FoldingAnnotation> table) {
        EncodedValue encoded;
        SourceEditor1 editor = this.editor;
        if (!(editor != null && input.isInitilized && input.unit.isSynchronized() && input.unit instanceof IWorkspaceSourceUnit)) {
            return;
        }
        IResource resource = ((IWorkspaceSourceUnit)input.unit).getResource();
        if (resource == null || !resource.exists()) {
            return;
        }
        try {
            QualifiedName propertyName = input.savePropertyName;
            String s = (String)resource.getSessionProperty(propertyName);
            if (s == null && (s = resource.getPersistentProperty(propertyName)) == null) {
                resource.setSessionProperty(propertyName, (Object)"");
                return;
            }
            if (s.isEmpty()) {
                return;
            }
            encoded = new EncodedValue(s);
        }
        catch (CoreException e) {
            return;
        }
        if (encoded.readInt() != 1) {
            return;
        }
        if (encoded.readLong() != resource.getModificationStamp()) {
            return;
        }
        Position position = new Position(0, 0);
        while (encoded.hasNext()) {
            position.offset = encoded.readInt();
            position.length = encoded.readInt();
            FoldingAnnotation ann = (FoldingAnnotation)((Object)table.get(position));
            if (ann == null) continue;
            ann.applyState(encoded.readInt());
        }
    }

    private static class EncodedValue {
        private static final int I_OFFSET = 32;
        private static final int I_SHIFT = 14;
        private static final int I_RADIX = 16384;
        private static final int I_MASK = 16383;
        private static final int I_FOLLOW = 32768;
        private static final int I_VALUE = Short.MAX_VALUE;
        private final String value;
        private int offset;

        public static void writeInt(StringBuilder sb, int value) {
            while (true) {
                int c = (value & 0x3FFF) + 32;
                if ((value >>>= 14) == 0) {
                    sb.append((char)c);
                    return;
                }
                sb.append((char)(0x8000 | c));
            }
        }

        public static void writeLong(StringBuilder sb, long value) {
            while (true) {
                int c = (int)(value & 0x3FFFL) + 32;
                if ((value >>>= 14) == 0L) {
                    sb.append((char)c);
                    return;
                }
                sb.append((char)(0x8000 | c));
            }
        }

        public EncodedValue(String value) {
            this.value = value;
        }

        public boolean hasNext() {
            return this.offset < this.value.length();
        }

        public long readLong() {
            long value = 0L;
            int shift = 0;
            char c;
            while (((c = this.value.charAt(this.offset++)) & 0x8000) != 0) {
                value |= (long)((c & Short.MAX_VALUE) - 32 << shift);
                shift += 14;
            }
            return value |= (long)(c - 32) << shift;
        }

        public int readInt() {
            int value = 0;
            int shift = 0;
            char c;
            while (((c = this.value.charAt(this.offset++)) & 0x8000) != 0) {
                value |= (c & Short.MAX_VALUE) - 32 << shift;
                shift += 14;
            }
            return value |= c - 32 << shift;
        }
    }

    public static final class FoldingStructureComputationContext {
        public final AbstractDocument document;
        public final ISourceUnitModelInfo model;
        public final AstInfo ast;
        public final boolean isInitial;
        private final SortedMap<Position, FoldingAnnotation> table = new TreeMap<Position, FoldingAnnotation>(TextUtil.POSITION_COMPARATOR);

        protected FoldingStructureComputationContext(AbstractDocument document, ISourceUnitModelInfo model, AstInfo ast, boolean isInitial) {
            this.document = document;
            this.model = model;
            this.ast = ast;
            this.isInitial = isInitial;
        }

        public void addFoldingRegion(FoldingAnnotation ann) {
            if (!this.table.containsKey(ann.getPosition())) {
                this.table.put(ann.getPosition(), ann);
            }
        }
    }

    private static final class Input {
        private final ISourceUnit unit;
        private boolean isInitilized;
        private ISourceModelStamp updateStamp;
        private QualifiedName savePropertyName;
        public ProjectionAnnotationModel annotationModel;

        Input(ISourceUnit unit) {
            this.unit = unit;
            this.isInitilized = false;
        }
    }

    private class SaveJob
    extends Job {
        private final IResource resource;
        private final QualifiedName propertyName;

        public SaveJob(IResource resource, QualifiedName propertyName) {
            super(NLS.bind((String)"Save Folding State for ''{0}''", (Object)resource.toString()));
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(30);
            this.resource = resource;
            this.propertyName = propertyName;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (!this.resource.exists()) {
                    return Status.OK_STATUS;
                }
                String value = (String)this.resource.getSessionProperty(this.propertyName);
                if ((value = this.checkValue(value)) != null) {
                    this.resource.setPersistentProperty(this.propertyName, value);
                }
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return new Status(4, "org.eclipse.statet.ltk.ui", NLS.bind((String)"An error occurred when saving the code folding state for {0}", (Object)this.resource.toString()), (Throwable)e);
            }
        }

        private String checkValue(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            if (value.length() <= 2048) {
                return value;
            }
            EncodedValue encoded = new EncodedValue(value);
            StringBuilder sb = new StringBuilder(2048);
            if (encoded.readInt() != 1) {
                return null;
            }
            EncodedValue.writeInt(sb, 1);
            EncodedValue.writeLong(sb, encoded.readLong());
            int collapedBegin = -1;
            int collapedEnd = -1;
            while (encoded.hasNext()) {
                int l = sb.length();
                int offset = encoded.readInt();
                int length = encoded.readInt();
                int state = encoded.readInt();
                if (offset >= collapedBegin && offset + length <= collapedEnd) continue;
                EncodedValue.writeInt(sb, offset);
                EncodedValue.writeInt(sb, length);
                EncodedValue.writeInt(sb, state);
                if (sb.length() > 2048) {
                    return sb.substring(0, l);
                }
                if (state != 2) continue;
                collapedBegin = offset;
                collapedEnd = offset + length;
            }
            return sb.toString();
        }
    }
}

