/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.internal.nico.core.Messages;
import org.eclipse.statet.internal.nico.core.NicoCorePlugin;
import org.eclipse.statet.internal.nico.core.RunnableProgressData;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.CopyOnWriteList;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.CancelStatus;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolCommandHandler;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.NicoCoreMessages;
import org.eclipse.statet.nico.core.runtime.ConsoleRunnable;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.IProgressInfo;
import org.eclipse.statet.nico.core.runtime.ITrack;
import org.eclipse.statet.nico.core.runtime.Prompt;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.nico.core.runtime.ToolStreamProxy;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;

public abstract class ToolController
implements ConsoleService {
    private static final boolean DEBUG_LOG_STATE = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.nico/debug/ToolController/logState"));
    private static final int STEP_BEGIN = 7;
    private static IProgressMonitor fgProgressMonitorDummy = new NullProgressMonitor();
    public static final String START_TYPE_ID = "common/start";
    public static final String QUIT_TYPE_ID = "common/quit";
    public static final String SUSPENDED_INSERT_TYPE_ID = "common/debug/suspended.insert";
    public static final String SUSPENDED_UPDATE_TYPE_ID = "common/debug/suspended.update";
    public static final String SUSPEND_TYPE_ID = "common/debug/suspend";
    public static final String RESUME_TYPE_ID = "common/debug/resume";
    public static final String STEP_INTO_TYPE_ID = "common/debug/step.in";
    public static final String STEP_OVER_TYPE_ID = "common/debug/step.over";
    public static final String STEP_RETURN_TYPE_ID = "common/debug/step.return";
    public static final int CANCEL_CURRENT = 0;
    public static final int CANCEL_ALL = 1;
    public static final int CANCEL_PAUSE = 16;
    protected static final int SUSPENDED_TOPLEVEL = 1;
    protected static final int SUSPENDED_DEEPLEVEL = 2;
    private static final byte REGULAR = 0;
    private static final byte HOT_REGULAR = 1;
    private static final byte HOT_NESTED = 2;
    private ToolStreamProxy streams;
    private final ToolProcess process;
    private final Queue queue;
    private int counter = 0;
    private RunnableData currentRunnable;
    private SubmitType currentSubmitType;
    private final List<SystemRunnable> controllerRunnables = new ArrayList<SystemRunnable>();
    private SystemRunnable postControllerRunnable;
    private RunnableProgressData runnableProgressData;
    private Thread controllerThread;
    private ToolStatus status = ToolStatus.STARTING;
    private ToolStatus statusPrevious;
    private final CopyOnWriteIdentityListSet<IToolStatusListener> toolStatusListeners = new CopyOnWriteIdentityListSet();
    private int internalTask;
    private boolean terminateForced;
    private volatile boolean isTerminated;
    private boolean hotModeDeferred;
    private boolean hotModeNested = true;
    private byte hotMode = 0;
    private final ProgressMonitor hotModeMonitor = new org.eclipse.statet.jcommons.status.NullProgressMonitor();
    private boolean isDebugEnabled;
    private int suspendedRequestLevel;
    private int loopCurrentLevel;
    private int suspendedRunLevel;
    private int suspendedLowerLevel;
    private final CopyOnWriteList<SystemRunnable> suspendUpdateRunnables = new CopyOnWriteList();
    private SuspendResumeRunnable suspendExitRunnable;
    private int suspendEnterDetail;
    private Object suspendEnterData;
    private int suspendExitDetail;
    private ToolWorkspace workspaceData;
    private volatile int currentStamp;
    private int changeStamp;
    private int hotStamp;
    private final Map<String, ToolCommandHandler> actionHandlers = new HashMap<String, ToolCommandHandler>();
    protected String fCurrentInput;
    protected Prompt fCurrentPrompt;
    protected Prompt fDefaultPrompt;
    protected String fLineSeparator;
    private final CopyOnWriteIdentityListSet<Disposable> disposables = new CopyOnWriteIdentityListSet();

    protected ToolController(ToolProcess process, Map<String, Object> connectionInfo) {
        this.process = process;
        this.process.connectionInfo = connectionInfo;
        this.streams = new ToolStreamProxy();
        this.queue = process.getQueue();
        this.toolStatusListeners.add((Object)this.process);
        this.status = ToolStatus.STARTING;
        this.runnableProgressData = new RunnableProgressData(Messages.Progress_Starting_label);
        this.fCurrentPrompt = Prompt.NONE;
    }

    protected void setWorksapceData(ToolWorkspace workspaceData) {
        this.workspaceData = workspaceData;
    }

    public final void addCommandHandler(String commandId, ToolCommandHandler handler) {
        this.actionHandlers.put(commandId, handler);
    }

    public final ToolCommandHandler getCommandHandler(String commandId) {
        return this.actionHandlers.get(commandId);
    }

    public final void addToolStatusListener(IToolStatusListener listener) {
        this.toolStatusListeners.add((Object)listener);
    }

    public final void removeToolStatusListener(IToolStatusListener listener) {
        this.toolStatusListeners.remove((Object)listener);
    }

    protected void setStartupTimestamp(long timestamp) {
        this.process.setStartupTimestamp(timestamp);
    }

    protected void setStartupWD(String wd) {
        this.process.setStartupWD(wd);
    }

    protected void addDisposable(Disposable disposable) {
        this.disposables.add((Object)disposable);
    }

    protected final Queue getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ToolStatus getStatus() {
        Queue queue = this.queue;
        synchronized (queue) {
            return this.status;
        }
    }

    protected final ToolStatus getStatusL() {
        return this.status;
    }

    public final IProgressInfo getProgressInfo() {
        return this.runnableProgressData;
    }

    protected final Thread getControllerThread() {
        return this.controllerThread;
    }

    public final ToolStreamProxy getStreams() {
        return this.streams;
    }

    @Override
    public ToolProcess getTool() {
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() throws StatusException {
        assert (this.status == ToolStatus.STARTING);
        try {
            Queue.Section queueSection = this.queue.getTopLevelSection();
            this.controllerThread = Thread.currentThread();
            this.setCurrentRunnable(this.createRunnableData(this.createStartRunnable(), queueSection));
            this.startToolL(this.runnableProgressData.getRoot());
            this.setCurrentRunnable(new RunnableData(null, SubmitType.CONSOLE, queueSection));
            Queue queue = this.queue;
            synchronized (queue) {
                this.loopChangeStatus(this.controllerRunnables.isEmpty() ? ToolStatus.STARTED_IDLING : ToolStatus.STARTED_PROCESSING, null);
            }
            this.loopTopLevel(queueSection);
        }
        catch (Throwable throwable) {
            Queue queue = this.queue;
            synchronized (queue) {
                if (!this.isTerminated) {
                    this.isTerminated = true;
                }
                this.loopChangeStatus(ToolStatus.TERMINATED, null);
                this.queue.notifyAll();
            }
            this.clear();
            this.controllerThread = null;
            throw throwable;
        }
        Queue queue = this.queue;
        synchronized (queue) {
            if (!this.isTerminated) {
                this.isTerminated = true;
            }
            this.loopChangeStatus(ToolStatus.TERMINATED, null);
            this.queue.notifyAll();
        }
        this.clear();
        this.controllerThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getHotTasksState() {
        Queue queue = this.queue;
        synchronized (queue) {
            return this.hotMode;
        }
    }

    protected final boolean isInHotModeL() {
        return this.hotMode != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSuspended() {
        Queue queue = this.queue;
        synchronized (queue) {
            return this.suspendedRequestLevel > 0 || this.loopCurrentLevel > 0;
        }
    }

    protected final boolean isSuspendedL() {
        return this.suspendedRequestLevel > 0 || this.loopCurrentLevel > 0;
    }

    public int getTaskCounter() {
        return this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final boolean cancelTask(int options) {
        Queue queue;
        Queue queue2 = this.queue;
        synchronized (queue2) {
            if ((options & 1) != 0) {
                List<ToolRunnable> list = this.queue.internal_getCurrentList();
                list.clear();
            }
            if ((options & 0x10) != 0) {
                this.queue.pause();
            }
            this.runnableProgressData.setCanceled(true);
            this.beginInternalTask();
            if (this.suspendedRequestLevel > this.loopCurrentLevel) {
                this.setSuspended(this.loopCurrentLevel, 0, null);
                this.suspendExitDetail = 1;
            } else if (this.loopCurrentLevel > this.suspendedLowerLevel) {
                this.setSuspended(this.suspendedLowerLevel, 0, null);
                this.suspendExitDetail = 1;
            }
        }
        try {
            this.interruptTool();
            queue = this.queue;
        }
        catch (UnsupportedOperationException e) {
            Queue queue3 = this.queue;
            synchronized (queue3) {
                this.scheduleControllerRunnable(this.createCancelPostRunnable(options));
                this.endInternalTask();
            }
            return false;
            catch (Throwable throwable) {
                Queue queue4 = this.queue;
                synchronized (queue4) {
                    this.scheduleControllerRunnable(this.createCancelPostRunnable(options));
                    this.endInternalTask();
                }
                throw throwable;
            }
        }
        synchronized (queue) {
            this.scheduleControllerRunnable(this.createCancelPostRunnable(options));
            this.endInternalTask();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scheduleQuit() {
        Queue queue = this.queue;
        synchronized (queue) {
            if (this.status == ToolStatus.TERMINATED) {
                return;
            }
            this.beginInternalTask();
        }
        boolean schedule = true;
        try {
            ToolCommandHandler handler = this.actionHandlers.get("common/scheduleQuit");
            if (handler != null) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("scheduledQuitRunnables", this.getQuitRunnables());
                Status status = this.executeHandler("common/scheduleQuit", handler, data, (ProgressMonitor)new org.eclipse.statet.jcommons.status.NullProgressMonitor());
                if (status != null && status.getSeverity() > 0) {
                    schedule = false;
                }
            }
        }
        catch (Throwable throwable) {
            Queue queue2 = this.queue;
            synchronized (queue2) {
                if (this.status != ToolStatus.TERMINATED && schedule) {
                    QuitRunnable runnable = this.createQuitRunnable();
                    this.queue.add(runnable);
                }
                this.endInternalTask();
            }
            throw throwable;
        }
        Queue queue3 = this.queue;
        synchronized (queue3) {
            if (this.status != ToolStatus.TERMINATED && schedule) {
                QuitRunnable runnable = this.createQuitRunnable();
                this.queue.add(runnable);
            }
            this.endInternalTask();
        }
    }

    protected void setTracks(List<? extends ITrack> tracks) {
        this.process.setTracks(tracks);
    }

    protected final void beginInternalTask() {
        ++this.internalTask;
    }

    protected final void endInternalTask() {
        --this.internalTask;
        if (this.controllerRunnables.size() > 0 || this.internalTask == 0) {
            this.queue.notifyAll();
        }
    }

    protected abstract ToolRunnable createStartRunnable();

    protected QuitRunnable createQuitRunnable() {
        return new QuitRunnable();
    }

    protected SystemRunnable createCancelPostRunnable(int options) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelQuit() {
        Queue queue = this.queue;
        synchronized (queue) {
            this.queue.remove(this.getQuitRunnables());
            if (this.status == ToolStatus.TERMINATED) {
                return;
            }
        }
        ToolRunnable current = this.currentRunnable.runnable;
        if (current != null && current.getTypeId() == QUIT_TYPE_ID) {
            this.cancelTask(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<ToolRunnable> getQuitRunnables() {
        List<ToolRunnable> waiting;
        ToolRunnable current;
        Queue queue = this.queue;
        synchronized (queue) {
            current = this.currentRunnable.runnable;
            waiting = this.queue.internal_getCurrentList();
        }
        ArrayList<ToolRunnable> quitRunnables = new ArrayList<ToolRunnable>();
        if (current != null && current.getTypeId() == QUIT_TYPE_ID) {
            quitRunnables.add(current);
        }
        for (ToolRunnable runnable : waiting) {
            if (runnable.getTypeId() != QUIT_TYPE_ID) continue;
            quitRunnables.add(runnable);
        }
        return quitRunnables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void kill(ProgressMonitor m) throws StatusException {
        Thread thread = this.getControllerThread();
        this.killTool(m);
        if (thread != null) {
            int i = 0;
            while (i < 3) {
                if (this.isTerminated()) {
                    return;
                }
                Queue queue = this.queue;
                synchronized (queue) {
                    this.queue.notifyAll();
                    try {
                        this.queue.wait(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                thread.interrupt();
                ++i;
            }
        }
        if (!this.isTerminated()) {
            this.markAsTerminated();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void loopChangeStatus(ToolStatus newStatus, RunnableProgressData newMonitor) {
        if (this.status != newStatus && newMonitor == null) {
            newMonitor = new RunnableProgressData(newStatus.getMarkedLabel());
        }
        if (newMonitor != null) {
            this.runnableProgressData = newMonitor;
        }
        if (newStatus == this.status) {
            if (newStatus != ToolStatus.STARTED_PROCESSING || this.loopCurrentLevel <= 0) return;
            ImIdentityList listeners = this.toolStatusListeners.toList();
            List<DebugEvent> eventList = this.queue.internal_getEventList();
            for (IToolStatusListener listener : listeners) {
                if (!(listener instanceof IThread)) continue;
                listener.controllerStatusChanged(this.statusPrevious, newStatus, eventList);
            }
        } else {
            if (newStatus == ToolStatus.STARTED_SUSPENDED) {
                this.suspendExitDetail = 0;
            }
            if (newStatus == ToolStatus.STARTED_PROCESSING && (this.status != ToolStatus.STARTED_PAUSED || this.statusPrevious != ToolStatus.STARTED_PROCESSING)) {
                this.queue.internal_resetOnIdle();
            }
            this.queue.internal_onStatusChanged(newStatus);
            this.statusPrevious = this.status;
            this.status = newStatus;
            ImIdentityList listeners = this.toolStatusListeners.toList();
            List<DebugEvent> eventList = this.queue.internal_getEventList();
            for (IToolStatusListener listener : listeners) {
                listener.controllerStatusChanged(this.statusPrevious, newStatus, eventList);
            }
        }
        if (DEBUG_LOG_STATE) {
            this.logEvents("loopChangeStatus", newStatus);
        }
        this.queue.internal_fireEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scheduleControllerRunnable(SystemRunnable runnable) {
        Queue queue = this.queue;
        synchronized (queue) {
            if (!this.controllerRunnables.contains(runnable)) {
                this.controllerRunnables.add(runnable);
            }
            if (this.status != ToolStatus.STARTED_PROCESSING) {
                this.queue.notifyAll();
            }
        }
    }

    protected final void addPostControllerRunnable(SystemRunnable runnable) {
        this.postControllerRunnable = runnable;
    }

    protected final void removePostControllerRunnable(ToolRunnable runnable) {
        if (this.postControllerRunnable == runnable) {
            this.postControllerRunnable = null;
        }
    }

    public final Status submit(String text, SubmitType type) {
        return this.submit(Collections.singletonList(text), type);
    }

    public final Status submit(List<String> text, SubmitType type, IProgressMonitor monitor) {
        try {
            monitor.beginTask(NicoCoreMessages.SubmitTask_label, 2);
            assert (text != null);
            Object[] runs = new ToolRunnable[text.size()];
            int i = 0;
            while (i < text.size()) {
                runs[i] = this.createCommandRunnable(text.get(i), type);
                ++i;
            }
            if (monitor.isCanceled()) {
                CancelStatus cancelStatus = new CancelStatus("org.eclipse.statet.nico.core", Messages.ToolController_SubmitCancelled_message, null);
                return cancelStatus;
            }
            monitor.worked(1);
            Status status = this.queue.add((List<ToolRunnable>)ImCollections.newList((Object[])runs));
            return status;
        }
        finally {
            monitor.done();
        }
    }

    public final Status submit(List<String> text, SubmitType type) {
        return this.submit(text, type, fgProgressMonitorDummy);
    }

    public abstract ToolRunnable createCommandRunnable(String var1, SubmitType var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loopTopLevel(Queue.Section queueSection) {
        if (this.hotModeDeferred) {
            this.hotModeDeferred = false;
            this.scheduleHotMode();
        }
        boolean enterSuspended = false;
        while (true) {
            if (enterSuspended) {
                enterSuspended = false;
                this.runSuspendedLoopL(1);
            } else {
                this.loopRunTask(queueSection);
            }
            Queue queue = this.queue;
            synchronized (queue) {
                this.queue.internal_check();
                if (this.internalTask > 0) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                if (this.isTerminated) {
                    this.process.setExitValue(this.finishToolL());
                    this.loopChangeStatus(ToolStatus.TERMINATED, null);
                    return;
                }
                if (this.controllerRunnables.size() > 0) {
                    continue;
                }
                if (this.suspendedRequestLevel > 0) {
                    enterSuspended = true;
                    continue;
                }
                if (this.queue.internal_isPauseRequested()) {
                    this.loopChangeStatus(ToolStatus.STARTED_PAUSED, null);
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                if (this.queue.internal_next() < 0) {
                    this.loopChangeStatus(ToolStatus.STARTED_IDLING, null);
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loopSuspended(int level, Queue.Section queueSection) {
        boolean enterSuspended = false;
        while (true) {
            if (enterSuspended) {
                enterSuspended = false;
                this.runSuspendedLoopL(1);
            } else {
                this.loopRunTask(queueSection);
            }
            Queue queue = this.queue;
            synchronized (queue) {
                this.queue.internal_check();
                if (this.internalTask > 0) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                if (this.isTerminated) {
                    return;
                }
                if (this.suspendedRequestLevel < level) {
                    return;
                }
                if (this.controllerRunnables.size() > 0) {
                    continue;
                }
                if (this.suspendedRequestLevel > level) {
                    enterSuspended = true;
                    continue;
                }
                if (this.queue.internal_isPauseRequested()) {
                    this.loopChangeStatus(ToolStatus.STARTED_PAUSED, null);
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                if (this.queue.internal_next() < 0) {
                    this.loopChangeStatus(ToolStatus.STARTED_SUSPENDED, null);
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void loopRunTask(Queue.Section queueSection) {
        block36: while (true) {
            savedCurrentRunnable = this.currentRunnable;
            var5_5 = this.queue;
            synchronized (var5_5) {
                if (this.controllerRunnables.size() > 0) {
                    type = 1;
                    runnable = (ToolRunnable)this.controllerRunnables.remove(0);
                } else {
                    if (this.loopCurrentLevel != this.suspendedRequestLevel || this.isTerminated || this.internalTask > 0 || this.queue.internal_isPauseRequested()) {
                        return;
                    }
                    type = this.queue.internal_next();
                    switch (type) {
                        case 2: {
                            runnable = null;
                            break;
                        }
                        case 3: 
                        case 4: {
                            runnable = this.queue.internal_poll();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (type != 2) {
                    if (this.loopCurrentLevel > 0) {
                        if (type != 1 && runnable instanceof ConsoleCommandRunnable && !this.runConsoleCommandInSuspend(((ConsoleCommandRunnable)runnable).fText)) {
                            try {
                                this.queue.internal_onFinished(runnable, 344);
                            }
                            finally {
                                this.setCurrentRunnable(savedCurrentRunnable);
                            }
                            return;
                        }
                        if (runnable instanceof SuspendResumeRunnable) {
                            this.suspendExitDetail = SuspendResumeRunnable.access$0((SuspendResumeRunnable)runnable);
                        } else {
                            detail = this.getDebugResumeDetailL(runnable);
                            if (this.status == ToolStatus.STARTED_SUSPENDED || this.getDebugResumeDetailPriority(detail) >= this.getDebugResumeDetailPriority(this.suspendExitDetail)) {
                                this.suspendExitDetail = detail;
                            }
                        }
                    }
                    this.setCurrentRunnable(this.createRunnableData(runnable, queueSection));
                    this.loopChangeStatus(ToolStatus.STARTED_PROCESSING, new RunnableProgressData(runnable));
                }
            }
            switch (type) {
                case 1: {
                    runnableProgressMonitor = this.runnableProgressData.getRoot();
                    try {
                        runnable.run((ToolService)this, runnableProgressMonitor);
                        this.safeRunnableChanged(runnable, 336);
                        continue block36;
                    }
                    catch (Throwable e) {
                        v1 = status = e instanceof StatusException != false ? ((StatusException)e).getStatus() : null;
                        if (status != null && (status.getSeverity() == 8 || status.getSeverity() <= 1)) {
                            this.safeRunnableChanged(runnable, 344);
                        } else {
                            NicoCorePlugin.logError(-1, NLS.bind((String)"An Error occurred when running internal controller task ''{0}''.", (Object)runnable.getLabel()), e);
                            this.safeRunnableChanged(runnable, 340);
                        }
                        if (!this.isToolAlive()) {
                            this.markAsTerminated();
                        }
                        return;
                    }
                    finally {
                        this.setCurrentRunnable(savedCurrentRunnable);
                        continue block36;
                    }
                }
                case 2: {
                    try {
                        this.hotModeNested = false;
                        if (this.initilizeHotMode() || this.isToolAlive()) continue block36;
                        this.markAsTerminated();
                        continue block36;
                    }
                    finally {
                        this.hotModeNested = true;
                        continue block36;
                    }
                }
                case 3: 
                case 4: {
                    runnableProgressMonitor = this.runnableProgressData.getRoot();
                    try {
                        ++this.counter;
                        runnableProgressMonitor.setWorkRemaining(100);
                        runnable.run((ToolService)this, runnableProgressMonitor.newSubMonitor(99));
                        runnableProgressMonitor.setWorkRemaining(1);
                        this.onTaskFinished(this.currentRunnable, 336, runnableProgressMonitor);
                    }
                    catch (Throwable e) {
                        try {
                            runnableProgressMonitor.setWorkRemaining(1);
                            v3 = status = e instanceof StatusException != false ? ((StatusException)e).getStatus() : null;
                            if (status != null && (status.getSeverity() == 8 || status.getSeverity() <= 1)) {
                                this.onTaskFinished(this.currentRunnable, 344, runnableProgressMonitor);
                            } else {
                                this.onTaskFinished(this.currentRunnable, 340, runnableProgressMonitor);
                                status = new ErrorStatus("org.eclipse.statet.nico.core", 105, String.format("Failed to complete '%1$s'.", new Object[]{runnable.getLabel()}), e);
                                if (type == 4) {
                                    this.handleStatus(status, runnableProgressMonitor);
                                } else {
                                    this.logRunnableStatus(status, this.currentRunnable);
                                }
                            }
                            if (this.isToolAlive()) ** GOTO lbl130
                            this.markAsTerminated();
                        }
                        catch (Throwable var8_15) {
                            runnableProgressMonitor.setWorkRemaining(0);
                            if (this.postControllerRunnable != null) {
                                var9_11 = this.queue;
                                synchronized (var9_11) {
                                    this.controllerRunnables.remove(this.postControllerRunnable);
                                    this.controllerRunnables.add(this.postControllerRunnable);
                                }
                            }
                            this.setCurrentRunnable(savedCurrentRunnable);
                            throw var8_15;
                        }
lbl130:
                        // 2 sources

                        runnableProgressMonitor.setWorkRemaining(0);
                        if (this.postControllerRunnable != null) {
                            var9_11 = this.queue;
                            synchronized (var9_11) {
                                this.controllerRunnables.remove(this.postControllerRunnable);
                                this.controllerRunnables.add(this.postControllerRunnable);
                            }
                        }
                        this.setCurrentRunnable(savedCurrentRunnable);
                        return;
                    }
                    runnableProgressMonitor.setWorkRemaining(0);
                    if (this.postControllerRunnable != null) {
                        var9_11 = this.queue;
                        synchronized (var9_11) {
                            this.controllerRunnables.remove(this.postControllerRunnable);
                            this.controllerRunnables.add(this.postControllerRunnable);
                        }
                    }
                    this.setCurrentRunnable(savedCurrentRunnable);
                    continue block36;
                }
            }
        }
    }

    protected void onTaskFinished(RunnableData runnableData, int event, ProgressMonitor m) {
        this.queue.internal_onFinished(runnableData.runnable, event);
        this.safeRunnableChanged(runnableData.runnable, event);
    }

    private void safeRunnableChanged(ToolRunnable runnable, int event) {
        try {
            runnable.changed(event, (Tool)this.process);
        }
        catch (Throwable e) {
            NicoCorePlugin.logError(105, NLS.bind((String)Messages.ToolRunnable_error_RuntimeError_message, (Object)this.process.getLabel(1), (Object)runnable.getLabel()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scheduleHotMode() {
        ToolStatus status;
        ToolController toolController = this;
        synchronized (toolController) {
            status = this.status;
        }
        switch (status) {
            case TERMINATED: {
                return;
            }
            case STARTING: {
                this.hotModeDeferred = true;
                return;
            }
        }
        this.requestHotMode(Thread.currentThread() != this.controllerThread);
    }

    protected void requestHotMode(boolean async) {
    }

    protected boolean initilizeHotMode() {
        return true;
    }

    private final ToolRunnable pollHotRunnable() {
        ToolRunnable runnable = null;
        if (!this.isTerminated && (runnable = this.queue.internal_pollHot()) == null && !this.hotModeNested) {
            try {
                this.queue.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isTerminated) {
                runnable = this.queue.internal_pollHot();
            }
        }
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runHotModeLoop() {
        while (true) {
            ToolRunnable runnable;
            Queue queue = this.queue;
            synchronized (queue) {
                runnable = this.pollHotRunnable();
                if (runnable == null) {
                    if (this.hotMode != 0) {
                        this.onHotModeExit(this.hotModeMonitor);
                        this.hotMode = 0;
                        this.currentSubmitType = this.currentRunnable.submitType;
                    }
                    return;
                }
                if (this.hotMode == 0) {
                    this.hotMode = (byte)(this.hotModeNested ? 2 : 1);
                    this.currentSubmitType = SubmitType.OTHER;
                    this.onHotModeEnter(this.hotModeMonitor);
                }
                this.hotModeMonitor.setCanceled(false);
            }
            try {
                runnable.run((ToolService)this, this.hotModeMonitor);
                this.safeRunnableChanged(runnable, 336);
                continue;
            }
            catch (Throwable e) {
                Status status;
                Status status2 = status = e instanceof StatusException ? ((StatusException)e).getStatus() : null;
                if (status != null && (status.getSeverity() == 8 || status.getSeverity() <= 1)) {
                    this.safeRunnableChanged(runnable, 344);
                } else {
                    this.safeRunnableChanged(runnable, 340);
                    NicoCorePlugin.logError(-1, "An Error occurred when running hot task.", e);
                }
                if (this.isToolAlive()) continue;
                this.markAsTerminated();
                continue;
            }
            break;
        }
    }

    protected void onHotModeEnter(ProgressMonitor m) {
        if (this.hotMode > 1) {
            this.enableHotStamp();
        }
    }

    protected void onHotModeExit(ProgressMonitor m) {
        this.disableHotStamp();
    }

    public final boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    protected void setDebugEnabled(boolean enabled) {
        this.isDebugEnabled = enabled;
    }

    protected int getDebugResumeDetailL(ToolRunnable runnable) {
        switch (this.getSubmitTypeL(runnable)) {
            case CONSOLE: 
            case EDITOR: {
                return 0;
            }
            case OTHER: {
                return 128;
            }
        }
        return 64;
    }

    private int getDebugResumeDetailPriority(int detail) {
        switch (detail) {
            case 128: {
                return 1;
            }
            case 64: {
                return 2;
            }
            case 1: 
            case 2: 
            case 4: {
                return 3;
            }
        }
        return 4;
    }

    protected int setSuspended(int level, int enterDetail, Object enterData) {
        this.suspendedRequestLevel = level;
        if (enterDetail == 0 && (this.suspendExitDetail & 7) != 0) {
            this.suspendEnterDetail = 8;
            this.suspendEnterData = null;
        } else {
            this.suspendEnterDetail = enterDetail;
            this.suspendEnterData = enterData;
        }
        return level - this.suspendedRunLevel;
    }

    public void addSuspendUpdateRunnable(SystemRunnable runnable) {
        this.suspendUpdateRunnables.add((Object)runnable);
    }

    protected boolean runConsoleCommandInSuspend(String input) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSuspendExitRunnable(SuspendResumeRunnable runnable) throws StatusException {
        Queue queue = this.queue;
        synchronized (queue) {
            if (this.loopCurrentLevel == 0) {
                return;
            }
            if (this.suspendExitRunnable != null) {
                this.queue.remove(this.suspendExitRunnable);
                this.controllerRunnables.remove(this.suspendExitRunnable);
            }
            this.suspendExitRunnable = runnable;
            if (Thread.currentThread() == this.controllerThread) {
                runnable.run(this, null);
            } else {
                this.scheduleControllerRunnable(runnable);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void runSuspendedLoopL(int o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doRunSuspendedLoopL(int o, int level, Queue.Section queueSection) {
        this.loopSuspended(level, queueSection);
    }

    protected int getCurrentLevelL() {
        return this.loopCurrentLevel;
    }

    protected int getRequestedLevelL() {
        return this.suspendedRequestLevel;
    }

    public int getSuspendEnterDetail() {
        return this.suspendEnterDetail;
    }

    public Object getSuspendEnterData() {
        return this.suspendEnterData;
    }

    public int getSuspendExitDetail() {
        return this.suspendExitDetail;
    }

    protected final void markAsTerminated() {
        if (this.isToolAlive()) {
            NicoCorePlugin.logError(197120, "Illegal state: tool marked as terminated but still alive.", null);
        }
        this.isTerminated = true;
    }

    protected final boolean isTerminated() {
        return this.isTerminated;
    }

    protected abstract void startToolL(ProgressMonitor var1) throws StatusException;

    protected abstract void killTool(ProgressMonitor var1);

    protected abstract boolean isToolAlive();

    protected void interruptTool() throws UnsupportedOperationException {
        Thread thread = this.getControllerThread();
        if (thread != null) {
            thread.interrupt();
        }
    }

    protected int finishToolL() {
        return 0;
    }

    protected void clear() {
        this.streams.dispose();
        this.streams = null;
        ImIdentityList disposables = this.disposables.clearToList();
        for (Disposable disposable : disposables) {
            try {
                disposable.dispose();
            }
            catch (Exception e) {
                NicoCorePlugin.logError("An unexepected exception is thrown when disposing a controller extension.", e);
            }
        }
    }

    @Override
    public void handleStatus(Status status, ProgressMonitor m) {
        Map<String, Status> data;
        Status reportStatus;
        if (status == null || status.getSeverity() == 0) {
            return;
        }
        ToolCommandHandler handler = this.getCommandHandler("common/reportStatus");
        if (handler != null && (reportStatus = this.executeHandler("common/reportStatus", handler, data = Collections.singletonMap("status", status), m)) != null && reportStatus.getSeverity() == 0) {
            return;
        }
        if (status.getSeverity() > 1) {
            this.logRunnableStatus(status, this.currentRunnable);
        }
    }

    private void logRunnableStatus(Status status, RunnableData runnableData) {
        NicoCorePlugin.log((IStatus)new MultiStatus("org.eclipse.statet.nico.core", 0, new IStatus[]{StatusUtils.convert((Status)status)}, NicoCoreMessages.format_ProblemWhileRunningTask_message(runnableData.runnable.getLabel(), this.process), null));
    }

    protected Status executeHandler(String commandID, ToolCommandHandler handler, Map<String, Object> data, ProgressMonitor m) {
        try {
            return handler.execute(commandID, (ToolService)this, data, m);
        }
        catch (Exception e) {
            NicoCorePlugin.logError(NLS.bind((String)"An error occurred when executing tool command ''{0}''.", (Object)commandID), e);
            return null;
        }
    }

    protected void initRunnableAdapterL() {
        this.fCurrentPrompt = this.fDefaultPrompt = this.workspaceData.getDefaultPrompt();
        this.fLineSeparator = this.workspaceData.getLineSeparator();
    }

    @Override
    public final ToolController getController() {
        return this;
    }

    private RunnableData createRunnableData(ToolRunnable runnable, Queue.Section queueSection) {
        return new RunnableData(runnable, this.getSubmitTypeL(runnable), queueSection);
    }

    private void setCurrentRunnable(RunnableData runnable) {
        this.currentRunnable = runnable;
        this.currentSubmitType = runnable.submitType;
    }

    protected SubmitType getSubmitTypeL(ToolRunnable runnable) {
        if (runnable instanceof ConsoleRunnable) {
            return ((ConsoleRunnable)runnable).getSubmitType();
        }
        if (runnable instanceof SystemRunnable) {
            return SubmitType.OTHER;
        }
        return SubmitType.TOOLS;
    }

    @Override
    public ToolRunnable getCurrentRunnable() {
        return this.currentRunnable.runnable;
    }

    public Queue.Section getCurrentQueueSection() {
        return this.currentRunnable.queueSection;
    }

    public SubmitType getCurrentSubmitType() {
        return this.currentSubmitType;
    }

    public String getProperty(String key) {
        return null;
    }

    @Override
    public final void refreshWorkspaceData(int options, ProgressMonitor m) throws StatusException {
        this.workspaceData.controlRefresh(options, this, m);
    }

    @Override
    public ToolWorkspace getWorkspaceData() {
        return this.workspaceData;
    }

    @Override
    public boolean isDefaultPrompt() {
        return this.fDefaultPrompt == this.fCurrentPrompt;
    }

    @Override
    public Prompt getPrompt() {
        return this.fCurrentPrompt;
    }

    protected void setCurrentPromptL(Prompt prompt) {
        this.fCurrentPrompt = prompt;
        this.workspaceData.controlSetCurrentPrompt(prompt, this.status);
    }

    protected void setDefaultPromptTextL(String text) {
        this.fDefaultPrompt = new Prompt(text, 2);
        this.workspaceData.controlSetDefaultPrompt(this.fDefaultPrompt);
    }

    protected void setLineSeparatorL(String newSeparator) {
        this.fLineSeparator = newSeparator;
        this.workspaceData.controlSetLineSeparator(newSeparator);
    }

    protected void setFileSeparatorL(char newSeparator) {
        this.workspaceData.controlSetFileSeparator(newSeparator);
    }

    protected void setWorkspaceDirL(IFileStore directory) {
        this.workspaceData.controlSetWorkspaceDir(directory);
    }

    protected void setRemoteWorkspaceDirL(IPath directory) {
        this.workspaceData.controlSetRemoteWorkspaceDir(directory);
    }

    public final int getChangeStamp() {
        return this.currentStamp;
    }

    private void touchChangeStamp() {
        this.currentStamp = this.changeStamp = this.changeStamp + 1 & Integer.MAX_VALUE;
    }

    private void enableHotStamp() {
        this.currentStamp = this.hotStamp = this.hotStamp + 1 | Integer.MIN_VALUE;
    }

    private void disableHotStamp() {
        this.currentStamp = this.changeStamp;
    }

    public void briefAboutToChange() {
        this.touchChangeStamp();
    }

    public void briefChanged(int flags) {
        this.briefChanged(null, flags);
    }

    public void briefChanged(Object obj, int flags) {
        this.touchChangeStamp();
        this.workspaceData.controlBriefChanged(obj, flags);
        if (DEBUG_LOG_STATE) {
            this.logChanged();
        }
    }

    private void logEvents(String label, ToolStatus status) {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(label);
        sb.addProp("status", (Object)this.status);
        sb.addProp("changeStamp", this.changeStamp);
        sb.addProp("events", this.queue.internal_getEventList());
        NicoCorePlugin.log((Status)new InfoStatus("org.eclipse.statet.nico.core", sb.toString()));
    }

    private void logChanged() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("changed");
        sb.addProp("changeStamp", this.changeStamp);
        NicoCorePlugin.log((Status)new InfoStatus("org.eclipse.statet.nico.core", sb.toString()));
    }

    @Override
    public void submitToConsole(String input, ProgressMonitor m) throws StatusException {
        this.fCurrentInput = input;
        this.doBeforeSubmitL();
        this.doSubmitL(m);
    }

    protected void doBeforeSubmitL() {
        ToolStreamProxy streams = this.getStreams();
        SubmitType submitType = this.getCurrentSubmitType();
        streams.getInfoStreamMonitor().append(this.fCurrentPrompt.text, submitType, this.fCurrentPrompt.meta);
        streams.getInputStreamMonitor().append(this.fCurrentInput, submitType, this.fCurrentPrompt.meta & 1);
        streams.getInputStreamMonitor().append(this.workspaceData.getLineSeparator(), submitType, 1);
    }

    protected abstract void doSubmitL(ProgressMonitor var1) throws StatusException;

    protected StatusException cancelTask() {
        return new StatusException((Status)new CancelStatus("org.eclipse.statet.nico.core", Messages.ToolRunnable_error_RuntimeError_message, null));
    }

    protected abstract void doQuitL(ProgressMonitor var1) throws StatusException;

    public static abstract class ConsoleCommandRunnable
    implements ConsoleRunnable {
        public static final String TYPE_ID = "common/console/input";
        protected final String fText;
        protected String fLabel;
        protected final SubmitType fType;

        protected ConsoleCommandRunnable(String text, SubmitType type) {
            assert (text != null);
            assert (type != null);
            this.fText = text;
            this.fType = type;
        }

        public String getTypeId() {
            return TYPE_ID;
        }

        @Override
        public SubmitType getSubmitType() {
            return this.fType;
        }

        public String getCommand() {
            return this.fText;
        }

        public String getLabel() {
            if (this.fLabel == null) {
                this.fLabel = this.fText.trim();
            }
            return this.fLabel;
        }

        public boolean changed(int event, Tool process) {
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            ((ConsoleService)service).submitToConsole(this.fText, m);
        }
    }

    protected abstract class ControllerSystemRunnable
    implements SystemRunnable {
        private final String fTypeId;
        private final String fLabel;

        public ControllerSystemRunnable(String typeId, String label) {
            this.fTypeId = typeId;
            this.fLabel = label;
        }

        public String getTypeId() {
            return this.fTypeId;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public boolean canRunIn(Tool tool) {
            return tool == ToolController.this.getTool();
        }

        public boolean changed(int event, Tool tool) {
            return event != 289;
        }
    }

    public static interface IToolStatusListener {
        public void controllerStatusChanged(ToolStatus var1, ToolStatus var2, List<DebugEvent> var3);
    }

    protected class QuitRunnable
    extends SuspendResumeRunnable {
        public QuitRunnable() {
            super(ToolController.QUIT_TYPE_ID, "Quit", 32);
        }

        @Override
        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            block3: {
                super.run(service, m);
                if (!ToolController.this.isTerminated) {
                    try {
                        ToolController.this.briefAboutToChange();
                        ((ToolController)service).doQuitL(m);
                    }
                    catch (StatusException e) {
                        if (ToolController.this.isTerminated) break block3;
                        ToolController.this.handleStatus((Status)new ErrorStatus("org.eclipse.statet.nico.core", "An error occured when running quit command.", (Throwable)e), m);
                    }
                }
            }
        }

        @Override
        protected void doExec(ProgressMonitor m) throws StatusException {
        }
    }

    protected static class RunnableData {
        private final ToolRunnable runnable;
        private final SubmitType submitType;
        private final Queue.Section queueSection;

        public RunnableData(ToolRunnable runnable, SubmitType submitType, Queue.Section queueSection) {
            this.runnable = runnable;
            this.submitType = submitType;
            this.queueSection = queueSection;
        }
    }

    protected class StartRunnable
    implements ConsoleRunnable {
        public String getTypeId() {
            return ToolController.START_TYPE_ID;
        }

        public boolean canRunIn(Tool tool) {
            return tool == ToolController.this.getTool();
        }

        @Override
        public SubmitType getSubmitType() {
            return SubmitType.CONSOLE;
        }

        public String getLabel() {
            return Messages.ToolController_CommonStartTask_label;
        }

        public boolean changed(int event, Tool process) {
            return (event & 0xFF0) != 288;
        }

        public void run(ToolService s, ProgressMonitor m) throws StatusException {
        }
    }

    protected abstract class SuspendResumeRunnable
    extends ControllerSystemRunnable
    implements ConsoleRunnable {
        private int detail;

        public SuspendResumeRunnable(String id, String label, int detail) {
            super(id, label);
            this.detail = detail;
        }

        @Override
        public SubmitType getSubmitType() {
            return SubmitType.TOOLS;
        }

        protected void setDetail(int detail) {
            this.detail = detail;
        }

        @Override
        public boolean changed(int event, Tool process) {
            switch (event) {
                case 289: {
                    return false;
                }
                case 288: 
                case 290: {
                    if (ToolController.this.suspendExitRunnable != this) break;
                    ToolController.this.suspendExitRunnable = null;
                    break;
                }
            }
            return true;
        }

        public void run(ToolService adapter, ProgressMonitor m) throws StatusException {
            ToolController.this.suspendExitRunnable = this;
            ToolController.this.setSuspended(ToolController.this.suspendedLowerLevel, 0, null);
        }

        protected boolean canExec(ProgressMonitor m) throws StatusException {
            return true;
        }

        protected abstract void doExec(ProgressMonitor var1) throws StatusException;

        protected void submitToConsole(String print, String send, ProgressMonitor m) throws StatusException {
            ToolController.this.currentSubmitType = ToolController.this.getSubmitTypeL(this);
            try {
                ToolController.this.fCurrentInput = print;
                ToolController.this.doBeforeSubmitL();
            }
            finally {
                ToolController.this.currentSubmitType = ToolController.this.currentRunnable.submitType;
            }
            if (send != null) {
                ToolController.this.fCurrentInput = send;
                ToolController.this.doSubmitL(m);
            }
        }

        static /* synthetic */ int access$0(SuspendResumeRunnable suspendResumeRunnable) {
            return suspendResumeRunnable.detail;
        }
    }

    private class SuspendedInsertRunnable
    extends ControllerSystemRunnable
    implements SystemRunnable {
        private final int level;

        public SuspendedInsertRunnable(int level) {
            super(ToolController.SUSPENDED_INSERT_TYPE_ID, "Suspended [" + level + "]");
            this.level = level;
        }

        @Override
        public boolean changed(int event, Tool process) {
            switch (event) {
                case 288: 
                case 289: {
                    return false;
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
        }
    }

    private class SuspendedUpdateRunnable
    extends ControllerSystemRunnable
    implements SystemRunnable {
        public SuspendedUpdateRunnable() {
            super(ToolController.SUSPENDED_INSERT_TYPE_ID, "Update Debug Context");
        }

        @Override
        public boolean changed(int event, Tool tool) {
            return event != 289;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            ImList runnables = ToolController.this.suspendUpdateRunnables.toList();
            for (SystemRunnable runnable : runnables) {
                try {
                    runnable.run(service, m);
                }
                catch (StatusException e) {
                    Status status = e.getStatus();
                    if (status == null || status.getSeverity() != 8 && status.getSeverity() > 1) {
                        NicoCorePlugin.logError(-1, NLS.bind((String)"An error occurred when running suspend task ''{0}''.", (Object)runnable.getLabel()), e);
                    }
                    if (!ToolController.this.isTerminated()) continue;
                    return;
                }
            }
        }
    }
}

