/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.core.util.AbstractFragmentDocument;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.impl.WorkingBuffer;

public abstract class GenericConsoleSourceUnit
implements ISourceUnit {
    private final String id;
    private final ElementName name;
    private final AbstractFragmentDocument document;
    private int counter = 0;

    public GenericConsoleSourceUnit(String id, AbstractFragmentDocument document) {
        this.id = id;
        this.name = new ElementName(){

            public int getType() {
                return 17;
            }

            public String getDisplayName() {
                return GenericConsoleSourceUnit.this.id;
            }

            public String getSegmentName() {
                return GenericConsoleSourceUnit.this.id;
            }

            public ElementName getNextSegment() {
                return null;
            }
        };
        this.document = document;
    }

    public WorkingContext getWorkingContext() {
        return LTK.EDITOR_CONTEXT;
    }

    public ISourceUnit getUnderlyingUnit() {
        return null;
    }

    public boolean isSynchronized() {
        return true;
    }

    public int getElementType() {
        return 640;
    }

    public ElementName getElementName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean exists() {
        return this.counter > 0;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        return true;
    }

    public Object getResource() {
        return null;
    }

    protected final AbstractFragmentDocument getDocument() {
        return this.document;
    }

    public AbstractDocument getDocument(IProgressMonitor monitor) {
        return this.document;
    }

    public long getContentStamp(IProgressMonitor monitor) {
        return this.document.getModificationStamp();
    }

    public SourceContent getContent(IProgressMonitor monitor) {
        return WorkingBuffer.createContentFromDocument((IDocument)this.document);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        return null;
    }

    public IModelElement getModelParent() {
        return null;
    }

    public boolean hasModelChildren(IModelElement.Filter filter) {
        return false;
    }

    public List<? extends IModelElement> getModelChildren(IModelElement.Filter filter) {
        return Collections.EMPTY_LIST;
    }

    public final synchronized void connect(IProgressMonitor monitor) {
        ++this.counter;
    }

    public final synchronized void disconnect(IProgressMonitor monitor) {
        --this.counter;
    }

    public synchronized boolean isConnected() {
        return this.counter > 0;
    }

    public String toString() {
        return String.valueOf(this.getModelTypeId()) + '/' + this.getWorkingContext() + ": " + this.getId();
    }
}

