/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.HashMap;
import org.eclipse.statet.internal.r.core.sourcemodel.IRoxygenAnalyzeContext;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceElementByElementAccess;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.rsource.ast.DocuTag;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

public abstract class RoxygenTagType {
    public static final int INITIAL = 0;
    public static final int SCAN_MODE_FREETEXT = 0;
    public static final int SCAN_MODE_SYMBOL = 1;
    public static final int SCAN_MODE_RCODE = 2;
    public static final int FRAGMENT_ACTION_SELF_ACCESS = 1;
    public static final int FRAGMENT_ACTION_PARAM_ACCESS = 2;
    public static final int FRAGMENT_ACTION_SLOT_ACCESS = 3;
    public static final int FRAGMENT_ACTION_PACKAGE_IMPORT = 4;
    public static final HashMap<String, RoxygenTagType> TYPES = new HashMap();

    static {
        TYPES.put("param", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                if (previous == 0) {
                    return 257;
                }
                return 2304;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                RAstNode child;
                if (element == null || (element.getElementType() & 0xF00) != 1280) {
                    return;
                }
                int count = docuTag.getChildCount();
                if (count >= 1 && (child = docuTag.getChild(0)).getNodeType() == NodeType.SYMBOL) {
                    context.createArgAccess((RSourceElementByElementAccess.RMethod)element, child);
                }
            }
        });
        TYPES.put("slot", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                if (previous == 0) {
                    return 257;
                }
                return 2304;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                RAstNode child;
                if (element == null || (element.getElementType() & 0xF00) != 1024) {
                    return;
                }
                int count = docuTag.getChildCount();
                if (count >= 1 && (child = docuTag.getChild(0)).getNodeType() == NodeType.SYMBOL) {
                    context.createSlotAccess((RSourceElementByElementAccess.RClass)element, child);
                }
            }
        });
        TYPES.put("name", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                if (previous == 0) {
                    return 257;
                }
                return 2304;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                RAstNode child;
                if (element == null) {
                    return;
                }
                int count = docuTag.getChildCount();
                if (count >= 1 && (child = docuTag.getChild(0)).getNodeType() == NodeType.SYMBOL) {
                    context.createSelfAccess(element, child);
                }
            }
        });
        TYPES.put("aliases", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                return 257;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                if (element == null) {
                    return;
                }
                int count = docuTag.getChildCount();
                int i = 0;
                while (i < count) {
                    RAstNode child = docuTag.getChild(i);
                    if (child.getNodeType() == NodeType.SYMBOL) {
                        context.createSelfAccess(element, child);
                    }
                    ++i;
                }
            }
        });
        TYPES.put("export", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                return 257;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                if (element == null) {
                    return;
                }
                int count = docuTag.getChildCount();
                int i = 0;
                while (i < count) {
                    RAstNode child = docuTag.getChild(i);
                    if (child.getNodeType() == NodeType.SYMBOL) {
                        context.createSelfAccess(element, child);
                    }
                    ++i;
                }
            }
        });
        TYPES.put("exportClass", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                return 257;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                if (element == null || (element.getElementType() & 0xF00) != 1024 && (element.getElementType() & 0xF00) != 1536) {
                    return;
                }
                int count = docuTag.getChildCount();
                int i = 0;
                while (i < count) {
                    RAstNode child = docuTag.getChild(i);
                    if (child.getNodeType() == NodeType.SYMBOL) {
                        context.createSelfAccess(element, child);
                    }
                    ++i;
                }
            }
        });
        TYPES.put("exportMethod", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                return 257;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                if (element == null || (element.getElementType() & 0xF00) != 1280 && (element.getElementType() & 0xF00) != 1536) {
                    return;
                }
                int count = docuTag.getChildCount();
                int i = 0;
                while (i < count) {
                    RAstNode child = docuTag.getChild(i);
                    if (child.getNodeType() == NodeType.SYMBOL) {
                        context.createSelfAccess(element, child);
                    }
                    ++i;
                }
            }
        });
        TYPES.put("import", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                return 257;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                int count = docuTag.getChildCount();
                int i = 0;
                while (i < count) {
                    RAstNode child = docuTag.getChild(i);
                    if (child.getNodeType() == NodeType.SYMBOL) {
                        context.createNamespaceImportAccess(child);
                    }
                    ++i;
                }
            }
        });
        TYPES.put("importFrom", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                return 257;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                int count = docuTag.getChildCount();
                if (count >= 1) {
                    IRFrameInSource frame;
                    RAstNode child = docuTag.getChild(0);
                    if (child.getNodeType() == NodeType.SYMBOL) {
                        context.createNamespaceImportAccess(child);
                    }
                    String name = child.getText();
                    if (count >= 2 && name != null && (frame = context.getNamespaceFrame(name)) != null) {
                        int i = 1;
                        while (i < count) {
                            child = docuTag.getChild(i);
                            if (child.getNodeType() == NodeType.SYMBOL) {
                                context.createNamespaceObjectImportAccess(frame, child);
                            }
                            ++i;
                        }
                    }
                }
            }
        });
        TYPES.put("importClassesFrom", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                return 257;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                RAstNode child;
                int count = docuTag.getChildCount();
                if (count >= 1 && (child = docuTag.getChild(0)).getNodeType() == NodeType.SYMBOL) {
                    context.createNamespaceImportAccess(child);
                }
            }
        });
        TYPES.put("importMethodsFrom", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                return 257;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                RAstNode child;
                int count = docuTag.getChildCount();
                if (count >= 1 && (child = docuTag.getChild(0)).getNodeType() == NodeType.SYMBOL) {
                    context.createNamespaceImportAccess(child);
                }
            }
        });
        TYPES.put("examples", new RoxygenTagType(){

            @Override
            public int getNextScanMode(int previous) {
                return 258;
            }

            @Override
            public void analyze(IRoxygenAnalyzeContext context, DocuTag docuTag, IRLangSourceElement element) {
                RAstNode child;
                int count = docuTag.getChildCount();
                if (count >= 1 && (child = docuTag.getChild(0)).getNodeType() == NodeType.SOURCELINES) {
                    context.createRSourceRegion(child);
                }
            }
        });
    }

    public abstract int getNextScanMode(int var1);

    public abstract void analyze(IRoxygenAnalyzeContext var1, DocuTag var2, IRLangSourceElement var3);
}

