/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.LaunchShortcutUtil;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;

public class SubmitEntireCommandHandler
extends AbstractHandler {
    private final boolean fGotoConsole;

    public SubmitEntireCommandHandler() {
        this(false);
    }

    protected SubmitEntireCommandHandler(boolean gotoConsole) {
        this.fGotoConsole = gotoConsole;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        final AtomicReference success = new AtomicReference();
        try {
            if (workbenchPart instanceof IEditorPart) {
                final Data data = new Data();
                data.editor = (ISourceEditor)workbenchPart.getAdapter(ISourceEditor.class);
                if (data.editor != null) {
                    data.selection = (ITextSelection)data.editor.getViewer().getSelection();
                    if (data.selection != null) {
                        ((IProgressService)workbenchPart.getSite().getService(IProgressService.class)).busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                try {
                                    success.set(SubmitEntireCommandHandler.this.doLaunch(data, monitor));
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                    }
                }
            }
        }
        catch (InvocationTargetException e) {
            LaunchShortcutUtil.handleRLaunchException(e.getTargetException(), this.getErrorMessage(), event);
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        IStatus status = (IStatus)success.get();
        if (status != null && status.getSeverity() != 0 && status.getSeverity() != 8) {
            LTKWorkbenchUIUtil.indicateStatus((IStatus)status, (ExecutionEvent)event);
        }
        return null;
    }

    protected String getErrorMessage() {
        return RLaunchingMessages.RCommandLaunch_error_message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus doLaunch(Data data, IProgressMonitor monitor) throws CoreException {
        ISourceUnit su = data.editor.getSourceUnit();
        if (!(su instanceof IRSourceUnit)) {
            return LaunchShortcutUtil.createUnsupported();
        }
        data.su = (IRSourceUnit)su;
        assert (data.su.getDocument(monitor) == data.editor.getViewer().getDocument());
        data.document = data.su.getDocument(monitor);
        monitor.subTask(RLaunchingMessages.RCodeLaunch_UpdateStructure_task);
        AbstractDocument abstractDocument = data.document instanceof ISynchronizable ? ((ISynchronizable)data.document).getLockObject() : data.document;
        synchronized (abstractDocument) {
            data.model = (IRModelInfo)data.su.getModelInfo("R", 2, monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            data.ast = data.model != null ? data.model.getAst() : data.su.getAstInfo(null, true, monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (data.ast == null) {
                return LaunchShortcutUtil.createUnsupported();
            }
            IStatus status = this.getRegions(data);
            if (!status.isOK() || data.regions == null) {
                return status;
            }
        }
        monitor.subTask(RLaunchingMessages.RCodeLaunch_SubmitCode_task);
        if (RCodeLaunching.runRCodeDirect(data.regions, this.fGotoConsole)) {
            this.postLaunch(data);
        }
        return Status.OK_STATUS;
    }

    protected IStatus getRegions(final Data data) throws CoreException {
        RAstNode[] nodes = RAst.findDeepestCommands((AstNode)data.ast.getRoot(), (int)data.selection.getOffset(), (int)(data.selection.getOffset() + data.selection.getLength()));
        if (nodes == null || nodes.length == 0) {
            final RAstNode next = RAst.findNextCommands((AstNode)data.ast.getRoot(), (int)(data.selection.getOffset() + data.selection.getLength()));
            if (next != null) {
                UIAccess.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        data.editor.selectAndReveal(next.getStartOffset(), 0);
                    }
                });
            }
            return Status.OK_STATUS;
        }
        try {
            data.nodes = nodes;
            ArrayList<RCodeLaunching.SourceRegion> list = new ArrayList<RCodeLaunching.SourceRegion>(nodes.length);
            int i = 0;
            while (i < nodes.length) {
                if (RAst.hasErrors((RAstNode)nodes[i])) {
                    return new Status(4, "org.eclipse.statet.r.ui", RLaunchingMessages.SubmitCode_info_SyntaxError_message);
                }
                RCodeLaunching.SourceRegion region = new RCodeLaunching.SourceRegion(data.su, data.document);
                region.setBegin(this.checkStart((IDocument)data.document, nodes[i].getStartOffset()));
                region.setEnd(nodes[i].getEndOffset());
                region.setCode(data.document.get(region.getOffset(), region.getLength()));
                region.setNode(nodes[i]);
                list.add(region);
                ++i;
            }
            data.regions = list;
            return Status.OK_STATUS;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, RLaunchingMessages.SubmitCode_error_WhenAnalyzingAndCollecting_message, (Throwable)e));
        }
    }

    protected int checkStart(IDocument doc, int offset) throws BadLocationException {
        int startLine = doc.getLineOfOffset(offset);
        int lineOffset = doc.getLineOffset(startLine);
        if (offset == lineOffset) {
            return offset;
        }
        String s = doc.get(lineOffset, offset - lineOffset);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++i;
        }
        return lineOffset;
    }

    protected void postLaunch(Data data) {
    }

    protected static class Data {
        ISourceEditor editor;
        ITextSelection selection;
        AbstractDocument document;
        IRModelInfo model;
        AstInfo ast;
        RAstNode[] nodes;
        IRSourceUnit su;
        List<RCodeLaunching.SourceRegion> regions;

        protected Data() {
        }
    }
}

