/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.ui.pkgmanager.RPkgManagerDialog;
import org.eclipse.statet.internal.r.ui.pkgmanager.RRepoLabelProvider;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.ISelectedRepos;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.r.core.pkgmanager.SelectedRepos;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;

public class RepoTab
extends Composite {
    private final RPkgManagerDialog dialog;
    private final TabItem tab;
    private List<RRepo> availableRepos;
    private IObservableSet<RRepo> selectedRepos;
    private IObservableValue<RRepo> selectedCran;
    private String biocVersion;
    private IObservableValue<RRepo> selectedBioc;
    private CheckboxTableViewer repoTable;
    private TableViewer CranTable;
    private Label biocLabel;
    private TableViewer biocTable;

    RepoTab(RPkgManagerDialog dialog, TabItem tab, Composite parent) {
        super(parent, 0);
        this.dialog = dialog;
        this.tab = tab;
        this.setLayout((Layout)LayoutUtils.newTabGrid((int)2, (boolean)true));
        this.createContent(this);
    }

    private void createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText("R&epositories:");
        ViewerUtils.CheckboxTableComposite table = new ViewerUtils.CheckboxTableComposite(composite, 67618);
        this.repoTable = table.viewer;
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((Table)table.table, (int)15);
        gd.widthHint = LayoutUtils.hintWidth((Table)table.table, (int)40);
        table.setLayoutData((Object)gd);
        table.addColumn("Repository", 16384, (ColumnLayoutData)new ColumnWeightData(100, false));
        table.viewer.setLabelProvider((IBaseLabelProvider)new RRepoLabelProvider());
        table.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText("CR&AN Mirror:");
        this.CranTable = this.createMirrorTable(composite);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText("&Bioconductor Mirror:");
        this.biocLabel = label;
        this.biocTable = this.createMirrorTable(composite);
        Link link = new Link(parent, 0);
        link.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        link.setText("Custom repositories and mirrors can be configured in the <a href=\"org.eclipse.statet.r.preferencePages.RRepositories\">preferences</a>.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepoTab.this.dialog.openPrefPage(e.text);
            }
        });
    }

    private TableViewer createMirrorTable(Composite parent) {
        ViewerUtils.TableComposite table = new ViewerUtils.TableComposite(parent, 67586);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((Table)table.table, (int)5);
        gd.widthHint = LayoutUtils.hintWidth((Table)table.table, (int)40);
        table.setLayoutData((Object)gd);
        table.addColumn("Mirror", 16384, (ColumnLayoutData)new ColumnWeightData(100, false));
        table.viewer.setLabelProvider((IBaseLabelProvider)new RRepoLabelProvider());
        table.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return table.viewer;
    }

    ISelectedRepos createRepoSettings() {
        ArrayList<RRepo> list = new ArrayList<RRepo>(this.selectedRepos.size());
        for (RRepo repo : this.availableRepos) {
            if (!this.selectedRepos.contains((Object)repo)) continue;
            list.add(repo);
        }
        return new SelectedRepos(list, (RRepo)this.selectedCran.getValue(), this.biocVersion, (RRepo)this.selectedBioc.getValue());
    }

    TabItem getTab() {
        return this.tab;
    }

    List<RRepo> getAvailableRepos() {
        return this.availableRepos;
    }

    void addBindings(DataBindingSupport db) {
        this.selectedRepos = new WritableSet(db.getRealm(), Collections.emptySet(), RRepo.class);
        this.selectedCran = new WritableValue(db.getRealm(), null, RRepo.class);
        this.selectedBioc = new WritableValue(db.getRealm(), null, RRepo.class);
        db.getContext().bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)this.repoTable, RRepo.class), this.selectedRepos);
        db.getContext().bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.CranTable), this.selectedCran);
        db.getContext().bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.biocTable), this.selectedBioc);
        this.selectedRepos.addChangeListener((IChangeListener)this.dialog);
        this.selectedCran.addChangeListener((IChangeListener)this.dialog);
        this.selectedBioc.addChangeListener((IChangeListener)this.dialog);
    }

    void init() {
        this.repoTable.getTable().setSelection(0);
    }

    void updateSettings(IRPkgManager.Ext pkgManager) {
        this.availableRepos = pkgManager.getAvailableRepos();
        ISelectedRepos repoSettings = pkgManager.getSelectedRepos();
        this.repoTable.setInput(this.availableRepos);
        if (this.selectedRepos.isEmpty()) {
            this.selectedRepos.addAll(repoSettings.getRepos());
        } else {
            this.selectedRepos.retainAll(this.availableRepos);
        }
        this.CranTable.setInput((Object)pkgManager.getAvailableCRANMirrors());
        this.selectedCran.setValue((Object)repoSettings.getCRANMirror());
        this.biocVersion = repoSettings.getBioCVersion();
        this.biocLabel.setText("&Bioconductor  (" + this.biocVersion + ") Mirror:");
        this.biocTable.setInput((Object)pkgManager.getAvailableBioCMirrors());
        this.selectedBioc.setValue((Object)repoSettings.getBioCMirror());
    }
}

