/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.wikitext.r.core.source;

import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.EmbeddingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.WikitextWeavePartitionNodeScanner;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.WikidocPartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNodeType;
import org.eclipse.statet.r.core.source.RPartitionNodeType;
import org.eclipse.statet.redocs.r.core.source.AbstractRChunkPartitionNodeScanner;
import org.eclipse.statet.redocs.wikitext.r.core.source.IRweaveMarkupLanguage;

public class WikidocRweavePartitionNodeScanner
extends WikidocPartitionNodeScanner {
    private AbstractRChunkPartitionNodeScanner rScanner;

    public WikidocRweavePartitionNodeScanner(IMarkupLanguage markupLanguage) {
        super(markupLanguage);
    }

    public WikidocRweavePartitionNodeScanner(IMarkupLanguage markupLanguage, int markupLanguageMode) {
        super(markupLanguage, markupLanguageMode);
    }

    protected void init() {
        IMarkupLanguage markupLanguage = this.getMarkupLanguage();
        if (!(markupLanguage instanceof IRweaveMarkupLanguage)) {
            throw new IllegalArgumentException("markupLanguage");
        }
        IRweaveMarkupLanguage rweaveLanguage = (IRweaveMarkupLanguage)markupLanguage;
        this.rScanner = rweaveLanguage.getRChunkPartitionScanner();
        ITreePartitionNode beginNode = this.getScan().getBeginNode();
        if (beginNode.getType() instanceof RPartitionNodeType) assert (false);
        super.init();
    }

    protected void beginEmbeddingBlock(DocumentBuilder.BlockType type, WikitextWeavePartitionNodeScanner.Embedding embedding) {
        if (type == DocumentBuilder.BlockType.CODE && embedding.getForeignType() == "R") {
            this.addNode((ITreePartitionNodeType)AbstractRChunkPartitionNodeScanner.R_CHUNK_BASE_TYPE, this.getEventBeginOffset());
            embedding.init(this.getNode());
            return;
        }
        super.beginEmbeddingBlock(type, embedding);
    }

    protected void endEmbeddingBlock(ITreePartitionNodeType type, WikitextWeavePartitionNodeScanner.Embedding embedding) {
        if (type instanceof RPartitionNodeType) {
            embedding.executeForeignScanner((ITreePartitionNodeScanner)this.rScanner);
            this.exitNode(this.getEventEndOffset(), 0);
            return;
        }
        super.endEmbeddingBlock(type, embedding);
    }

    protected void beginEmbeddingSpan(DocumentBuilder.SpanType type, WikitextWeavePartitionNodeScanner.Embedding embedding) {
        if (type == DocumentBuilder.SpanType.CODE && embedding.getForeignType() == "R") {
            EmbeddingAttributes attributes = embedding.getAttributes();
            this.addNode((ITreePartitionNodeType)this.rScanner.getDefaultRootType(), this.getStartOffset() + attributes.getContentRegion().getStartOffset());
            embedding.init(this.getNode());
            return;
        }
        super.beginEmbeddingSpan(type, embedding);
    }

    protected void endEmbeddingSpan(ITreePartitionNodeType type, WikitextWeavePartitionNodeScanner.Embedding embedding) {
        if (type instanceof RPartitionNodeType) {
            if (embedding.getContentEndOffset() < 0) {
                embedding.setContentEndOffset(this.getEventEndOffset() - 1);
            }
            this.exitNode(embedding.getContentEndOffset(), 0);
            if (embedding.getNode().getLength() > 0) {
                embedding.executeForeignScanner((ITreePartitionNodeScanner)this.rScanner);
            }
            return;
        }
        super.endEmbeddingSpan(type, embedding);
    }
}

