/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.statet.ecommons.databinding.DecimalValidator;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.prefs.BackingStoreException;

public class RGraphicsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Encoding[] SYMBOL_ENCODINGS = new Encoding[]{new Encoding("Unicode", "Unicode"), new Encoding("Adobe Symbol", "AdobeSymbol")};
    private static final Encoding SYMBOL_ENCODING_DEFAULT = SYMBOL_ENCODINGS[1];
    private DataBindingContext dbc;
    private FontPref serifPref;
    private FontPref sansPref;
    private FontPref monoPref;
    private FontPref symbolFontPref;
    private FontPref[] fontPrefs;
    private Button symbolUseControl;
    private ComboViewer symbolEncodingControl;
    private Control[] symbolChildControls;
    private final int size = 10;
    private Button customDpiControl;
    private Composite customDpiComposite;
    private Text customHDpiControl;
    private Text customVDpiControl;
    private boolean customEnabled;
    private IObservableValue<Double> customHDpiVisibleValue;
    private IObservableValue<Double> customVDpiVisibleValue;
    private double customHDpiUserValue;
    private double customVDpiUserValue;

    public static double[] parseDPI(String prefValue) {
        String[] strings;
        if (prefValue != null && (strings = prefValue.split(",")).length == 2) {
            try {
                return new double[]{Double.parseDouble(strings[0]), Double.parseDouble(strings[1])};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void init(IWorkbench workbench) {
        this.serifPref = new FontPref("serif.name");
        this.sansPref = new FontPref("sans.name");
        this.monoPref = new FontPref("mono.name");
        this.symbolFontPref = new FontPref("symbol.name");
        this.fontPrefs = new FontPref[]{this.serifPref, this.sansPref, this.monoPref, this.symbolFontPref};
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.statet.rj.eclient.graphics/fonts");
        FontPref[] fontPrefArray = this.fontPrefs;
        int n = this.fontPrefs.length;
        int n2 = 0;
        while (n2 < n) {
            FontPref pref = fontPrefArray[n2];
            pref.defaultName = node != null ? node.get(pref.prefKey, "") : "";
            ++n2;
        }
    }

    protected Control createContents(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        Group displayGroup = this.createDisplayGroup(pageComposite);
        displayGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Group fontGroup = this.createFontGroup(pageComposite);
        fontGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.initBindings();
        this.loadDisplayOptions();
        this.loadFontOptions();
        this.applyDialogFont(pageComposite);
        return pageComposite;
    }

    protected Group createDisplayGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Display:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        this.customDpiControl = new Button((Composite)group, 32);
        this.customDpiControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.customDpiControl.setText("Use custom DPI (instead of system setting):");
        this.customDpiComposite = new Composite((Composite)group, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = LayoutUtils.defaultIndent();
        this.customDpiComposite.setLayoutData((Object)gd);
        this.customDpiComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(this.customDpiComposite, 16384);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("&Horizontal (x):");
        Text text = new Text(this.customDpiComposite, 133120);
        GridData gd2 = new GridData(16384, 0x1000000, false, false);
        gd2.widthHint = LayoutUtils.hintWidth((Text)text, (int)8);
        text.setLayoutData((Object)gd2);
        this.customHDpiControl = text;
        label = new Label(this.customDpiComposite, 16384);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("&Vertical (y):");
        text = new Text(this.customDpiComposite, 133120);
        gd2 = new GridData(16384, 0x1000000, false, false);
        gd2.widthHint = LayoutUtils.hintWidth((Text)text, (int)8);
        text.setLayoutData((Object)gd2);
        this.customVDpiControl = text;
        this.customDpiControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RGraphicsPreferencePage.this.updateDisplayGroup();
            }
        });
        return group;
    }

    private void updateDisplayGroup() {
        double vvalue;
        double hvalue;
        this.customEnabled = this.customDpiControl.getSelection();
        DialogUtils.setEnabled((Control)this.customDpiComposite, null, (boolean)this.customEnabled);
        if (!this.customEnabled || this.customHDpiUserValue <= 0.0 || this.customVDpiUserValue <= 0.0) {
            Point dpi = Display.getDefault().getDPI();
            hvalue = dpi.x;
            vvalue = dpi.y;
            if (this.customEnabled) {
                this.customHDpiUserValue = hvalue;
                this.customVDpiUserValue = vvalue;
            }
        } else {
            hvalue = this.customHDpiUserValue;
            vvalue = this.customVDpiUserValue;
        }
        this.customHDpiVisibleValue.setValue((Object)hvalue);
        this.customVDpiVisibleValue.setValue((Object)vvalue);
    }

    protected Group createFontGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Fonts:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)3));
        this.addFont(group, this.serifPref, "Default &Serif Font ('serif'):");
        this.addFont(group, this.sansPref, "Default S&ansserif Font ('sans'):");
        this.addFont(group, this.monoPref, "Default &Monospace Font ('mono'):");
        LayoutUtils.addSmallFiller((Composite)group, (boolean)false);
        this.symbolUseControl = new Button((Composite)group, 32);
        this.symbolUseControl.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.symbolUseControl.setText("Use special S&ymbol Font");
        ArrayList<Control> symbolControls = new ArrayList<Control>();
        this.addFont(group, this.symbolFontPref, "Symbol &Font:", LayoutUtils.defaultIndent(), symbolControls);
        Label label = new Label((Composite)group, 0);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalIndent = LayoutUtils.defaultIndent();
        label.setLayoutData((Object)gd);
        label.setText("Encoding:");
        symbolControls.add((Control)label);
        this.symbolEncodingControl = new ComboViewer((Composite)group, 12);
        GridData gd2 = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd2.widthHint = LayoutUtils.hintWidth((Combo)this.symbolEncodingControl.getCombo(), (int)15);
        this.symbolEncodingControl.getControl().setLayoutData((Object)gd2);
        this.symbolEncodingControl.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.symbolEncodingControl.setInput((Object)SYMBOL_ENCODINGS);
        symbolControls.add(this.symbolEncodingControl.getControl());
        this.symbolChildControls = symbolControls.toArray(new Control[symbolControls.size()]);
        this.symbolUseControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RGraphicsPreferencePage.this.updateSymbolControls();
            }
        });
        return group;
    }

    private void addFont(Group group, FontPref pref, String text) {
        this.addFont(group, pref, text, 0, null);
    }

    private void addFont(Group group, final FontPref pref, String text, int indent, List<Control> controls) {
        Label label = new Label((Composite)group, 0);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalIndent = indent;
        label.setLayoutData((Object)gd);
        label.setText(text);
        pref.valueLabel = new Label((Composite)group, 2048);
        pref.valueLabel.setBackground(label.getDisplay().getSystemColor(1));
        pref.valueLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Button button = new Button((Composite)group, 8);
        button.setText("Edit...");
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog dialog = new FontDialog(button.getShell(), 0);
                dialog.setFontList(pref.currentFont != null ? pref.currentFont.getFontData() : null);
                FontData result = dialog.open();
                if (result != null) {
                    RGraphicsPreferencePage.this.set(pref, result.getName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (controls != null) {
            controls.add((Control)label);
            controls.add((Control)pref.valueLabel);
            controls.add((Control)button);
        }
    }

    protected void initBindings() {
        Realm realm = Realm.getDefault();
        this.dbc = new DataBindingContext(realm);
        this.addBindings(this.dbc, realm);
        AggregateValidationStatus validationStatus = new AggregateValidationStatus(this.dbc, 2);
        validationStatus.addValueChangeListener(event -> {
            IStatus currentStatus = (IStatus)event.diff.getNewValue();
            this.updateStatus(currentStatus);
        });
    }

    protected void addBindings(DataBindingContext dbc, Realm realm) {
        this.customHDpiVisibleValue = new WritableValue(realm, (Object)96.0, Double.class);
        this.customVDpiVisibleValue = new WritableValue(realm, (Object)96.0, Double.class);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.customHDpiControl), this.customHDpiVisibleValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new DecimalValidator(10.0, 10000.0, "The value for Horizontal (x) DPI is invalid (10-10000).")), null);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.customVDpiControl), this.customVDpiVisibleValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new DecimalValidator(10.0, 10000.0, "The value for Vertical (x) DPI is invalid (10-10000).")), null);
        this.customHDpiVisibleValue.addValueChangeListener(event -> {
            if (this.customEnabled) {
                this.customHDpiUserValue = (Double)this.customHDpiVisibleValue.getValue();
            }
        });
        this.customVDpiVisibleValue.addValueChangeListener(event -> {
            if (this.customEnabled) {
                this.customVDpiUserValue = (Double)this.customVDpiVisibleValue.getValue();
            }
        });
    }

    protected void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusInfo.applyToStatusLine((DialogPage)this, (IStatus)status);
    }

    protected void setCustomDpi(String prefValue) {
        double[] dpi = RGraphicsPreferencePage.parseDPI(prefValue);
        if (dpi != null) {
            this.customHDpiUserValue = dpi[0];
            this.customVDpiUserValue = dpi[1];
            this.customDpiControl.setSelection(true);
        } else {
            this.customDpiControl.setSelection(false);
        }
        this.updateDisplayGroup();
    }

    protected void updateSymbolControls() {
        DialogUtils.setEnabled((Control[])this.symbolChildControls, null, (boolean)this.symbolUseControl.getSelection());
    }

    protected void set(FontPref pref, String value) {
        Font font;
        if (value.equals(pref.currentName)) {
            return;
        }
        pref.valueLabel.setText("");
        try {
            font = new Font((Device)pref.valueLabel.getDisplay(), value, 10, 0);
            if (pref != this.symbolFontPref) {
                pref.valueLabel.setFont(font);
            }
            pref.valueLabel.setText(value);
        }
        catch (SWTError e) {
            font = JFaceResources.getDialogFont();
            pref.valueLabel.setFont(font);
            pref.valueLabel.setText(String.valueOf(value) + " (not available)");
        }
        if (pref.currentFont != null && !pref.currentFont.isDisposed()) {
            pref.currentFont.dispose();
        }
        pref.currentName = value;
        pref.currentFont = font;
    }

    protected void performDefaults() {
        this.setCustomDpi(null);
        this.symbolUseControl.setSelection(true);
        this.symbolEncodingControl.setSelection((ISelection)new StructuredSelection((Object)SYMBOL_ENCODING_DEFAULT));
        FontPref[] fontPrefArray = this.fontPrefs;
        int n = this.fontPrefs.length;
        int n2 = 0;
        while (n2 < n) {
            FontPref pref = fontPrefArray[n2];
            this.set(pref, pref.defaultName);
            ++n2;
        }
        this.updateSymbolControls();
        super.performDefaults();
    }

    protected void performApply() {
        this.saveDisplayOptions(true);
        this.saveFontOptions(true);
    }

    public boolean performOk() {
        this.saveDisplayOptions(false);
        this.saveFontOptions(false);
        return true;
    }

    protected IScopeContext getScope() {
        return InstanceScope.INSTANCE;
    }

    protected void loadDisplayOptions() {
        IEclipsePreferences node = this.getScope().getNode("org.eclipse.statet.rj.eclient.graphics/display");
        this.setCustomDpi(node.get("dpi.xy", null));
    }

    protected void saveDisplayOptions(boolean flush) {
        IEclipsePreferences node = this.getScope().getNode("org.eclipse.statet.rj.eclient.graphics/display");
        if (this.customEnabled) {
            node.put("dpi.xy", String.valueOf(Double.toString(this.customHDpiUserValue)) + "," + Double.toString(this.customVDpiUserValue));
        } else {
            node.remove("dpi.xy");
        }
        if (flush) {
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rj.eclient.graphics", -1, "An error occurred when storing R graphics display preferences.", (Throwable)e));
            }
        }
    }

    protected void loadFontOptions() {
        if (this.fontPrefs != null) {
            IEclipsePreferences node = this.getScope().getNode("org.eclipse.statet.rj.eclient.graphics/fonts");
            this.symbolUseControl.setSelection(node.getBoolean("symbol.use", true));
            String s = node.get("symbol.enc", null);
            this.symbolEncodingControl.setSelection((ISelection)new StructuredSelection((Object)(s != null ? new Encoding(null, s) : SYMBOL_ENCODING_DEFAULT)));
            FontPref[] fontPrefArray = this.fontPrefs;
            int n = this.fontPrefs.length;
            int n2 = 0;
            while (n2 < n) {
                FontPref pref = fontPrefArray[n2];
                String value = node.get(pref.prefKey, "");
                this.set(pref, value.length() > 0 ? value : pref.defaultName);
                ++n2;
            }
            this.updateSymbolControls();
        }
    }

    protected void saveFontOptions(boolean flush) {
        if (this.fontPrefs != null) {
            IEclipsePreferences node = this.getScope().getNode("org.eclipse.statet.rj.eclient.graphics/fonts");
            node.putBoolean("symbol.use", this.symbolUseControl.getSelection());
            IStructuredSelection selection = (IStructuredSelection)this.symbolEncodingControl.getSelection();
            if (selection.getFirstElement() instanceof Encoding && !SYMBOL_ENCODING_DEFAULT.equals(selection.getFirstElement())) {
                node.put("symbol.enc", ((Encoding)selection.getFirstElement()).prefValue);
            } else {
                node.remove("symbol.enc");
            }
            FontPref[] fontPrefArray = this.fontPrefs;
            int n = this.fontPrefs.length;
            int n2 = 0;
            while (n2 < n) {
                FontPref pref = fontPrefArray[n2];
                if (pref.currentName == null || pref.currentName.equals(pref.defaultName)) {
                    node.remove(pref.prefKey);
                } else {
                    node.put(pref.prefKey, pref.currentName);
                }
                ++n2;
            }
            this.updateSymbolControls();
            if (flush) {
                try {
                    node.flush();
                }
                catch (BackingStoreException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rj.eclient.graphics", -1, "An error occurred when storing R graphics font preferences.", (Throwable)e));
                }
            }
        }
    }

    public void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
        if (this.fontPrefs != null) {
            FontPref[] fontPrefArray = this.fontPrefs;
            int n = this.fontPrefs.length;
            int n2 = 0;
            while (n2 < n) {
                FontPref pref = fontPrefArray[n2];
                if (pref.currentFont != null && !pref.currentFont.isDisposed()) {
                    pref.currentFont.dispose();
                    pref.currentFont = null;
                }
                ++n2;
            }
        }
        super.dispose();
    }

    private static class Encoding {
        final String label;
        final String prefValue;

        public Encoding(String label, String prefValue) {
            this.label = label;
            this.prefValue = prefValue;
        }

        public int hashCode() {
            return this.prefValue.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Encoding && this.prefValue.equals(((Encoding)obj).prefValue);
        }

        public String toString() {
            return this.label.toString();
        }
    }

    private static class FontPref {
        final String prefKey;
        String defaultName;
        String currentName;
        Font currentFont;
        Label valueLabel;

        public FontPref(String key) {
            this.prefKey = key;
        }

        public int hashCode() {
            return this.prefKey.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof FontPref && this.prefKey.equals(((FontPref)obj).prefKey);
        }
    }
}

