/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.eclipse.statet.internal.rj.servi.APool2;
import org.eclipse.statet.internal.rj.servi.APool2NodeHandler;
import org.eclipse.statet.internal.rj.servi.Messages;
import org.eclipse.statet.internal.rj.servi.NodeFactory;
import org.eclipse.statet.internal.rj.servi.PoolListener;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.CopyOnWriteList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class APool2NodeFactory
implements PooledObjectFactory<APool2NodeHandler> {
    private APool2 pool;
    private final NodeFactory nodeFactory;
    private final CopyOnWriteList<APool2NodeHandler> nodes = new CopyOnWriteList();
    private final CopyOnWriteIdentityListSet<PoolListener> poolListeners;
    private int statMaxTotal;
    private int statMaxAllocated;
    private int maxUsageCount;
    private @Nullable RMIClientSocketFactory sslClientSocketFactory;
    private @Nullable RMIServerSocketFactory sslServerSocketFactory;
    private final ThreadLocal<String> activateArguments = new ThreadLocal();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public APool2NodeFactory(NodeFactory factory, CopyOnWriteIdentityListSet<PoolListener> poolListeners) {
        this.nodeFactory = factory;
        this.poolListeners = poolListeners;
    }

    void setPool(APool2 pool) {
        this.pool = pool;
    }

    void dispose() {
        this.executor.shutdown();
    }

    public void setMaxUsageCount(int count) {
        this.maxUsageCount = count;
    }

    public int getNumAll() {
        return this.nodes.size();
    }

    public ImList<APool2NodeHandler> getAllObjects() {
        return this.nodes.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledObject<APool2NodeHandler> makeObject() throws Exception {
        APool2NodeHandler poolObj = new APool2NodeHandler(this.pool);
        CopyOnWriteList<APool2NodeHandler> copyOnWriteList = this.nodes;
        synchronized (copyOnWriteList) {
            this.nodes.add((Object)poolObj);
            int total = this.nodes.size();
            if (total > this.statMaxTotal) {
                this.statMaxTotal = total;
            }
        }
        boolean ok = false;
        try {
            for (PoolListener listener : this.poolListeners.toList()) {
                try {
                    listener.initializing(poolObj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.nodeFactory.createNode(poolObj);
            RMIClientSocketFactory clientSocketFactory = null;
            RMIServerSocketFactory serverSocketFactory = null;
            if (poolObj.address.isSsl()) {
                APool2NodeFactory e = this;
                synchronized (e) {
                    if (this.sslClientSocketFactory == null) {
                        this.sslClientSocketFactory = new SslRMIClientSocketFactory();
                        this.sslServerSocketFactory = new SslRMIServerSocketFactory(null, null, true);
                    }
                    clientSocketFactory = this.sslClientSocketFactory;
                    serverSocketFactory = this.sslServerSocketFactory;
                }
            }
            poolObj.thisRemote = UnicastRemoteObject.exportObject(poolObj, 0, clientSocketFactory, serverSocketFactory);
            for (PoolListener listener : this.poolListeners.toList()) {
                try {
                    listener.initialized(poolObj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ok = true;
            PooledObject<APool2NodeHandler> pooledObject = poolObj.getPooledObject();
            return pooledObject;
        }
        finally {
            if (!ok) {
                this.nodes.remove((Object)poolObj);
            }
        }
    }

    public void registerArgs(String client) {
        this.activateArguments.set(client);
    }

    public void clearArgs() {
        this.activateArguments.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateObject(PooledObject<APool2NodeHandler> p) throws Exception {
        String clientHost;
        APool2NodeFactory aPool2NodeFactory = this;
        synchronized (aPool2NodeFactory) {
            int numAllocated = this.pool.getNumActive();
            if (numAllocated > this.statMaxAllocated) {
                this.statMaxAllocated = numAllocated;
            }
        }
        String name = this.activateArguments.get();
        APool2NodeHandler poolObj = (APool2NodeHandler)p.getObject();
        try {
            clientHost = RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException e) {
            clientHost = poolObj.node.getPoolHost();
        }
        poolObj.bindClient(name, clientHost);
    }

    public void passivateObject(PooledObject<APool2NodeHandler> p) throws Exception {
        APool2NodeHandler poolObj = (APool2NodeHandler)p.getObject();
        poolObj.unbindClient();
    }

    public boolean validateObject(PooledObject<APool2NodeHandler> p) {
        APool2NodeHandler poolObj = (APool2NodeHandler)p.getObject();
        if (poolObj.isEvictRequested(0L)) {
            return false;
        }
        int max = this.maxUsageCount;
        if (max > 0 && ((DefaultPooledObject)p).getBorrowedCount() >= (long)max) {
            poolObj.stats.shutdownReason = 1;
            return false;
        }
        return true;
    }

    public void destroyObject(PooledObject<APool2NodeHandler> p) throws Exception {
        APool2NodeHandler poolObj = (APool2NodeHandler)p.getObject();
        try {
            if (poolObj.thisRemote != null) {
                try {
                    poolObj.thisRemote = null;
                    UnicastRemoteObject.unexportObject(poolObj, true);
                }
                catch (Throwable e) {
                    Utils.logWarning(Messages.RmiUnexportNode_error_message, e);
                }
            }
        }
        catch (Throwable throwable) {
            this.executor.submit(new Runnable(poolObj){
                private final /* synthetic */ APool2NodeHandler val$poolObj;
                {
                    this.val$poolObj = aPool2NodeHandler;
                }

                @Override
                public void run() {
                    try {
                        APool2NodeFactory.this.nodeFactory.stopNode(this.val$poolObj);
                        for (PoolListener listener : APool2NodeFactory.this.poolListeners.toList()) {
                            try {
                                listener.disposed(this.val$poolObj);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    finally {
                        APool2NodeFactory.this.nodes.remove((Object)this.val$poolObj);
                    }
                }
            });
            throw throwable;
        }
        this.executor.submit(new /* invalid duplicate definition of identical inner class */);
    }

    public int getStatMaxTotal() {
        return this.statMaxTotal;
    }

    public int getStatMaxAllocated() {
        return this.statMaxAllocated;
    }
}

