/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.emf.ui.forms.DirectResourceEditorInput;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.rtm.base.ui.IRtDescriptor;
import org.eclipse.statet.rtm.base.ui.actions.PerspectiveUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractNewRTaskHandler
extends AbstractHandler {
    private final IRtDescriptor rtDescriptor;

    public AbstractNewRTaskHandler(IRtDescriptor descriptor) {
        this.rtDescriptor = descriptor;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IContentType contentType = Platform.getContentTypeManager().getContentType(this.rtDescriptor.getDefaultContentTypeID());
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = DirectResourceEditorInput.NO_URI;
            Resource resource = resourceSet.createResource(fileURI, contentType.getId());
            resource.getContents().clear();
            EObject rootObject = this.createInitialModel();
            if (rootObject != null) {
                resource.getContents().add((Object)rootObject);
            }
            PerspectiveUtil perspectiveUtil = new PerspectiveUtil();
            perspectiveUtil.updatePerspective(this.rtDescriptor.getAssociatedPerspectiveId());
            IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
            IEditorDescriptor editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("", contentType);
            String name = DirectResourceEditorInput.createNumberedName(contentType.getName());
            page.openEditor((IEditorInput)new DirectResourceEditorInput(name, resource), editor.getId());
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", NLS.bind((String)"An error occurred when creating a new R task editor for {0}.", (Object)this.rtDescriptor.getName()), (Throwable)e), 3);
        }
        return null;
    }

    protected EObject createInitialModel() {
        return this.rtDescriptor.createInitialModelObject();
    }
}

