/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.sourceediting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.Group;
import org.eclipse.statet.docmlet.tex.core.ast.Label;
import org.eclipse.statet.docmlet.tex.core.ast.TexAst;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.Text;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;

public class LtxAssistInvocationContext
extends AssistInvocationContext {
    private ControlNode invoControlNode;
    private TexAstNode[] invoArgNodes;
    private int invoArgIdx = -2;

    public LtxAssistInvocationContext(ISourceEditor editor, int offset, String contentType, boolean isProposal, IProgressMonitor monitor) {
        super(editor, offset, contentType, isProposal ? 2 : 0, monitor);
    }

    protected String computeIdentifierPrefix(int offset) {
        IDocument document = this.getDocument();
        try {
            int start = offset;
            block6: while (offset > 0) {
                char c = document.getChar(offset - 1);
                switch (c) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        start = --offset;
                        break;
                    }
                    case '\\': {
                        start = offset;
                        do {
                            if (--offset > 0 && document.getChar(offset - 1) == '\\') continue;
                            --start;
                            break block6;
                        } while (--offset > 0 && document.getChar(offset - 1) == '\\');
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
            }
            return document.get(start, this.getInvocationOffset() - start);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private void computeInvArgInfo() {
        this.invoArgIdx = -1;
        if (this.getAstSelection().getCovering() instanceof TexAstNode) {
            TexAstNode texNode = (TexAstNode)this.getAstSelection().getCovering();
            if (texNode instanceof Label || texNode instanceof Text) {
                texNode = texNode.getTexParent();
            }
            int offset = this.getInvocationOffset();
            if (texNode instanceof Group && texNode.getParent() instanceof ControlNode && (this.invoControlNode = (ControlNode)texNode.getParent()).getCommand() != null) {
                this.invoArgNodes = TexAst.resolveArguments((ControlNode)this.invoControlNode);
                this.invoArgIdx = TexAst.getIndexAt((TexAstNode[])this.invoArgNodes, (int)offset);
            }
        }
    }

    public ControlNode getInvocationControlNode() {
        if (this.invoArgIdx == -2) {
            this.computeInvArgInfo();
        }
        return this.invoControlNode;
    }

    public TexAstNode[] getInvocationArgNodes() {
        if (this.invoArgIdx == -2) {
            this.computeInvArgInfo();
        }
        return this.invoArgNodes;
    }

    public int getInvocationArgIdx() {
        if (this.invoArgIdx == -2) {
            this.computeInvArgInfo();
        }
        return this.invoArgIdx;
    }
}

