/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.variables.core;

import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.statet.ecommons.variables.core.DynamicVariable;
import org.eclipse.statet.ecommons.variables.core.ObservableVariable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ObservableValueVariable<TValue>
extends DynamicVariable
implements ObservableVariable {
    private final IObservableValue<TValue> observable;

    public ObservableValueVariable(String name, @Nullable String description, IObservableValue<TValue> observable) {
        super(name, description, false);
        if (observable == null) {
            throw new NullPointerException("observable");
        }
        this.observable = observable;
    }

    public ObservableValueVariable(IStringVariable variable, IObservableValue<TValue> observable) {
        this(variable.getName(), variable.getDescription(), observable);
    }

    public IObservableValue<TValue> getObservable() {
        return this.observable;
    }

    @Override
    public void addChangeListener(IChangeListener listener) {
        this.observable.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(IChangeListener listener) {
        this.observable.removeChangeListener(listener);
    }

    @Override
    public @Nullable String getValue(@Nullable String argument) throws CoreException {
        String value = this.toVariableValue(this.observable.getValue());
        if (value == null) {
            return super.getValue(null);
        }
        return value.toString();
    }

    protected @Nullable String toVariableValue(TValue value) {
        return value != null ? value.toString() : null;
    }
}

