/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.treepartitioner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNodeType;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;

abstract class NodePosition
extends Position
implements ITreePartitionNode {
    private static final List<NodePosition> NO_CHILDREN = Collections.emptyList();
    private static final ImList<Object> NO_ATTACHMENTS = ImCollections.emptyList();
    NodePosition parent;
    List<NodePosition> children = NO_CHILDREN;
    ITreePartitionNodeType type;
    int stamp;
    int flags;
    private volatile ImList<Object> attachments = NO_ATTACHMENTS;

    /*
     * Unable to fully structure code
     */
    static final int indexOf(List<NodePosition> children, int offset) {
        begin = 0;
        end = children.size() - 1;
        while (begin <= end) {
            i = begin + end >>> 1;
            child = children.get(i);
            if (child.offset > offset) {
                end = i - 1;
                continue;
            }
            if (child.offset == offset || child.offset + child.length > offset) ** GOTO lbl15
            begin = i + 1;
            continue;
lbl-1000:
            // 1 sources

            {
                child = children.get(i - 1);
                if (child.offset != offset && child.offset + child.length <= offset) break;
                --i;
lbl15:
                // 2 sources

                ** while (i > 0)
            }
lbl16:
            // 2 sources

            return i;
        }
        return -(begin + 1);
    }

    public NodePosition(NodePosition parent, int offset, int length, ITreePartitionNodeType type, int stamp) {
        super(offset, length);
        this.parent = parent;
        this.type = type;
        this.stamp = stamp;
    }

    @Override
    public abstract int getStartOffset();

    @Override
    public abstract int getEndOffset();

    @Override
    public abstract int getLength();

    @Override
    public int getFlags() {
        return this.flags;
    }

    final void insertChild(int childIdx, NodePosition child) {
        assert (child.parent == this);
        if (this.children == NO_CHILDREN) {
            this.children = new ArrayList<NodePosition>(8);
        }
        this.children.add(childIdx, child);
    }

    private final void removeChild(NodePosition child) {
        assert (child.parent == this);
        child.parent = null;
        if (this.isDeleted) {
            return;
        }
        int idx = 0;
        while (idx < this.children.size()) {
            if (this.children.get(idx) == child) {
                this.children.remove(idx);
                return;
            }
            ++idx;
        }
        assert (false);
    }

    public final void delete() {
        super.delete();
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public final void undelete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ITreePartitionNodeType getType() {
        return this.type;
    }

    @Override
    public ITreePartitionNode getParent() {
        return this.parent;
    }

    @Override
    public final int getChildCount() {
        return this.children.size();
    }

    @Override
    public final ITreePartitionNode getChild(int idx) {
        return this.children.get(idx);
    }

    @Override
    public final int indexOfChild(int offset) {
        return NodePosition.indexOf(this.children, offset);
    }

    @Override
    public final int indexOfChild(ITreePartitionNode child) {
        int idx = NodePosition.indexOf(this.children, child.getStartOffset());
        assert (idx >= 0);
        do {
            if (this.children.get(idx) != child) continue;
            return idx;
        } while (++idx < this.children.size());
        throw new IllegalArgumentException("child");
    }

    @Override
    public synchronized void addAttachment(Object data) {
        this.attachments = ImCollections.addElement(this.attachments, (Object)data);
    }

    @Override
    public synchronized void removeAttachment(Object data) {
        this.attachments = ImCollections.removeElement(this.attachments, (Object)data);
    }

    @Override
    public ImList<Object> getAttachments() {
        return this.attachments;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NodePosition [");
        sb.append(this.getOffset());
        sb.append(", ");
        sb.append(this.getOffset() + this.getLength());
        sb.append(") ");
        if (this.isDeleted()) {
            sb.append("<deleted> ");
        }
        sb.append(this.type);
        return sb.toString();
    }

    static final class CommonNode
    extends NodePosition {
        public CommonNode(NodePosition parent, int offset, int length, ITreePartitionNodeType type, int stamp) {
            super(parent, offset, length, type, stamp);
        }

        @Override
        public int getStartOffset() {
            return this.offset;
        }

        @Override
        public int getEndOffset() {
            return this.offset + this.length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

