/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class GradientBackgroundPainter
extends CellPainterWrapper {
    private final boolean vertical;

    public GradientBackgroundPainter() {
        this(false);
    }

    public GradientBackgroundPainter(boolean vertical) {
        this.vertical = vertical;
    }

    public GradientBackgroundPainter(ICellPainter painter) {
        this(painter, false);
    }

    public GradientBackgroundPainter(ICellPainter painter, boolean vertical) {
        super(painter);
        this.vertical = vertical;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle bounds, IConfigRegistry configRegistry) {
        Color foregroundColor = this.getForeGroundColour(cell, configRegistry);
        Color backgroundColor = this.getBackgroundColour(cell, configRegistry);
        if (backgroundColor != null && foregroundColor != null) {
            Color originalForeground = gc.getForeground();
            Color originalBackground = gc.getBackground();
            gc.setForeground(foregroundColor);
            gc.setBackground(backgroundColor);
            Rectangle rect = GraphicsUtils.safe(bounds);
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, this.vertical);
            gc.setForeground(originalForeground);
            gc.setBackground(originalBackground);
        }
        super.paintCell(cell, gc, bounds, configRegistry);
    }

    protected Color getForeGroundColour(ILayerCell cell, IConfigRegistry configRegistry) {
        Color fgColor = CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR);
        return fgColor != null ? fgColor : CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
    }

    protected Color getBackgroundColour(ILayerCell cell, IConfigRegistry configRegistry) {
        Color bgColor = CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR);
        return bgColor != null ? bgColor : CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
    }
}

