/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net;

import java.io.Serializable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.Port;

@NonNullByDefault
public class PortRange
implements Serializable {
    private static final long serialVersionUID = 6035156412290812307L;
    private final int min;
    private final int max;

    public static PortRange valueOf(String s) throws IllegalArgumentException {
        int idx;
        if (s.length() >= 3 && (idx = s.indexOf(45, 1)) != -1) {
            return new PortRange(Integer.parseInt(s.substring(0, idx)), Integer.parseInt(s.substring(idx + 1, s.length())));
        }
        if (s.length() > 0) {
            return new PortRange(Integer.parseInt(s));
        }
        throw new NumberFormatException("s= <empty>");
    }

    public PortRange(int min, int max) {
        if (!Port.isValidPortNum(min)) {
            throw new IllegalArgumentException("min= " + min);
        }
        if (!Port.isValidPortNum(max)) {
            throw new IllegalArgumentException("max= " + max);
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        this.min = min;
        this.max = max;
    }

    public PortRange(int num) {
        if (num < 0) {
            throw new IllegalArgumentException("num= " + num);
        }
        this.min = num;
        this.max = num;
    }

    public PortRange(Port from, Port to) {
        this(from.get(), to.get());
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getLength() {
        return this.max - this.min + 1;
    }

    public boolean contains(Port port) {
        int num = port.get();
        return num >= this.min && num <= this.max;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.min);
        sb.append('-');
        sb.append(this.max);
        return sb.toString();
    }

    public int hashCode() {
        return this.min + this.max + (this.max << 7);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PortRange) {
            PortRange other = (PortRange)obj;
            return this.min == other.min && this.max == other.max;
        }
        return false;
    }

    public String toString() {
        if (this.min == this.max) {
            return Integer.toString(this.min);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.min);
        sb.append('-');
        sb.append(this.max);
        return sb.toString();
    }
}

