/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.statet.ecommons.text.IPartitionScannerConfigExt;

public class Partitioner
extends FastPartitioner {
    public Partitioner(IPartitionTokenScanner scanner, String[] legalContentTypes) {
        super(scanner, legalContentTypes);
    }

    public void setStartPartitionType(String partitionType) {
        if (!(this.fScanner instanceof IPartitionScannerConfigExt)) {
            throw new UnsupportedOperationException();
        }
        ((IPartitionScannerConfigExt)this.fScanner).setStartPartitionType(partitionType);
    }

    public void resetCache() {
        this.clearPositionCache();
    }

    public ITypedRegion getPartition(int offset, boolean preferOpenPartitions) {
        ITypedRegion region = this.getPartition(offset);
        if (preferOpenPartitions) {
            if (offset > 0) {
                if (offset == this.fDocument.getLength()) {
                    return this.getPartition(offset - 1);
                }
                try {
                    char c = this.fDocument.getChar(offset);
                    if ((c == '\n' || c == '\r') && (c = this.fDocument.getChar(offset - 1)) != '\n' && c != '\r') {
                        return this.getPartition(offset - 1);
                    }
                }
                catch (BadLocationException c) {
                    // empty catch block
                }
            }
            String contentType = region.getType();
            if (region.getOffset() == offset && !contentType.equals("__dftl_partition_content_type") && !contentType.endsWith("_default")) {
                String type;
                if (offset > 0) {
                    ITypedRegion open = this.getPartition(offset - 1);
                    type = this.getPrefereOpenType(open.getType(), contentType);
                    if (type == open.getType()) {
                        return open;
                    }
                    if (type == contentType) {
                        return region;
                    }
                } else {
                    type = "__dftl_partition_content_type";
                }
                return new TypedRegion(offset, 0, type);
            }
        }
        return region;
    }

    protected String getPrefereOpenType(String open, String opening) {
        if (open.equals("__dftl_partition_content_type") || open.endsWith("_default")) {
            return open;
        }
        return "__dftl_partition_content_type";
    }
}

