/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.Objects;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.ui.IElementLabelProvider;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.CompletionProposalWithOverwrite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public abstract class ElementNameCompletionProposal<E extends IModelElement>
extends CompletionProposalWithOverwrite
implements ICompletionProposalExtension3,
ICompletionProposalExtension6 {
    private final ElementName replacementName;
    private final E element;
    private final int relevance;
    private final IElementLabelProvider labelProvider;
    private int cursorPosition = -1;

    public ElementNameCompletionProposal(AssistInvocationContext context, ElementName replacementName, int replacementOffset, E element, int relevance, IElementLabelProvider labelProvider) {
        super(context, replacementOffset);
        this.replacementName = replacementName;
        this.element = element;
        this.labelProvider = labelProvider;
        this.relevance = relevance;
    }

    public final E getElement() {
        return this.element;
    }

    protected final IElementLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Image getImage() {
        return this.labelProvider.getImage((IModelElement)this.getElement());
    }

    public String getDisplayString() {
        return this.labelProvider.getText((IModelElement)this.getElement());
    }

    public StyledString getStyledDisplayString() {
        return this.labelProvider.getStyledText((IModelElement)this.getElement());
    }

    public @Nullable String getAdditionalProposalInfo() {
        return null;
    }

    @Override
    public int getRelevance() {
        return this.relevance;
    }

    public ElementName getReplacementName() {
        return this.replacementName;
    }

    @Override
    public String getSortingString() {
        return this.getReplacementName().getSegmentName();
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            String content = document.get(this.getReplacementOffset(), offset - this.getReplacementOffset());
            if (this.getReplacementName().getSegmentName().regionMatches(true, 0, content, 0, content.length())) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAutoInsertable() {
        return false;
    }

    @Override
    protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
        AssistInvocationContext context = this.getInvocationContext();
        SourceViewer viewer = context.getSourceViewer();
        IDocument document = viewer.getDocument();
        StringBuilder replacement = new StringBuilder(this.getReplacementName().getDisplayName());
        document.replace(replacementOffset, replacementLength, replacement.toString());
        this.setCursorPosition(replacementOffset + replacement.length());
    }

    protected void setCursorPosition(int offset) {
        this.cursorPosition = offset;
    }

    public @Nullable IContextInformation getContextInformation() {
        return null;
    }

    public @Nullable Point getSelection(IDocument document) {
        if (this.cursorPosition >= 0) {
            return new Point(this.cursorPosition, 0);
        }
        return null;
    }

    public int getPrefixCompletionStart(IDocument document, int offset) {
        return this.getReplacementOffset();
    }

    public @Nullable CharSequence getPrefixCompletionText(IDocument document, int offset) {
        return null;
    }

    public @Nullable IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public int hashCode() {
        return this.getClass().hashCode() * Objects.hashCode(this.getReplacementName());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            ElementNameCompletionProposal other = (ElementNameCompletionProposal)obj;
            return Objects.equals(this.getReplacementName(), other.getReplacementName()) && Objects.equals(this.getElement(), other.getElement());
        }
        return false;
    }
}

