/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.actions.ControlServicesUtil;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.components.DropDownButton;
import org.eclipse.statet.ecommons.ui.components.SearchText;
import org.eclipse.statet.ecommons.ui.util.AutoCheckController;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.ui.datafilter.TextSearchType;
import org.eclipse.statet.internal.r.ui.datafilter.TextVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilterview.ColumnLabelProvider;
import org.eclipse.statet.internal.r.ui.datafilterview.FilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.Messages;
import org.eclipse.statet.internal.r.ui.datafilterview.RStore2UIConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.RStoreContentProvider;
import org.eclipse.statet.internal.r.ui.datafilterview.UI2RStoreConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableComposite;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

public class TextClient
extends FilterClient {
    private SearchText searchTextControl;
    private DropDownButton searchButtonControl;
    private MenuItem[] searchMenuItems;
    private TextSearchType searchType;
    private CheckboxTableViewer valueListViewer;
    private RCharacterStore availableValues;
    private final IObservableSet<?> selectedValueSet;
    private final HandlerCollection valueListHandlers = new HandlerCollection();
    private MenuManager valueListMenuManager;
    private final TextVariableFilter filter;

    public TextClient(VariableComposite parent, TextVariableFilter filter) {
        super(parent);
        this.filter = filter;
        filter.setListener(this);
        this.availableValues = filter.getAvailableValues();
        this.selectedValueSet = filter.getSelectedValues();
        this.searchType = TextSearchType.ECLIPSE;
        this.init(2);
    }

    @Override
    public TextVariableFilter getFilter() {
        return this.filter;
    }

    @Override
    protected void addWidgets() {
        this.searchTextControl = new SearchText((Composite)this, "", 0x800000);
        this.searchTextControl.addListener(new SearchText.Listener(){

            public void textChanged(boolean user) {
            }

            public void okPressed() {
                TextClient.this.search(null);
            }

            public void downPressed() {
            }
        });
        this.searchTextControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchButtonControl = new DropDownButton((Composite)this, 0x800000);
        this.searchButtonControl.setText(Messages.Items_Search_label);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.heightHint = this.searchButtonControl.computeSize((int)-1, (int)-1).y;
        int textHeight = this.searchTextControl.computeSize((int)-1, (int)-1).y;
        if (gd.heightHint - textHeight > 2) {
            gd.heightHint = textHeight + 2;
        }
        this.searchButtonControl.setLayoutData((Object)gd);
        this.searchButtonControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextClient.this.search(null);
            }
        });
        Menu searchMenu = this.searchButtonControl.getDropDownMenu();
        ImList<TextSearchType> searchTypes = TextSearchType.TYPES;
        this.searchMenuItems = new MenuItem[searchTypes.size()];
        Listener searchTypeListener = new Listener(){

            public void handleEvent(Event event) {
                TextClient.this.search((TextSearchType)event.widget.getData());
            }
        };
        int id = 0;
        while (id < searchTypes.size()) {
            TextSearchType type = (TextSearchType)searchTypes.get(id);
            MenuItem item = new MenuItem(searchMenu, 16);
            item.setText(type.getLabel());
            item.setData((Object)type);
            item.addListener(13, searchTypeListener);
            this.searchMenuItems[id] = item;
            ++id;
        }
        this.setSearchType(this.searchType);
        this.valueListViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)8454146);
        this.valueListViewer.setContentProvider((IContentProvider)new RStoreContentProvider());
        this.valueListViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(this.filter.getColumn()));
    }

    @Override
    protected void initActions(IServiceLocator serviceLocator) {
        ControlServicesUtil servicesUtil = new ControlServicesUtil(serviceLocator, String.valueOf(this.getClass().getName()) + "/ValueList#" + this.hashCode(), (Control)this);
        servicesUtil.addControl((Control)this.valueListViewer.getTable());
        AutoCheckController autoCheckController = new AutoCheckController(this.valueListViewer, this.selectedValueSet);
        Object handler = autoCheckController.createSelectAllHandler();
        this.valueListHandlers.add("org.eclipse.ui.edit.selectAll", handler);
        servicesUtil.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)handler);
        handler = new RemoveHandler();
        this.valueListHandlers.add("org.eclipse.ui.edit.delete", handler);
        servicesUtil.activateHandler("org.eclipse.ui.edit.delete", (IHandler)handler);
        handler = new RemoveUncheckedHandler();
        this.valueListHandlers.add("RemoveUnchecked", handler);
        handler = new RemoveAllHandler();
        this.valueListHandlers.add("RemoveAll", handler);
        ViewerUtils.installSearchTextNavigation((TableViewer)this.valueListViewer, (SearchText)this.searchTextControl, (boolean)true);
        this.valueListMenuManager = new MenuManager();
        this.valueListMenuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.edit.selectAll", 8), this.valueListHandlers.get("org.eclipse.ui.edit.selectAll")));
        this.valueListMenuManager.add((IContributionItem)new Separator());
        this.valueListMenuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.edit.delete", 8), this.valueListHandlers.get("org.eclipse.ui.edit.delete")));
        this.valueListMenuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, null, null, null, Messages.Items_RemoveUnchecked_label, null, "Remove unchecked items", 8, null, false), this.valueListHandlers.get("RemoveUnchecked")));
        this.valueListMenuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, null, null, null, Messages.Items_RemoveAll_label, null, "Remove all items", 8, null, false), this.valueListHandlers.get("RemoveAll")));
        this.valueListViewer.getTable().setMenu(this.valueListMenuManager.createContextMenu(this.valueListViewer.getControl()));
        this.valueListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TextClient.this.updateActions();
            }
        });
        this.updateActions();
    }

    @Override
    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)this.valueListViewer, Object.class), this.selectedValueSet, new UpdateSetStrategy().setConverter(UI2RStoreConverter.INSTANCE), new UpdateSetStrategy().setConverter(RStore2UIConverter.INSTANCE));
    }

    @Override
    protected void updateInput() {
        this.availableValues = this.filter.getAvailableValues();
        this.valueListViewer.setInput((Object)this.availableValues);
        this.updateActions();
        if (this.updateLayout()) {
            this.getParent().layout(new Control[]{this});
        }
    }

    protected void updateActions() {
        this.valueListHandlers.get("org.eclipse.ui.edit.delete").setEnabled(null);
    }

    @Override
    protected boolean updateLayout() {
        return this.updateLayout((TableViewer)this.valueListViewer, (int)this.availableValues.getLength());
    }

    @Override
    protected int getMinHeightPadding() {
        return this.searchTextControl.getSize().y + 20 + 10 * LayoutUtils.defaultVSpacing();
    }

    protected void setSearchType(TextSearchType type) {
        this.searchType = type;
        int id = 0;
        while (id < this.searchMenuItems.length) {
            this.searchMenuItems[id].setSelection(type.getId() == id);
            ++id;
        }
        this.searchButtonControl.setToolTipText(type.getLabel());
    }

    private void search(TextSearchType type) {
        if (type != null) {
            if (this.searchType != type) {
                this.setSearchType(type);
            }
        } else {
            type = this.searchType;
        }
        String text = this.searchTextControl.getText();
        this.filter.search(type, text);
    }

    @Override
    protected void onDispose() {
        if (this.valueListMenuManager != null) {
            this.valueListMenuManager.dispose();
            this.valueListMenuManager = null;
        }
    }

    private class RemoveAllHandler
    extends AbstractHandler {
        private RemoveAllHandler() {
        }

        public void setEnabled(Object evaluationContext) {
            this.setBaseEnabled(TextClient.this.availableValues.getLength() > 0L);
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            TextClient.this.filter.removeAllValues();
            TextClient.this.updateInput();
            return null;
        }
    }

    private class RemoveHandler
    extends AbstractHandler
    implements IElementUpdater {
        private RemoveHandler() {
        }

        public void setEnabled(Object evaluationContext) {
            this.setBaseEnabled(!TextClient.this.valueListViewer.getSelection().isEmpty());
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            IStructuredSelection selection = (IStructuredSelection)TextClient.this.valueListViewer.getSelection();
            TextClient.this.filter.removeValues(selection.toList());
            TextClient.this.updateInput();
            return null;
        }

        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
            try {
                element.setText(Messages.Items_Remove_label);
                element.setTooltip(Messages.Items_RemoveSelected_label);
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }
    }

    private class RemoveUncheckedHandler
    extends AbstractHandler {
        private RemoveUncheckedHandler() {
        }

        public void setEnabled(Object evaluationContext) {
            this.setBaseEnabled(TextClient.this.availableValues.getLength() > (long)TextClient.this.selectedValueSet.size());
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            ArrayList<String> values = new ArrayList<String>((int)TextClient.this.availableValues.getLength() - TextClient.this.selectedValueSet.size());
            int i = 0;
            while ((long)i < TextClient.this.availableValues.getLength()) {
                String value = TextClient.this.availableValues.get(i);
                if (!TextClient.this.selectedValueSet.contains((Object)value)) {
                    values.add(value);
                }
                ++i;
            }
            TextClient.this.filter.removeValues(values);
            TextClient.this.updateInput();
            return null;
        }
    }
}

