/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.core.IFragmentDocument;
import org.eclipse.statet.ecommons.text.core.IPartitionConstraint;
import org.eclipse.statet.internal.r.ui.FCallNamePattern;
import org.eclipse.statet.internal.r.ui.editors.RElementCompletionProposal;
import org.eclipse.statet.internal.r.ui.editors.RKeywordCompletionProposal;
import org.eclipse.statet.internal.r.ui.editors.RSimpleCompletionProposal;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.ui.IElementLabelProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IContentAssistComputer;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RSymbolComparator;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.ArgsDefinition;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.model.IRLangElement;
import org.eclipse.statet.r.core.model.IRMethod;
import org.eclipse.statet.r.core.model.RCoreFunctions;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.statet.r.ui.sourceediting.RFrameSearchPath;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RHelpTopicEntry;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RPkgBuilt;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgUtils;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;

public class RElementCompletionComputer
implements IContentAssistComputer {
    private static final IPartitionConstraint NO_R_COMMENT_CONSTRAINT = new IPartitionConstraint(){

        public boolean matches(String partitionType) {
            return partitionType != "R.Comment";
        }
    };
    private static final List<String> fgKeywords;
    protected static final int NA_PRIO = Integer.MIN_VALUE;
    protected static final int ARG_NAME_PRIO = 80;
    protected static final int ARG_TYPE_PRIO = 40;
    protected static final int ARG_TYPE_NO_PRIO = -40;
    private final IElementLabelProvider labelProvider = new RLabelProvider(1);
    private final int mode;
    private IRSourceEditor editor;
    private ContentAssist assist;
    private final RFrameSearchPath searchPath = new RFrameSearchPath();
    private boolean inDefault;
    private boolean inString;
    private int pkgNamePrio;
    private int helpTopicPrio;
    private IStatus resultStatus;

    static {
        ArrayList list = new ArrayList();
        Collections.addAll(list, RTokens.CONSTANT_WORDS);
        Collections.addAll(list, RTokens.FLOWCONTROL_WORDS);
        Collections.sort(list, RSymbolComparator.R_NAMES_COLLATOR);
        list.trimToSize();
        fgKeywords = Collections.unmodifiableList(list);
    }

    private static String toString(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            Collections.sort(list, RPkgUtils.NAMES_COLLATOR);
            return CollectionUtils.toString((List)list, (String)", ");
        }
        return value.toString();
    }

    public RElementCompletionComputer() {
        this(0);
    }

    protected RElementCompletionComputer(int mode) {
        this.mode = mode;
    }

    public void sessionStarted(ISourceEditor editor, ContentAssist assist) {
        this.editor = editor instanceof IRSourceEditor ? (IRSourceEditor)editor : null;
        this.assist = assist;
    }

    public void sessionEnded() {
        this.searchPath.clear();
        this.assist = null;
        this.resultStatus = null;
    }

    protected final void setStatus(IStatus status) {
        this.resultStatus = status;
    }

    protected final int getSearchMode(RAssistInvocationContext context) {
        if (this.mode != 0) {
            return this.mode;
        }
        return context.getDefaultRFrameSearchMode();
    }

    protected final boolean isSymbolCandidate(String name) {
        int i = 0;
        while (i < name.length()) {
            if (RTokens.isRobustSeparator((int)name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isCompletable(RElementName elementName) {
        if (elementName == null) {
            return false;
        }
        do {
            switch (elementName.getType()) {
                case 27: 
                case 28: {
                    return false;
                }
            }
            if (elementName.getSegmentName() != null) continue;
            return false;
        } while ((elementName = elementName.getNextSegment()) != null);
        return true;
    }

    private RAstNode getRAstNode(RAssistInvocationContext context) {
        AstNode node = context.getInvocationAstSelection().getCovering();
        if (node == null) {
            node = context.getAstInfo().getRoot();
        }
        return node instanceof RAstNode ? (RAstNode)node : null;
    }

    public IStatus computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        this.resultStatus = null;
        if (context instanceof RAssistInvocationContext) {
            this.computeCompletionProposals((RAssistInvocationContext)context, mode, proposals, monitor);
        }
        return this.resultStatus;
    }

    public IStatus computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        this.resultStatus = null;
        if (context instanceof RAssistInvocationContext) {
            this.doComputeContextProposals((RAssistInvocationContext)context, proposals, monitor);
        }
        return this.resultStatus;
    }

    protected void computeCompletionProposals(RAssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context.getModelInfo() == null) {
            return;
        }
        RAstNode node = this.getRAstNode(context);
        RElementName prefixName = context.getIdentifierElementName();
        if (prefixName == null) {
            return;
        }
        this.inString = context.getInvocationContentType() == "R.String";
        this.inDefault = !this.inString;
        this.pkgNamePrio = Integer.MIN_VALUE;
        this.helpTopicPrio = Integer.MIN_VALUE;
        if (prefixName.getNextSegment() == null) {
            String help = this.checkHelp(context);
            if (help != null) {
                this.doComputeHelpTopicProposals(context, help, node, 40, proposals);
                if (prefixName.getScope() == null) {
                    this.doComputePkgNameProposals(context, -40, proposals);
                }
                return;
            }
            this.doComputeArgumentProposals(context, proposals, monitor);
            if (this.inDefault) {
                this.doComputeMainProposals(context, node, proposals, monitor);
            }
            if (this.mode == 0 && this.inDefault) {
                this.doComputeKeywordProposals(context, proposals, monitor);
            }
            if (this.mode == 0) {
                if (this.isPackageName(prefixName)) {
                    if (this.pkgNamePrio > 0) {
                        this.doComputePkgNameProposals(context, this.pkgNamePrio, proposals);
                    } else if (!prefixName.getSegmentName().isEmpty()) {
                        this.doComputePkgNameProposals(context, -40, proposals);
                    }
                }
                if (this.helpTopicPrio > 0) {
                    this.doComputeHelpTopicProposals(context, null, node, this.helpTopicPrio, proposals);
                }
            }
        } else {
            this.doComputeSubProposals(context, node, proposals, monitor);
        }
    }

    private String checkHelp(RAssistInvocationContext context) {
        try {
            if (context.getIdentifierOffset() > 0 && context.getDocument().getChar(context.getIdentifierOffset() - 1) == '?') {
                String prefix = context.computeIdentifierPrefix(context.getIdentifierOffset() - 1);
                if (prefix != null && !prefix.isEmpty()) {
                    if (prefix.equals("class") || prefix.equals("methods")) {
                        return prefix;
                    }
                    return null;
                }
                return "";
            }
            return null;
        }
        catch (BadLocationException | BadPartitioningException e) {
            return null;
        }
    }

    protected List<? extends IRLangElement> getChildren(RAssistInvocationContext context, IRLangElement e) {
        if (e instanceof RReference) {
            RReference ref = (RReference)e;
            RObject rObject = ref.getResolvedRObject();
            if (rObject == null && e instanceof CombinedRElement && context.getTool() != null) {
                context.getToolReferencesUtil().resolve(ref, 0);
            }
            if (rObject instanceof CombinedRElement) {
                e = (CombinedRElement)rObject;
            }
        }
        return e.getModelChildren(null);
    }

    protected boolean doComputeArgumentProposals(RAssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RAssistInvocationContext.FCallInfo fCallInfo = context.getFCallInfo();
        if (fCallInfo != null) {
            boolean argName = false;
            boolean argValue = false;
            int argIdx = fCallInfo.getArgIdx(context.getInvocationOffset());
            if (argIdx >= 0) {
                int offset;
                RHeuristicTokenScanner scanner;
                FCall.Arg arg = fCallInfo.getArg(argIdx);
                int argBeginOffset = fCallInfo.getArgBeginOffset(argIdx);
                IDocument document = context.getDocument();
                int offsetShift = 0;
                if (document instanceof IFragmentDocument) {
                    IFragmentDocument inputDoc = (IFragmentDocument)document;
                    document = inputDoc.getMasterDocument();
                    offsetShift = inputDoc.getOffsetInMasterDocument();
                }
                if (argBeginOffset != Integer.MIN_VALUE) {
                    scanner = context.getRHeuristicTokenScanner();
                    scanner.configure(document, NO_R_COMMENT_CONSTRAINT);
                    offset = context.getIdentifierOffset();
                    if (argBeginOffset == offset || scanner.findNonBlankForward(argBeginOffset + offsetShift, offset + offsetShift, true) < 0) {
                        argName = this.inDefault && context.getIdentifierElementName().getScope() == null;
                        argValue = true;
                    }
                }
                if (!argValue && arg != null && arg.getAssignOffset() != Integer.MIN_VALUE) {
                    scanner = context.getRHeuristicTokenScanner();
                    scanner.configure(document, NO_R_COMMENT_CONSTRAINT);
                    offset = context.getIdentifierOffset();
                    if (argBeginOffset == offset || scanner.findNonBlankForward(arg.getAssignOffset() + offsetShift + 1, offset + offsetShift, true) < 0) {
                        argValue = true;
                    }
                }
            }
            if (argName || argValue) {
                this.doComputeFCallArgumentProposals(context, fCallInfo, argIdx, argName, argValue, proposals);
                return true;
            }
        }
        return false;
    }

    protected void doComputeMainProposals(RAssistInvocationContext context, RAstNode node, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        this.searchPath.init(context, node, this.getSearchMode(context), prefixName.getScope());
        RSymbolComparator.PrefixPattern pattern = new RSymbolComparator.PrefixPattern(prefixSegmentName);
        int offset = context.getIdentifierLastSegmentOffset();
        HashSet<String> mainNames = new HashSet<String>();
        ArrayList<String> methodNames = new ArrayList<String>();
        RFrameSearchPath.RFrameIterator iter = this.searchPath.iterator();
        while (iter.hasNext()) {
            IRFrame envir = iter.next();
            List elements = envir.getModelChildren(null);
            for (IRElement element : elements) {
                IAssistCompletionProposal proposal;
                int relevance;
                boolean isRich;
                RElementName elementName = element.getElementName();
                int c1type = element.getElementType() & 0xF00;
                boolean bl = isRich = c1type == 1280;
                if (!isRich && c1type != 1536 || !this.isCompletable(elementName) || !pattern.matches(elementName.getSegmentName()) || (relevance = iter.getRelevance()) < 0 && !isRich && mainNames.contains(elementName.getSegmentName()) || (proposal = this.createProposal(context, offset, elementName, element, relevance)) == null) continue;
                if (elementName.getNextSegment() == null) {
                    if (isRich) {
                        methodNames.add(elementName.getSegmentName());
                    } else {
                        mainNames.add(elementName.getSegmentName());
                    }
                }
                proposals.add(proposal);
            }
        }
        mainNames.addAll(methodNames);
        for (IRFrame envir : this.searchPath) {
            if (!(envir instanceof IRFrameInSource)) continue;
            IRFrameInSource sframe = (IRFrameInSource)envir;
            Set elementNames = sframe.getAllAccessNames();
            for (String candidate : elementNames) {
                IAssistCompletionProposal proposal;
                if (candidate == null || !pattern.matches(candidate) || mainNames.contains(candidate) || candidate.equals(prefixSegmentName) && sframe.getAllAccessOf(candidate, false).size() <= 1 || (proposal = this.createProposal(context, offset, candidate)) == null) continue;
                mainNames.add(candidate);
                proposals.add(proposal);
            }
        }
    }

    private void doComputeKeywordProposals(RAssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (prefixName.getScope() != null) {
            return;
        }
        String prefixSource = context.getIdentifierPrefix();
        if (!prefixSegmentName.isEmpty() && prefixSource.charAt(0) != '`') {
            int offset = context.getIdentifierOffset();
            List<String> keywords = fgKeywords;
            for (String keyword : keywords) {
                if (!keyword.regionMatches(true, 0, prefixSegmentName, 0, prefixSegmentName.length())) continue;
                proposals.add((IAssistCompletionProposal)new RKeywordCompletionProposal(context, keyword, offset));
            }
        }
    }

    protected void doComputeSubProposals(RAssistInvocationContext context, RAstNode node, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RElementName prefixName = context.getIdentifierElementName();
        this.searchPath.init(context, node, this.getSearchMode(context), prefixName.getScope());
        int count = 0;
        RElementName prefixSegment = prefixName;
        while (true) {
            ++count;
            if (prefixSegment.getNextSegment() == null) break;
            prefixSegment = prefixSegment.getNextSegment();
        }
        String namePrefix = prefixSegment.getSegmentName() != null ? prefixSegment.getSegmentName() : "";
        RSymbolComparator.PrefixPattern pattern = new RSymbolComparator.PrefixPattern(namePrefix);
        int offset = context.getIdentifierLastSegmentOffset();
        HashSet<String> mainNames = new HashSet<String>();
        ArrayList<String> methodNames = new ArrayList<String>();
        RFrameSearchPath.RFrameIterator iter = this.searchPath.iterator();
        while (iter.hasNext()) {
            IRFrame envir = iter.next();
            List elements = envir.getModelChildren(null);
            block2: for (IRLangElement rootElement : elements) {
                boolean childMode;
                List<IRLangElement> children;
                boolean isRich;
                RElementName elementName = rootElement.getElementName();
                int c1type = rootElement.getElementType() & 0xF00;
                boolean bl = isRich = c1type == 1280;
                if (!isRich && c1type != 1536) continue;
                IRLangElement element = rootElement;
                RElementName prefixSegment2 = prefixName;
                RElementName elementSegment = elementName;
                int i = 0;
                while (i < count - 1) {
                    block16: {
                        if (elementSegment == null) {
                            children = this.getChildren(context, element);
                            for (IRLangElement child : children) {
                                elementSegment = child.getElementName();
                                if (!this.isCompletable(elementSegment) || !elementSegment.getSegmentName().equals(prefixSegment2.getSegmentName())) continue;
                                element = child;
                                prefixSegment2 = prefixSegment2.getNextSegment();
                                elementSegment = elementSegment.getNextSegment();
                                break block16;
                            }
                            continue block2;
                        }
                        if (!this.isCompletable(elementSegment) || !elementSegment.getSegmentName().equals(prefixSegment2.getSegmentName())) continue block2;
                        prefixSegment2 = prefixSegment2.getNextSegment();
                        elementSegment = elementSegment.getNextSegment();
                    }
                    ++i;
                }
                if (elementSegment == null) {
                    childMode = true;
                    children = this.getChildren(context, element);
                } else {
                    childMode = false;
                    children = Collections.singletonList(element);
                }
                for (IRLangElement child : children) {
                    if (childMode) {
                        elementSegment = child.getElementName();
                    }
                    String candidate = elementSegment.getSegmentName();
                    int relevance = iter.getRelevance();
                    if (!this.isCompletable(elementSegment) || !pattern.matches(candidate)) continue;
                    if (relevance > 0 && !isRich && mainNames.contains(candidate)) continue block2;
                    IAssistCompletionProposal proposal = this.createProposal(context, offset, elementSegment, (IRElement)child, relevance);
                    if (proposal == null) continue;
                    if (elementSegment.getNextSegment() == null) {
                        if (isRich) {
                            methodNames.add(candidate);
                        } else {
                            mainNames.add(candidate);
                        }
                    }
                    proposals.add(proposal);
                }
            }
        }
        mainNames.addAll(methodNames);
        for (IRFrame envir : this.searchPath) {
            IRFrameInSource sframe;
            ImList allAccess;
            if (!(envir instanceof IRFrameInSource) || (allAccess = (sframe = (IRFrameInSource)envir).getAllAccessOf(prefixName.getSegmentName(), true)) == null) continue;
            Iterator iterator = allAccess.iterator();
            block7: while (iterator.hasNext()) {
                IAssistCompletionProposal proposal;
                String candidate;
                RElementAccess elementAccess;
                RElementAccess elementSegment = elementAccess = (RElementAccess)iterator.next();
                RElementName prefixSegment3 = prefixName;
                int i = 0;
                while (i < count - 1) {
                    if (!this.isCompletable((RElementName)elementSegment) || !elementSegment.getSegmentName().equals(prefixSegment3.getSegmentName())) continue block7;
                    prefixSegment3 = prefixSegment3.getNextSegment();
                    elementSegment = elementSegment.getNextSegment();
                    ++i;
                }
                if (elementSegment == null || elementSegment.isSlave() || (candidate = elementSegment.getSegmentName()) == null || !this.isCompletable((RElementName)elementSegment) || !pattern.matches(candidate) || mainNames.contains(candidate) || candidate.equals(namePrefix) || (proposal = this.createProposal(context, offset, candidate)) == null) continue;
                mainNames.add(candidate);
                proposals.add(proposal);
            }
        }
    }

    protected IAssistCompletionProposal createProposal(RAssistInvocationContext context, int offset, String name) {
        return new RSimpleCompletionProposal(context, name, offset);
    }

    protected IAssistCompletionProposal createProposal(RAssistInvocationContext context, int offset, RElementName elementName, IRElement element, int relevance) {
        return new RElementCompletionProposal(context, (ElementName)elementName, offset, element, relevance, this.labelProvider);
    }

    public void doComputeContextProposals(final RAssistInvocationContext context, final AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context.getModelInfo() == null) {
            return;
        }
        RAssistInvocationContext.FCallInfo fCallInfo = context.getFCallInfo();
        if (fCallInfo != null) {
            FCallNamePattern pattern = new FCallNamePattern((RElementName)fCallInfo.getAccess(), fCallInfo){
                final int infoOffset;
                {
                    super($anonymous0);
                    this.infoOffset = Math.max(fCallInfo.getNode().getArgsOpenOffset() + 1, 0);
                }

                @Override
                protected void handleMatch(IRMethod element, IRFrame frame, RFrameSearchPath.RFrameIterator iterator) {
                    proposals.add((IAssistCompletionProposal)new RElementCompletionProposal.ContextInformationProposal(context, (ElementName)element.getElementName(), this.infoOffset, (IRElement)element, iterator.getRelevance(), RElementCompletionComputer.this.labelProvider));
                }
            };
            pattern.searchFDef(fCallInfo.getSearchPath(this.getSearchMode(context)));
        }
    }

    protected final boolean isPackageArg(String name) {
        return "package".equals(name);
    }

    private void doComputeFCallArgumentProposals(RAssistInvocationContext context, RAssistInvocationContext.FCallInfo fCallInfo, int argIdx, boolean argName, boolean argValue, AssistProposalCollector proposals) {
        FCall.Arg arg;
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        int offset = context.getIdentifierOffset();
        if (argValue && !argName && (arg = fCallInfo.getArg(argIdx)) != null && arg.hasName() && this.inString && this.isPackageArg(arg.getNameChild().getText())) {
            this.pkgNamePrio = 40;
        }
        class FCallHandler
        extends FCallNamePattern {
            private final RCoreFunctions coreFunction;
            private final HashSet<String> argNames;
            private int matchCount;
            private final /* synthetic */ int val$argIdx;
            private final /* synthetic */ RAssistInvocationContext.FCallInfo val$fCallInfo;
            private final /* synthetic */ boolean val$argName;
            private final /* synthetic */ String val$prefixSegmentName;
            private final /* synthetic */ AssistProposalCollector val$proposals;
            private final /* synthetic */ RAssistInvocationContext val$context;
            private final /* synthetic */ int val$offset;
            private final /* synthetic */ boolean val$argValue;

            FCallHandler(RAssistInvocationContext.FCallInfo fCallInfo, int n, boolean bl, String string, AssistProposalCollector assistProposalCollector, RAssistInvocationContext rAssistInvocationContext, int n2, boolean bl2) {
                this.val$fCallInfo = fCallInfo;
                this.val$argIdx = n;
                this.val$argName = bl;
                this.val$prefixSegmentName = string;
                this.val$proposals = assistProposalCollector;
                this.val$context = rAssistInvocationContext;
                this.val$offset = n2;
                this.val$argValue = bl2;
                super((RElementName)fCallInfo.getAccess());
                this.argNames = new HashSet();
                this.coreFunction = fCallInfo.getAccess().getNextSegment() == null ? RCoreFunctions.DEFAULT : null;
            }

            private boolean isValidNameContext(ArgsDefinition.Arg argDef) {
                if (RElementCompletionComputer.this.inString) {
                    return (argDef.type & 0x4000000) != 0;
                }
                return (argDef.type & 0x2000000) != 0;
            }

            private boolean checkArgsDef(RAst.FCallArgMatch args, boolean guess, int relevance) {
                ArgsDefinition.Arg argDef = args.getArgDef(this.val$argIdx);
                if (argDef != null) {
                    boolean typedDef;
                    boolean bl = typedDef = argDef.type != 0;
                    if (RElementCompletionComputer.this.pkgNamePrio == Integer.MIN_VALUE) {
                        if (typedDef) {
                            if ((argDef.type & 0x200) != 0 && this.isValidNameContext(argDef)) {
                                RElementCompletionComputer.this.pkgNamePrio = 40 + relevance;
                            }
                        } else if (guess && RElementCompletionComputer.this.inString && RElementCompletionComputer.this.isPackageArg(argDef.name)) {
                            RElementCompletionComputer.this.pkgNamePrio = 40 + relevance;
                        }
                    }
                    if (RElementCompletionComputer.this.helpTopicPrio == Integer.MIN_VALUE && typedDef && (argDef.type & 0x1000) != 0 && this.isValidNameContext(argDef)) {
                        RElementCompletionComputer.this.helpTopicPrio = 40 + relevance;
                    }
                    return typedDef;
                }
                return false;
            }

            @Override
            public void searchFDef(RFrameSearchPath searchPath) {
                super.searchFDef(searchPath);
                if (this.matchCount == 0 && this.coreFunction != null) {
                    FCall.Args callArgs = this.val$fCallInfo.getNode().getArgsChild();
                    ArgsDefinition coreDef = this.coreFunction.getArgs(this.getElementName().getSegmentName());
                    if (coreDef != null) {
                        this.checkArgsDef(RAst.matchArgs((FCall.Args)callArgs, (ArgsDefinition)coreDef), false, 0);
                    }
                }
            }

            @Override
            protected void handleMatch(IRMethod element, IRFrame frame, RFrameSearchPath.RFrameIterator iterator) {
                ArgsDefinition coreDef;
                FCall.Args callArgs;
                ArgsDefinition argsDef = element.getArgsDefinition();
                if (argsDef == null) {
                    return;
                }
                ++this.matchCount;
                int relevance = iterator.getRelevance();
                if (this.val$argName) {
                    int i = 0;
                    while (i < argsDef.size()) {
                        ArgsDefinition.Arg arg = argsDef.get(i);
                        if (arg.name != null && arg.name.length() > 0 && !arg.name.equals("...") && (this.val$prefixSegmentName == null || arg.name.startsWith(this.val$prefixSegmentName)) && this.argNames.add(arg.name)) {
                            RElementName name = RElementName.create((int)17, (String)arg.name);
                            this.val$proposals.add((IAssistCompletionProposal)new RElementCompletionProposal.ArgumentProposal(this.val$context, (ElementName)name, this.val$offset, (IRElement)element, 80 + relevance, RElementCompletionComputer.this.labelProvider));
                        }
                        ++i;
                    }
                }
                if (this.val$argValue && !this.checkArgsDef(RAst.matchArgs((FCall.Args)(callArgs = this.val$fCallInfo.getNode().getArgsChild()), (ArgsDefinition)argsDef), true, relevance) && frame.getFrameType() == 2 && this.coreFunction != null && this.coreFunction.getPackageNames().contains((Object)frame.getElementName().getSegmentName()) && (coreDef = this.coreFunction.getArgs(this.getElementName().getSegmentName())) != null) {
                    this.checkArgsDef(RAst.matchArgs((FCall.Args)callArgs, (ArgsDefinition)coreDef), false, relevance);
                }
            }
        }
        FCallHandler search = new FCallHandler(fCallInfo, argIdx, argName, prefixSegmentName, proposals, context, offset, argValue);
        search.searchFDef(fCallInfo.getSearchPath(this.getSearchMode(context)));
    }

    protected IRCoreAccess getRCoreAccess() {
        return this.editor.getRCoreAccess();
    }

    protected final @Nullable RPkgManagerDataset getRPkgDataset() {
        IRPkgManager manager = RCore.getRPkgManager((REnv)this.getRCoreAccess().getREnv());
        if (manager != null) {
            return manager.getDataset();
        }
        return null;
    }

    protected final boolean isPackageName(RElementName elementName) {
        return (elementName.getType() == 17 || RElementName.isPackageFacetScopeType((int)elementName.getType())) && elementName.getNextSegment() == null;
    }

    protected final void doComputePkgNameProposals(RAssistInvocationContext context, int prio, AssistProposalCollector proposals) {
        Object envNames;
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (prefixName.getScope() != null || !this.isSymbolCandidate(prefixSegmentName)) {
            return;
        }
        RPkgManagerDataset rPkgDataset = this.getRPkgDataset();
        RSymbolComparator.PrefixPattern pattern = new RSymbolComparator.PrefixPattern(prefixSegmentName);
        int offset = context.getInvocationOffset() - prefixSegmentName.length();
        if (rPkgDataset != null) {
            RPkgCompilation pkgs = rPkgDataset.getInstalled();
            envNames = pkgs.getNames();
            Iterator iterator = envNames.iterator();
            while (iterator.hasNext()) {
                String pkgName = (String)iterator.next();
                if (!pattern.matches(pkgName)) continue;
                proposals.add((IAssistCompletionProposal)new RElementCompletionProposal.RPkgProposal(context, (ElementName)RElementName.create((int)38, (String)pkgName), offset, (RPkgBuilt)pkgs.getFirst(pkgName), prio));
            }
        } else {
            envNames = ImCollections.emptySet();
        }
        Set workspaceNames = RModel.getRModelManager().getPkgNames();
        for (String pkgName : workspaceNames) {
            if (envNames.contains(pkgName) || !pattern.matches(pkgName)) continue;
            proposals.add((IAssistCompletionProposal)new RElementCompletionProposal.RPkgProposal(context, (ElementName)RElementName.create((int)38, (String)pkgName), offset, null, prio));
        }
    }

    protected final void doComputeHelpTopicProposals(RAssistInvocationContext context, String topicType, RAstNode node, int prio, AssistProposalCollector proposals) {
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (topicType == null && (prefixName.getScope() != null || prefixSegmentName.isEmpty())) {
            return;
        }
        REnv rEnv = this.getRCoreAccess().getREnv();
        if (rEnv == null) {
            return;
        }
        HashMap<String, Object> matches = new HashMap<String, Object>();
        RHelpManager rHelpManager = RCore.getRHelpManager();
        REnvHelp help = rHelpManager.getHelp(rEnv);
        if (help != null) {
            try {
                RSymbolComparator.PrefixPattern pattern = new RSymbolComparator.PrefixPattern(prefixSegmentName);
                BiFunction<Object, Object, Object> mergeFun = (oldValue, newValue) -> {
                    ArrayList<Object> list;
                    if (oldValue instanceof List) {
                        list = (ArrayList<Object>)oldValue;
                    } else {
                        list = new ArrayList<Object>(4);
                        list.add(oldValue);
                    }
                    list.add(newValue);
                    return list;
                };
                this.searchPath.init(context, node, this.getSearchMode(context), prefixName.getScope());
                HashSet<String> pkgNames = new HashSet<String>();
                for (IRFrame frame : this.searchPath) {
                    RPkgHelp pkgHelp;
                    String pkgName;
                    if (frame.getFrameType() != 2 || (pkgName = frame.getElementName().getSegmentName()) == null || !pkgNames.add(pkgName) || (pkgHelp = help.getPkgHelp(pkgName)) == null) continue;
                    for (RHelpTopicEntry topicEntry : pkgHelp.getTopics()) {
                        String topic = topicEntry.getTopic();
                        if (!pattern.matches(topic)) continue;
                        matches.merge(topic, pkgName, mergeFun);
                    }
                }
            }
            finally {
                help.unlock();
            }
        }
        int offset = context.getInvocationContentType() != "R.Default" ? context.getIdentifierLastSegmentOffset() + 1 : context.getIdentifierLastSegmentOffset();
        for (Map.Entry match : matches.entrySet()) {
            proposals.add((IAssistCompletionProposal)new RSimpleCompletionProposal.RHelpTopicCompletionProposal(context, (String)match.getKey(), RElementCompletionComputer.toString(match.getValue()), offset, prio));
        }
    }

    public static class CompleteRuntime
    extends RElementCompletionComputer {
        public CompleteRuntime() {
            super(3);
        }
    }
}

