/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.client;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.impl.RLanguageImpl;
import org.eclipse.statet.rj.data.impl.RNullImpl;
import org.eclipse.statet.rj.server.client.AbstractRJComClient;
import org.eclipse.statet.rj.services.FunctionCall;

@NonNullByDefault
public class FunctionCallImpl
implements FunctionCall {
    private final String name;
    private final List<@Nullable String> argNames = new ArrayList<String>();
    private final List<RObject> argValues = new ArrayList<RObject>();
    private final AbstractRJComClient rjs;
    private final RObjectFactory rObjectFactory;

    public FunctionCallImpl(AbstractRJComClient client, String name, RObjectFactory rObjectFactory) {
        this.rjs = client;
        this.rObjectFactory = rObjectFactory;
        this.name = name;
    }

    public FunctionCall add(@Nullable String arg, String expression) {
        if (expression == null) {
            throw new NullPointerException();
        }
        this.argNames.add(arg);
        RLanguageImpl data = new RLanguageImpl(0, expression, null);
        this.argValues.add((RObject)data);
        return this;
    }

    public FunctionCall add(String expression) {
        return this.add(null, expression);
    }

    public FunctionCall add(@Nullable String arg, RObject data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.argNames.add(arg);
        this.argValues.add(data);
        return this;
    }

    public FunctionCall add(RObject data) {
        return this.add(null, data);
    }

    public FunctionCall addLogi(@Nullable String arg, boolean logical) {
        RVector data = this.rObjectFactory.createVector((RStore)this.rObjectFactory.createLogiData(new boolean[]{logical}));
        this.argNames.add(arg);
        this.argValues.add((RObject)data);
        return this;
    }

    public FunctionCall addLogi(boolean logical) {
        return this.addLogi(null, logical);
    }

    public FunctionCall addInt(@Nullable String arg, int integer) {
        RVector data = this.rObjectFactory.createVector((RStore)this.rObjectFactory.createIntData(new int[]{integer}));
        this.argNames.add(arg);
        this.argValues.add((RObject)data);
        return this;
    }

    public FunctionCall addInt(int integer) {
        return this.addInt(null, integer);
    }

    public FunctionCall addNum(@Nullable String arg, double numeric) {
        RVector data = this.rObjectFactory.createVector((RStore)this.rObjectFactory.createNumData(new double[]{numeric}));
        this.argNames.add(arg);
        this.argValues.add((RObject)data);
        return this;
    }

    public FunctionCall addNum(double numeric) {
        return this.addNum(null, numeric);
    }

    public FunctionCall addChar(@Nullable String arg, String character) {
        RVector data = this.rObjectFactory.createVector((RStore)this.rObjectFactory.createCharData(new String[]{character}));
        this.argNames.add(arg);
        this.argValues.add((RObject)data);
        return this;
    }

    public FunctionCall addChar(String character) {
        return this.addChar(null, character);
    }

    public FunctionCall addCplx(@Nullable String arg, double real, double imaginary) {
        RVector data = this.rObjectFactory.createVector((RStore)this.rObjectFactory.createCplxData(new double[]{real}, new double[]{imaginary}));
        this.argNames.add(arg);
        this.argValues.add((RObject)data);
        return this;
    }

    public FunctionCall addCplx(double real, double imaginary) {
        return this.addCplx(null, real, imaginary);
    }

    public FunctionCall addNull(@Nullable String arg) {
        this.argNames.add(arg);
        this.argValues.add((RObject)RNullImpl.INSTANCE);
        return this;
    }

    public FunctionCall addNull() {
        return this.addNull(null);
    }

    private RList prepareArgs(ProgressMonitor m) throws StatusException {
        String[] names = this.argNames.toArray(new String[this.argNames.size()]);
        RObject[] values = this.argValues.toArray(new RObject[this.argValues.size()]);
        assert (names.length == values.length);
        return this.rObjectFactory.createList(values, names);
    }

    public void evalVoid(ProgressMonitor m) throws StatusException {
        RList args = this.prepareArgs(m);
        this.rjs.evalVoid(this.name, args, null, m);
    }

    public void evalVoid(@Nullable RObject envir, ProgressMonitor m) throws StatusException {
        RList args = this.prepareArgs(m);
        this.rjs.evalVoid(this.name, args, envir, m);
    }

    public RObject evalData(ProgressMonitor m) throws StatusException {
        RList args = this.prepareArgs(m);
        return this.rjs.evalData(this.name, (RObject)args, null, null, 0, -1, m);
    }

    public RObject evalData(@Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        RList args = this.prepareArgs(m);
        return this.rjs.evalData(this.name, (RObject)args, null, factoryId, options, depth, m);
    }

    public RObject evalData(@Nullable RObject envir, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        RList args = this.prepareArgs(m);
        return this.rjs.evalData(this.name, (RObject)args, envir, factoryId, options, depth, m);
    }

    public void evalAssign(String target, ProgressMonitor m) throws StatusException {
        RList args = this.prepareArgs(m);
        this.rjs.assignData(this.name, (RObject)args, target, null, m);
    }

    public String toString() {
        StringBuilder call = new StringBuilder();
        call.append(this.name);
        call.append('(');
        if (this.argNames.size() > 0) {
            int i = 0;
            while (i < this.argNames.size()) {
                RObject value;
                String argName = this.argNames.get(i);
                if (argName != null) {
                    call.append('\n');
                    call.append(argName);
                    call.append("= ");
                }
                if ((value = this.argValues.get(i)) instanceof String) {
                    call.append((String)value);
                } else if (value instanceof RObject) {
                    call.append("\n<DATA>\n");
                    call.append(value.toString());
                    call.append("\n</DATA>");
                }
                ++i;
            }
            call.append("\n");
        }
        call.append(')');
        return call.toString();
    }
}

