/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data;

import org.eclipse.statet.rj.data.RStore;

public interface RComplexStore
extends RStore<Complex> {
    public boolean isNaN(int var1);

    public boolean isNaN(long var1);

    @Override
    public Complex get(int var1);

    @Override
    public Complex get(long var1);

    public Complex[] toArray();

    public static final class Complex {
        private final double realValue;
        private final double imaginaryValue;

        public Complex(double real, double imaginary) {
            this.realValue = real;
            this.imaginaryValue = imaginary;
        }

        public double getRe() {
            return this.realValue;
        }

        public double getIm() {
            return this.imaginaryValue;
        }

        public int hashCode() {
            long realBits = Double.doubleToLongBits(this.realValue);
            long imaginaryBits = Double.doubleToLongBits(this.imaginaryValue) + 1L;
            return (int)(realBits ^ realBits >>> 32 | imaginaryBits ^ imaginaryBits >>> 32);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Complex)) {
                return false;
            }
            Complex other = (Complex)obj;
            return this.realValue == other.realValue && this.imaginaryValue == other.imaginaryValue;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append(Double.toString(this.realValue));
            if (this.imaginaryValue >= 0.0) {
                sb.append('+');
            }
            sb.append(Double.toString(this.imaginaryValue));
            sb.append('i');
            return sb.toString();
        }
    }
}

