/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractFactorStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RCharacterFix64Store;
import org.eclipse.statet.rj.data.impl.RUniqueCharacter32Store;

public class RFactorFix64Store
extends AbstractFactorStore
implements ExternalizableRStore {
    public static final int SEGMENT_LENGTH = 0x10000000;
    private final long length;
    protected final int[][] codes;
    protected final RCharacter32Store codeLabels;

    public RFactorFix64Store(long length, boolean isOrdered, String[] levelLabels) {
        this.length = length;
        this.isOrdered = isOrdered;
        this.codes = RFactorFix64Store.new2dIntArray(length, 0x10000000);
        Arrays.fill((Object[])this.codes, (Object)Integer.MIN_VALUE);
        this.codeLabels = new RUniqueCharacter32Store(levelLabels);
    }

    public RFactorFix64Store(int[][] codes, boolean isOrdered, String[] levelLabels) {
        this.length = RFactorFix64Store.check2dArrayLength(codes, 0x10000000);
        this.isOrdered = isOrdered;
        this.codes = codes;
        this.codeLabels = new RUniqueCharacter32Store(levelLabels);
    }

    public RFactorFix64Store(RJIO io, long length) throws IOException {
        this.length = length;
        this.isOrdered = io.readBoolean();
        this.codes = RFactorFix64Store.new2dIntArray(length, 0x10000000);
        int i = 0;
        while (i < this.codes.length) {
            io.readIntData(this.codes[i], this.codes[i].length);
            ++i;
        }
        this.codeLabels = this.readLabels(io, io.readInt());
    }

    protected RCharacter32Store readLabels(RJIO io, int l) throws IOException {
        return new RUniqueCharacter32Store(io, l);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeBoolean(this.isOrdered);
        int i = 0;
        while (i < this.codes.length) {
            io.writeIntData(this.codes[i], this.codes[i].length);
            ++i;
        }
        io.writeInt(this.codeLabels.length());
        this.codeLabels.writeExternal(io);
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.codes[idx / 0x10000000][idx % 0x10000000] <= 0;
    }

    @Override
    public boolean isNA(long idx) {
        return this.codes[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] <= 0;
    }

    @Override
    public void setNA(int idx) {
        this.codes[idx / 0x10000000][idx % 0x10000000] = Integer.MIN_VALUE;
    }

    @Override
    public void setNA(long idx) {
        this.codes[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = Integer.MIN_VALUE;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.codes[idx / 0x10000000][idx % 0x10000000] <= 0;
    }

    @Override
    public boolean isMissing(long idx) {
        return this.codes[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] <= 0;
    }

    @Override
    public int getInt(int idx) {
        return this.codes[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public int getInt(long idx) {
        return this.codes[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public void setInt(int idx, int code) {
        if (code <= 0 || code > this.codeLabels.length()) {
            throw new IllegalArgumentException();
        }
        this.codes[idx / 0x10000000][idx % 0x10000000] = code;
    }

    @Override
    public void setInt(long idx, int code) {
        if (code <= 0 || code > this.codeLabels.length()) {
            throw new IllegalArgumentException();
        }
        this.codes[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = code;
    }

    @Override
    public String getChar(int idx) {
        int code = this.codes[idx / 0x10000000][idx % 0x10000000];
        return code > 0 ? this.codeLabels.getChar(code - 1) : null;
    }

    @Override
    public String getChar(long idx) {
        int code = this.codes[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
        return code > 0 ? this.codeLabels.getChar(code - 1) : null;
    }

    @Override
    public void setChar(int idx, String data) {
        int code = this.codeLabels.indexOf(data, 0) + 1;
        if (code <= 0) {
            throw new IllegalArgumentException();
        }
        this.codes[idx / 0x10000000][idx % 0x10000000] = code;
    }

    @Override
    public void setChar(long idx, String data) {
        int code = this.codeLabels.indexOf(data, 0) + 1;
        if (code <= 0) {
            throw new IllegalArgumentException();
        }
        this.codes[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = code;
    }

    @Override
    public RCharacterStore getLevels() {
        return this.codeLabels;
    }

    @Override
    public int getLevelCount() {
        return this.codeLabels.length();
    }

    @Override
    public RCharacterStore toCharacterData() {
        String[][] data = RFactorFix64Store.new2dStringArray(this.length, 0x10000000);
        int i = 0;
        while (i < data.length) {
            String[] chars = data[i];
            int[] ints = this.codes[i];
            int j = 0;
            while (j < ints.length) {
                int code = ints[j];
                if (code > 0) {
                    chars[j] = this.codeLabels.getChar(code - 1);
                }
                ++j;
            }
            ++i;
        }
        return new RCharacterFix64Store(data);
    }

    @Override
    public Integer get(int idx) {
        if (idx < 0 || (long)idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        int code = this.codes[idx / 0x10000000][idx % 0x10000000];
        return code > 0 ? Integer.valueOf(code) : null;
    }

    @Override
    public Integer get(long idx) {
        if (idx < 0L || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        int code = this.codes[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
        return code > 0 ? Integer.valueOf(code) : null;
    }

    @Override
    public Integer[] toArray() {
        int l = this.checkToArrayLength();
        Integer[] array = new Integer[l];
        int k = 0;
        int i = 0;
        while (i < this.codes.length) {
            int[] ints = this.codes[i];
            int j = 0;
            while (j < ints.length) {
                int code = ints[j];
                if (code > 0) {
                    array[k] = code;
                }
                ++j;
            }
            ++i;
            ++k;
        }
        return array;
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int i = (int)(fromIdx / 0x10000000L);
        int j = (int)(fromIdx % 0x10000000L);
        while (i < this.codes.length) {
            int[] ints = this.codes[i];
            while (j < ints.length) {
                if (ints[i] != Integer.MIN_VALUE) continue;
                return (long)i * 0x10000000L + (long)j;
            }
            ++i;
            j = 0;
        }
        return -1L;
    }

    @Override
    public long indexOf(int code, long fromIdx) {
        if (code <= 0 || code > this.codeLabels.length()) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int i = (int)(fromIdx / 0x10000000L);
        int j = (int)(fromIdx % 0x10000000L);
        while (i < this.codes.length) {
            int[] ints = this.codes[i];
            while (j < ints.length) {
                if (ints[i] != code) continue;
                return (long)i * 0x10000000L + (long)j;
            }
            ++i;
            j = 0;
        }
        return -1L;
    }

    @Override
    public long indexOf(String character, long fromIdx) {
        int code = (character != null ? this.codeLabels.indexOf(character, 0) : this.codeLabels.indexOfNA(0)) + 1;
        return this.indexOf(code, fromIdx);
    }

    @Override
    public boolean allEqual(RStore<?> other) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

