/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.yaml.core.model.SourceAnalyzer;
import org.eclipse.statet.internal.yaml.core.model.YamlModelManager;
import org.eclipse.statet.internal.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.ISourceModelStamp;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.impl.SourceModelStamp;
import org.eclipse.statet.yaml.core.ast.SourceComponent;
import org.eclipse.statet.yaml.core.ast.YamlParser;
import org.eclipse.statet.yaml.core.model.IYamlModelInfo;
import org.eclipse.statet.yaml.core.model.YamlProblemReporter;
import org.eclipse.statet.yaml.core.model.YamlSuModelContainer;

public class YamlReconciler {
    private final YamlModelManager yamlManager;
    protected boolean stop = false;
    private final Object f1AstLock = new Object();
    private final YamlParser f1Parser = new YamlParser();
    private final Object f2ModelLock = new Object();
    private final SourceAnalyzer f2SourceAnalyzer = new SourceAnalyzer();
    private final Object f3ReportLock = new Object();
    private final YamlProblemReporter f3ProblemReporter = new YamlProblemReporter();

    public YamlReconciler(YamlModelManager manager) {
        this.yamlManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(YamlSuModelContainer<?> adapter, int flags, IProgressMonitor monitor) {
        ISourceUnit su = adapter.getSourceUnit();
        Data data = new Data(adapter, monitor);
        if (data.content == null) {
            return;
        }
        Object object = this.f1AstLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            this.updateAst(data, flags, monitor);
        }
        if (this.stop || monitor.isCanceled() || (flags & 0xF) < 2) {
            return;
        }
        object = this.f2ModelLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            boolean updated = this.updateModel(data, flags, monitor);
            if (updated) {
                this.yamlManager.getEventJob().addUpdate((IModelElement)su, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            ProblemRequestor problemRequestor = null;
            Object object2 = this.f3ReportLock;
            synchronized (object2) {
                if (!this.stop && !monitor.isCanceled() && data.newModel == adapter.getCurrentModel() && (problemRequestor = adapter.createProblemRequestor()) != null) {
                    this.f3ProblemReporter.run(data.newModel, data.content, problemRequestor, flags, monitor);
                }
                if (problemRequestor != null) {
                    problemRequestor.finish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, int flags, IProgressMonitor monitor) {
        SourceModelStamp stamp = new SourceModelStamp(data.content.getStamp());
        data.ast = data.adapter.getCurrentAst();
        if (data.ast != null && !stamp.equals((Object)data.ast.getStamp())) {
            data.ast = null;
        }
        if (data.ast == null) {
            SourceComponent sourceNode = this.f1Parser.parse(data.content.getText());
            data.ast = new AstInfo(1, (ISourceModelStamp)stamp, (AstNode)sourceNode);
            YamlSuModelContainer<?> yamlSuModelContainer = data.adapter;
            synchronized (yamlSuModelContainer) {
                data.adapter.setAst(data.ast);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data, int flags, IProgressMonitor monitor) {
        data.newModel = (IYamlModelInfo)data.adapter.getCurrentModel();
        if (data.newModel != null && !data.ast.getStamp().equals(data.newModel.getStamp())) {
            data.newModel = null;
        }
        if (data.newModel == null) {
            boolean isOK;
            YamlSourceUnitModelInfo model = this.f2SourceAnalyzer.createModel(data.adapter.getSourceUnit(), data.content.getText(), data.ast);
            boolean bl = isOK = model != null;
            if (isOK) {
                YamlSuModelContainer<?> yamlSuModelContainer = data.adapter;
                synchronized (yamlSuModelContainer) {
                    data.oldModel = (IYamlModelInfo)data.adapter.getCurrentModel();
                    data.adapter.setModel(model);
                }
                data.newModel = model;
                return true;
            }
        }
        return false;
    }

    void stop() {
        this.stop = true;
    }

    protected static class Data {
        public final YamlSuModelContainer<?> adapter;
        public final SourceContent content;
        public int parseOffset;
        public AstInfo ast;
        public IYamlModelInfo oldModel;
        public IYamlModelInfo newModel;

        public Data(YamlSuModelContainer<?> adapter, IProgressMonitor monitor) {
            this.adapter = adapter;
            this.content = adapter.getParseContent(monitor);
        }
    }
}

