/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.model;

import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.ElementName;

@NonNullByDefault
public abstract class YamlElementName
implements ElementName {
    public static final byte RESOURCE = 1;
    public static final byte OTHER = 15;
    public static final byte TITLE = 17;
    public static final byte LABEL = 66;

    private static boolean equals(@Nullable String s1, @Nullable String s2) {
        return s1 == s2 || s1 != null && s1.hashCode() == s2.hashCode() && s1.equals(s2);
    }

    public static YamlElementName create(int type, String name) {
        return new Default(type, name);
    }

    public abstract @Nullable YamlElementName getNextSegment();

    public YamlElementName getLastSegment() {
        YamlElementName lastSegment;
        YamlElementName nextSegment = this;
        do {
            lastSegment = nextSegment;
        } while ((nextSegment = nextSegment.getNextSegment()) != null);
        return lastSegment;
    }

    public int hashCode() {
        String name = this.getSegmentName();
        YamlElementName next = this.getNextSegment();
        if (next != null) {
            return this.getType() * (name != null ? name.hashCode() : 1) * (((Object)next).hashCode() + 7);
        }
        return this.getType() * (name != null ? name.hashCode() : 1);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YamlElementName) {
            YamlElementName other = (YamlElementName)obj;
            return this.getType() == other.getType() && YamlElementName.equals(this.getSegmentName(), other.getSegmentName()) && Objects.equals(this.getNextSegment(), other.getNextSegment());
        }
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static class Default
    extends YamlElementName {
        protected final int type;
        protected final String segment;

        private Default(int type, String name) {
            this.type = type;
            this.segment = name;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public @Nullable YamlElementName getNextSegment() {
            return null;
        }

        public String getSegmentName() {
            return this.segment;
        }

        public String getDisplayName() {
            return this.segment;
        }
    }
}

